/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.arm.resources.AzureConfigurable;
import com.microsoft.azure.arm.resources.implementation.AzureConfigurableCoreImpl;
import com.microsoft.azure.arm.resources.implementation.ManagerCore;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.APIKeys;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.AnalyticsItems;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Annotations;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentAvailableFeatures;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentCurrentBillingFeatures;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentFeatureCapabilities;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentQuotaStatus;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Components;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ExportConfigurations;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Favorites;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Operations;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ProactiveDetectionConfigurations;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTestLocations;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemConfigurations;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbooks;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.APIKeysImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.AnalyticsItemsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.AnnotationsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentAvailableFeaturesImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentCurrentBillingFeaturesImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentFeatureCapabilitiesImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentQuotaStatusImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ExportConfigurationsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.FavoritesImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.OperationsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ProactiveDetectionConfigurationsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WebTestLocationsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WebTestsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkItemConfigurationsImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkbooksImpl;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;

public final class InsightsManager
extends ManagerCore<InsightsManager, ApplicationInsightsManagementClientImpl> {
    private Operations operations;
    private Annotations annotations;
    private APIKeys aPIKeys;
    private ExportConfigurations exportConfigurations;
    private ComponentCurrentBillingFeatures componentCurrentBillingFeatures;
    private ComponentQuotaStatus componentQuotaStatus;
    private ComponentFeatureCapabilities componentFeatureCapabilities;
    private ComponentAvailableFeatures componentAvailableFeatures;
    private ProactiveDetectionConfigurations proactiveDetectionConfigurations;
    private Components components;
    private WorkItemConfigurations workItemConfigurations;
    private Favorites favorites;
    private WebTestLocations webTestLocations;
    private WebTests webTests;
    private AnalyticsItems analyticsItems;
    private Workbooks workbooks;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static InsightsManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new InsightsManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).build(), subscriptionId);
    }

    public static InsightsManager authenticate(RestClient restClient, String subscriptionId) {
        return new InsightsManager(restClient, subscriptionId);
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this);
        }
        return this.operations;
    }

    public Annotations annotations() {
        if (this.annotations == null) {
            this.annotations = new AnnotationsImpl(this);
        }
        return this.annotations;
    }

    public APIKeys aPIKeys() {
        if (this.aPIKeys == null) {
            this.aPIKeys = new APIKeysImpl(this);
        }
        return this.aPIKeys;
    }

    public ExportConfigurations exportConfigurations() {
        if (this.exportConfigurations == null) {
            this.exportConfigurations = new ExportConfigurationsImpl(this);
        }
        return this.exportConfigurations;
    }

    public ComponentCurrentBillingFeatures componentCurrentBillingFeatures() {
        if (this.componentCurrentBillingFeatures == null) {
            this.componentCurrentBillingFeatures = new ComponentCurrentBillingFeaturesImpl(this);
        }
        return this.componentCurrentBillingFeatures;
    }

    public ComponentQuotaStatus componentQuotaStatus() {
        if (this.componentQuotaStatus == null) {
            this.componentQuotaStatus = new ComponentQuotaStatusImpl(this);
        }
        return this.componentQuotaStatus;
    }

    public ComponentFeatureCapabilities componentFeatureCapabilities() {
        if (this.componentFeatureCapabilities == null) {
            this.componentFeatureCapabilities = new ComponentFeatureCapabilitiesImpl(this);
        }
        return this.componentFeatureCapabilities;
    }

    public ComponentAvailableFeatures componentAvailableFeatures() {
        if (this.componentAvailableFeatures == null) {
            this.componentAvailableFeatures = new ComponentAvailableFeaturesImpl(this);
        }
        return this.componentAvailableFeatures;
    }

    public ProactiveDetectionConfigurations proactiveDetectionConfigurations() {
        if (this.proactiveDetectionConfigurations == null) {
            this.proactiveDetectionConfigurations = new ProactiveDetectionConfigurationsImpl(this);
        }
        return this.proactiveDetectionConfigurations;
    }

    public Components components() {
        if (this.components == null) {
            this.components = new ComponentsImpl(this);
        }
        return this.components;
    }

    public WorkItemConfigurations workItemConfigurations() {
        if (this.workItemConfigurations == null) {
            this.workItemConfigurations = new WorkItemConfigurationsImpl(this);
        }
        return this.workItemConfigurations;
    }

    public Favorites favorites() {
        if (this.favorites == null) {
            this.favorites = new FavoritesImpl(this);
        }
        return this.favorites;
    }

    public WebTestLocations webTestLocations() {
        if (this.webTestLocations == null) {
            this.webTestLocations = new WebTestLocationsImpl(this);
        }
        return this.webTestLocations;
    }

    public WebTests webTests() {
        if (this.webTests == null) {
            this.webTests = new WebTestsImpl(this);
        }
        return this.webTests;
    }

    public AnalyticsItems analyticsItems() {
        if (this.analyticsItems == null) {
            this.analyticsItems = new AnalyticsItemsImpl(this);
        }
        return this.analyticsItems;
    }

    public Workbooks workbooks() {
        if (this.workbooks == null) {
            this.workbooks = new WorkbooksImpl(this);
        }
        return this.workbooks;
    }

    private InsightsManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ApplicationInsightsManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableCoreImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public InsightsManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return InsightsManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public InsightsManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

