/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentProactiveDetectionConfigurationInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ProactiveDetectionConfigurationsInner {
    private ProactiveDetectionConfigurationsService service;
    private ApplicationInsightsManagementClientImpl client;

    public ProactiveDetectionConfigurationsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (ProactiveDetectionConfigurationsService)retrofit.create(ProactiveDetectionConfigurationsService.class);
        this.client = client;
    }

    public List<ApplicationInsightsComponentProactiveDetectionConfigurationInner> list(String resourceGroupName, String resourceName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> listAsync(String resourceGroupName, String resourceName, ServiceCallback<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>, List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>(){

            public List<ApplicationInsightsComponentProactiveDetectionConfigurationInner> call(ServiceResponse<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProactiveDetectionConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentProactiveDetectionConfigurationInner get(String resourceGroupName, String resourceName, String configurationId) {
        return (ApplicationInsightsComponentProactiveDetectionConfigurationInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, configurationId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentProactiveDetectionConfigurationInner> getAsync(String resourceGroupName, String resourceName, String configurationId, ServiceCallback<ApplicationInsightsComponentProactiveDetectionConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, configurationId), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentProactiveDetectionConfigurationInner> getAsync(String resourceGroupName, String resourceName, String configurationId) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, configurationId).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>, ApplicationInsightsComponentProactiveDetectionConfigurationInner>(){

            public ApplicationInsightsComponentProactiveDetectionConfigurationInner call(ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner> response) {
                return (ApplicationInsightsComponentProactiveDetectionConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String configurationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (configurationId == null) {
            throw new IllegalArgumentException("Parameter configurationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, configurationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProactiveDetectionConfigurationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentProactiveDetectionConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentProactiveDetectionConfigurationInner update(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        return (ApplicationInsightsComponentProactiveDetectionConfigurationInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentProactiveDetectionConfigurationInner> updateAsync(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties, ServiceCallback<ApplicationInsightsComponentProactiveDetectionConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentProactiveDetectionConfigurationInner> updateAsync(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>, ApplicationInsightsComponentProactiveDetectionConfigurationInner>(){

            public ApplicationInsightsComponentProactiveDetectionConfigurationInner call(ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner> response) {
                return (ApplicationInsightsComponentProactiveDetectionConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (configurationId == null) {
            throw new IllegalArgumentException("Parameter configurationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (proactiveDetectionProperties == null) {
            throw new IllegalArgumentException("Parameter proactiveDetectionProperties is required and cannot be null.");
        }
        Validator.validate((Object)proactiveDetectionProperties);
        return this.service.update(resourceGroupName, this.client.subscriptionId(), resourceName, configurationId, this.client.apiVersion(), proactiveDetectionProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProactiveDetectionConfigurationsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentProactiveDetectionConfigurationInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentProactiveDetectionConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProactiveDetectionConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ProactiveDetectionConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ProactiveDetectionConfigurations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="ConfigurationId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ProactiveDetectionConfigurations update"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="ConfigurationId") String var4, @Query(value="api-version") String var5, @Body ApplicationInsightsComponentProactiveDetectionConfigurationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

