/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.arm.collection.InnerSupportsDelete;
import com.microsoft.azure.arm.collection.InnerSupportsGet;
import com.microsoft.azure.arm.collection.InnerSupportsListing;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.TagsResource;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.PageImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WebTestInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class WebTestsInner
implements InnerSupportsGet<WebTestInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<WebTestInner> {
    private WebTestsService service;
    private ApplicationInsightsManagementClientImpl client;

    public WebTestsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (WebTestsService)retrofit.create(WebTestsService.class);
        this.client = client;
    }

    public PagedList<WebTestInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<WebTestInner>((Page)response.body()){

            public Page<WebTestInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebTestsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebTestInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<WebTestInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(String nextPageLink) {
                return WebTestsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebTestInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Page<WebTestInner>>(){

            public Page<WebTestInner> call(ServiceResponse<Page<WebTestInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(ServiceResponse<Page<WebTestInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebTestsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebTestsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebTestInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebTestInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebTestInner getByResourceGroup(String resourceGroupName, String webTestName) {
        return (WebTestInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, webTestName).toBlocking().single()).body());
    }

    public ServiceFuture<WebTestInner> getByResourceGroupAsync(String resourceGroupName, String webTestName, ServiceCallback<WebTestInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, webTestName), serviceCallback);
    }

    public Observable<WebTestInner> getByResourceGroupAsync(String resourceGroupName, String webTestName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, webTestName).map((Func1)new Func1<ServiceResponse<WebTestInner>, WebTestInner>(){

            public WebTestInner call(ServiceResponse<WebTestInner> response) {
                return (WebTestInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebTestInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String webTestName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (webTestName == null) {
            throw new IllegalArgumentException("Parameter webTestName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, this.client.subscriptionId(), webTestName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebTestInner>>>(){

            public Observable<ServiceResponse<WebTestInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebTestsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebTestInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebTestInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebTestInner createOrUpdate(String resourceGroupName, String webTestName, WebTestInner webTestDefinition) {
        return (WebTestInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, webTestName, webTestDefinition).toBlocking().single()).body());
    }

    public ServiceFuture<WebTestInner> createOrUpdateAsync(String resourceGroupName, String webTestName, WebTestInner webTestDefinition, ServiceCallback<WebTestInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, webTestName, webTestDefinition), serviceCallback);
    }

    public Observable<WebTestInner> createOrUpdateAsync(String resourceGroupName, String webTestName, WebTestInner webTestDefinition) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, webTestName, webTestDefinition).map((Func1)new Func1<ServiceResponse<WebTestInner>, WebTestInner>(){

            public WebTestInner call(ServiceResponse<WebTestInner> response) {
                return (WebTestInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebTestInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String webTestName, WebTestInner webTestDefinition) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (webTestName == null) {
            throw new IllegalArgumentException("Parameter webTestName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (webTestDefinition == null) {
            throw new IllegalArgumentException("Parameter webTestDefinition is required and cannot be null.");
        }
        Validator.validate((Object)((Object)webTestDefinition));
        return this.service.createOrUpdate(resourceGroupName, this.client.subscriptionId(), webTestName, this.client.apiVersion(), webTestDefinition, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebTestInner>>>(){

            public Observable<ServiceResponse<WebTestInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebTestsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebTestInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebTestInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebTestInner updateTags(String resourceGroupName, String webTestName) {
        return (WebTestInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, webTestName).toBlocking().single()).body());
    }

    public ServiceFuture<WebTestInner> updateTagsAsync(String resourceGroupName, String webTestName, ServiceCallback<WebTestInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, webTestName), serviceCallback);
    }

    public Observable<WebTestInner> updateTagsAsync(String resourceGroupName, String webTestName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, webTestName).map((Func1)new Func1<ServiceResponse<WebTestInner>, WebTestInner>(){

            public WebTestInner call(ServiceResponse<WebTestInner> response) {
                return (WebTestInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebTestInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String webTestName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (webTestName == null) {
            throw new IllegalArgumentException("Parameter webTestName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        TagsResource webTestTags = new TagsResource();
        webTestTags.withTags(null);
        return this.service.updateTags(resourceGroupName, this.client.subscriptionId(), webTestName, this.client.apiVersion(), this.client.acceptLanguage(), webTestTags, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebTestInner>>>(){

            public Observable<ServiceResponse<WebTestInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebTestsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public WebTestInner updateTags(String resourceGroupName, String webTestName, Map<String, String> tags) {
        return (WebTestInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, webTestName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<WebTestInner> updateTagsAsync(String resourceGroupName, String webTestName, Map<String, String> tags, ServiceCallback<WebTestInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, webTestName, tags), serviceCallback);
    }

    public Observable<WebTestInner> updateTagsAsync(String resourceGroupName, String webTestName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, webTestName, tags).map((Func1)new Func1<ServiceResponse<WebTestInner>, WebTestInner>(){

            public WebTestInner call(ServiceResponse<WebTestInner> response) {
                return (WebTestInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebTestInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String webTestName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (webTestName == null) {
            throw new IllegalArgumentException("Parameter webTestName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        TagsResource webTestTags = new TagsResource();
        webTestTags.withTags(tags);
        return this.service.updateTags(resourceGroupName, this.client.subscriptionId(), webTestName, this.client.apiVersion(), this.client.acceptLanguage(), webTestTags, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebTestInner>>>(){

            public Observable<ServiceResponse<WebTestInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebTestsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebTestInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebTestInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String webTestName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, webTestName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String webTestName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, webTestName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String webTestName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, webTestName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String webTestName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (webTestName == null) {
            throw new IllegalArgumentException("Parameter webTestName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, webTestName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebTestsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebTestInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<WebTestInner>((Page)response.body()){

            public Page<WebTestInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebTestsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebTestInner>> listAsync(ListOperationCallback<WebTestInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(String nextPageLink) {
                return WebTestsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebTestInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Page<WebTestInner>>(){

            public Page<WebTestInner> call(ServiceResponse<Page<WebTestInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(ServiceResponse<Page<WebTestInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebTestsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebTestsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebTestInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebTestInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebTestInner> listByComponent(String componentName, String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByComponentSinglePageAsync(componentName, resourceGroupName).toBlocking().single();
        return new PagedList<WebTestInner>((Page)response.body()){

            public Page<WebTestInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebTestsInner.this.listByComponentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebTestInner>> listByComponentAsync(String componentName, String resourceGroupName, ListOperationCallback<WebTestInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByComponentSinglePageAsync(componentName, resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(String nextPageLink) {
                return WebTestsInner.this.listByComponentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebTestInner>> listByComponentAsync(String componentName, String resourceGroupName) {
        return this.listByComponentWithServiceResponseAsync(componentName, resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Page<WebTestInner>>(){

            public Page<WebTestInner> call(ServiceResponse<Page<WebTestInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByComponentWithServiceResponseAsync(String componentName, String resourceGroupName) {
        return this.listByComponentSinglePageAsync(componentName, resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(ServiceResponse<Page<WebTestInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebTestsInner.this.listByComponentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByComponentSinglePageAsync(String componentName, String resourceGroupName) {
        if (componentName == null) {
            throw new IllegalArgumentException("Parameter componentName is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByComponent(componentName, resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebTestsInner.this.listByComponentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebTestInner>> listByComponentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebTestInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebTestInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebTestInner>((Page)response.body()){

            public Page<WebTestInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebTestsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebTestInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<WebTestInner>> serviceFuture, ListOperationCallback<WebTestInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(String nextPageLink) {
                return WebTestsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebTestInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Page<WebTestInner>>(){

            public Page<WebTestInner> call(ServiceResponse<Page<WebTestInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(ServiceResponse<Page<WebTestInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebTestsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebTestsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebTestInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebTestInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebTestInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebTestInner>((Page)response.body()){

            public Page<WebTestInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebTestsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebTestInner>> listNextAsync(String nextPageLink, ServiceFuture<List<WebTestInner>> serviceFuture, ListOperationCallback<WebTestInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(String nextPageLink) {
                return WebTestsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebTestInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Page<WebTestInner>>(){

            public Page<WebTestInner> call(ServiceResponse<Page<WebTestInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(ServiceResponse<Page<WebTestInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebTestsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebTestsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebTestInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebTestInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebTestInner> listByComponentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByComponentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebTestInner>((Page)response.body()){

            public Page<WebTestInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebTestsInner.this.listByComponentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebTestInner>> listByComponentNextAsync(String nextPageLink, ServiceFuture<List<WebTestInner>> serviceFuture, ListOperationCallback<WebTestInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByComponentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(String nextPageLink) {
                return WebTestsInner.this.listByComponentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebTestInner>> listByComponentNextAsync(String nextPageLink) {
        return this.listByComponentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Page<WebTestInner>>(){

            public Page<WebTestInner> call(ServiceResponse<Page<WebTestInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByComponentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByComponentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WebTestInner>>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(ServiceResponse<Page<WebTestInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebTestsInner.this.listByComponentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebTestInner>>> listByComponentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByComponentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebTestInner>>>>(){

            public Observable<ServiceResponse<Page<WebTestInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebTestsInner.this.listByComponentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebTestInner>> listByComponentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebTestInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface WebTestsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="webTestName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="webTestName") String var3, @Query(value="api-version") String var4, @Body WebTestInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="webTestName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsResource var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="webTestName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Insights/webtests")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests listByComponent"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{componentName}/webtests")
        public Observable<Response<ResponseBody>> listByComponent(@Path(value="componentName") String var1, @Path(value="resourceGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WebTests listByComponentNext"})
        @GET
        public Observable<Response<ResponseBody>> listByComponentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

