/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemConfigurationErrorException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemCreateConfiguration;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.PageImpl1;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkItemConfigurationInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class WorkItemConfigurationsInner {
    private WorkItemConfigurationsService service;
    private ApplicationInsightsManagementClientImpl client;

    public WorkItemConfigurationsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (WorkItemConfigurationsService)retrofit.create(WorkItemConfigurationsService.class);
        this.client = client;
    }

    public List<WorkItemConfigurationInner> list(String resourceGroupName, String resourceName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<WorkItemConfigurationInner>> listAsync(String resourceGroupName, String resourceName, ServiceCallback<List<WorkItemConfigurationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<List<WorkItemConfigurationInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<List<WorkItemConfigurationInner>>, List<WorkItemConfigurationInner>>(){

            public List<WorkItemConfigurationInner> call(ServiceResponse<List<WorkItemConfigurationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<WorkItemConfigurationInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<WorkItemConfigurationInner>>>>(){

            public Observable<ServiceResponse<List<WorkItemConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkItemConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<WorkItemConfigurationInner>> listDelegate(Response<ResponseBody> response) throws WorkItemConfigurationErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<WorkItemConfigurationInner>>(){}.getType()).registerError(WorkItemConfigurationErrorException.class).build(response);
    }

    public WorkItemConfigurationInner create(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties) {
        return (WorkItemConfigurationInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, resourceName, workItemConfigurationProperties).toBlocking().single()).body();
    }

    public ServiceFuture<WorkItemConfigurationInner> createAsync(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties, ServiceCallback<WorkItemConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, resourceName, workItemConfigurationProperties), serviceCallback);
    }

    public Observable<WorkItemConfigurationInner> createAsync(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties) {
        return this.createWithServiceResponseAsync(resourceGroupName, resourceName, workItemConfigurationProperties).map((Func1)new Func1<ServiceResponse<WorkItemConfigurationInner>, WorkItemConfigurationInner>(){

            public WorkItemConfigurationInner call(ServiceResponse<WorkItemConfigurationInner> response) {
                return (WorkItemConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<WorkItemConfigurationInner>> createWithServiceResponseAsync(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (workItemConfigurationProperties == null) {
            throw new IllegalArgumentException("Parameter workItemConfigurationProperties is required and cannot be null.");
        }
        Validator.validate((Object)workItemConfigurationProperties);
        return this.service.create(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), workItemConfigurationProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkItemConfigurationInner>>>(){

            public Observable<ServiceResponse<WorkItemConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkItemConfigurationsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkItemConfigurationInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkItemConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WorkItemConfigurationInner getDefault(String resourceGroupName, String resourceName) {
        return (WorkItemConfigurationInner)((ServiceResponse)this.getDefaultWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<WorkItemConfigurationInner> getDefaultAsync(String resourceGroupName, String resourceName, ServiceCallback<WorkItemConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDefaultWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<WorkItemConfigurationInner> getDefaultAsync(String resourceGroupName, String resourceName) {
        return this.getDefaultWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<WorkItemConfigurationInner>, WorkItemConfigurationInner>(){

            public WorkItemConfigurationInner call(ServiceResponse<WorkItemConfigurationInner> response) {
                return (WorkItemConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<WorkItemConfigurationInner>> getDefaultWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getDefault(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkItemConfigurationInner>>>(){

            public Observable<ServiceResponse<WorkItemConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkItemConfigurationsInner.this.getDefaultDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(result.body(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkItemConfigurationInner> getDefaultDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkItemConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public Object delete(String resourceGroupName, String resourceName, String workItemConfigId) {
        return ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, workItemConfigId).toBlocking().single()).body();
    }

    public ServiceFuture<Object> deleteAsync(String resourceGroupName, String resourceName, String workItemConfigId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, workItemConfigId), serviceCallback);
    }

    public Observable<Object> deleteAsync(String resourceGroupName, String resourceName, String workItemConfigId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, workItemConfigId).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (workItemConfigId == null) {
            throw new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, this.client.subscriptionId(), resourceName, workItemConfigId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkItemConfigurationsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface WorkItemConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemConfigurations create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body WorkItemCreateConfiguration var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemConfigurations getDefault"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/DefaultWorkItemConfig")
        public Observable<Response<ResponseBody>> getDefault(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkItemConfigurations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="workItemConfigId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

