/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.arm.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.SharedTypeKind;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbook;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.IdParsingUtils;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.InsightsManager;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkbookInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkbooksInner;
import java.util.List;
import java.util.Map;
import rx.Observable;

class WorkbookImpl
extends CreatableUpdatableImpl<Workbook, WorkbookInner, WorkbookImpl>
implements Workbook,
Workbook.Definition,
Workbook.Update {
    private String resourceGroupName;
    private String resourceName;
    private final InsightsManager manager;

    WorkbookImpl(String name, InsightsManager manager) {
        super(name, (Object)new WorkbookInner());
        this.manager = manager;
        this.resourceName = name;
    }

    WorkbookImpl(WorkbookInner inner, InsightsManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.resourceName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroup");
        this.resourceName = IdParsingUtils.getValueFromIdByName(inner.id(), "workbooks");
    }

    public InsightsManager manager() {
        return this.manager;
    }

    public Observable<Workbook> createResourceAsync() {
        WorkbooksInner client = ((ApplicationInsightsManagementClientImpl)((Object)this.manager().inner())).workbooks();
        return client.createOrUpdateAsync(this.resourceGroupName, this.resourceName, (WorkbookInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<Workbook> updateResourceAsync() {
        WorkbooksInner client = ((ApplicationInsightsManagementClientImpl)((Object)this.manager().inner())).workbooks();
        return client.updateAsync(this.resourceGroupName, this.resourceName, (WorkbookInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<WorkbookInner> getInnerAsync() {
        WorkbooksInner client = ((ApplicationInsightsManagementClientImpl)((Object)this.manager().inner())).workbooks();
        return null;
    }

    public boolean isInCreateMode() {
        return ((WorkbookInner)((Object)this.inner())).id() == null;
    }

    @Override
    public String category() {
        return ((WorkbookInner)((Object)this.inner())).category();
    }

    @Override
    public String id() {
        return ((WorkbookInner)((Object)this.inner())).id();
    }

    @Override
    public SharedTypeKind kind() {
        return ((WorkbookInner)((Object)this.inner())).kind();
    }

    @Override
    public String location() {
        return ((WorkbookInner)((Object)this.inner())).location();
    }

    @Override
    public String name() {
        return ((WorkbookInner)((Object)this.inner())).name();
    }

    @Override
    public String serializedData() {
        return ((WorkbookInner)((Object)this.inner())).serializedData();
    }

    @Override
    public SharedTypeKind sharedTypeKind() {
        return ((WorkbookInner)((Object)this.inner())).sharedTypeKind();
    }

    @Override
    public String sourceResourceId() {
        return ((WorkbookInner)((Object)this.inner())).sourceResourceId();
    }

    @Override
    public Map<String, String> tags() {
        return ((WorkbookInner)((Object)this.inner())).getTags();
    }

    @Override
    public String timeModified() {
        return ((WorkbookInner)((Object)this.inner())).timeModified();
    }

    @Override
    public String type() {
        return ((WorkbookInner)((Object)this.inner())).type();
    }

    @Override
    public String userId() {
        return ((WorkbookInner)((Object)this.inner())).userId();
    }

    @Override
    public String version() {
        return ((WorkbookInner)((Object)this.inner())).version();
    }

    @Override
    public String workbookId() {
        return ((WorkbookInner)((Object)this.inner())).workbookId();
    }

    @Override
    public String workbookName() {
        return ((WorkbookInner)((Object)this.inner())).workbookName();
    }

    @Override
    public List<String> workbookTags() {
        return ((WorkbookInner)((Object)this.inner())).workbookTags();
    }

    @Override
    public WorkbookImpl withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public WorkbookImpl withCategory(String category) {
        ((WorkbookInner)((Object)this.inner())).withCategory(category);
        return this;
    }

    @Override
    public WorkbookImpl withLocation(String location) {
        ((WorkbookInner)((Object)this.inner())).withLocation(location);
        return this;
    }

    @Override
    public WorkbookImpl withSerializedData(String serializedData) {
        ((WorkbookInner)((Object)this.inner())).withSerializedData(serializedData);
        return this;
    }

    @Override
    public WorkbookImpl withSharedTypeKind(SharedTypeKind sharedTypeKind) {
        ((WorkbookInner)((Object)this.inner())).withSharedTypeKind(sharedTypeKind);
        return this;
    }

    @Override
    public WorkbookImpl withUserId(String userId) {
        ((WorkbookInner)((Object)this.inner())).withUserId(userId);
        return this;
    }

    @Override
    public WorkbookImpl withWorkbookId(String workbookId) {
        ((WorkbookInner)((Object)this.inner())).withWorkbookId(workbookId);
        return this;
    }

    @Override
    public WorkbookImpl withWorkbookName(String workbookName) {
        ((WorkbookInner)((Object)this.inner())).withWorkbookName(workbookName);
        return this;
    }

    @Override
    public WorkbookImpl withKind(SharedTypeKind kind) {
        ((WorkbookInner)((Object)this.inner())).withKind(kind);
        return this;
    }

    @Override
    public WorkbookImpl withSourceResourceId(String sourceResourceId) {
        ((WorkbookInner)((Object)this.inner())).withSourceResourceId(sourceResourceId);
        return this;
    }

    @Override
    public WorkbookImpl withTags(Map<String, String> tags) {
        ((WorkbookInner)((Object)this.inner())).withTags(tags);
        return this;
    }

    @Override
    public WorkbookImpl withVersion(String version) {
        ((WorkbookInner)((Object)this.inner())).withVersion(version);
        return this;
    }

    @Override
    public WorkbookImpl withWorkbookTags(List<String> workbookTags) {
        ((WorkbookInner)((Object)this.inner())).withWorkbookTags(workbookTags);
        return this;
    }
}

