/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.arm.collection.InnerSupportsDelete;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.CategoryType;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.WorkbookErrorException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.PageImpl1;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkbookInner;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class WorkbooksInner
implements InnerSupportsDelete<Void> {
    private WorkbooksService service;
    private ApplicationInsightsManagementClientImpl client;

    public WorkbooksInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (WorkbooksService)retrofit.create(WorkbooksService.class);
        this.client = client;
    }

    public List<WorkbookInner> listByResourceGroup(String resourceGroupName, CategoryType category) {
        return (List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, category).toBlocking().single()).body();
    }

    public ServiceFuture<List<WorkbookInner>> listByResourceGroupAsync(String resourceGroupName, CategoryType category, ServiceCallback<List<WorkbookInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, category), serviceCallback);
    }

    public Observable<List<WorkbookInner>> listByResourceGroupAsync(String resourceGroupName, CategoryType category) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, category).map((Func1)new Func1<ServiceResponse<List<WorkbookInner>>, List<WorkbookInner>>(){

            public List<WorkbookInner> call(ServiceResponse<List<WorkbookInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<WorkbookInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, CategoryType category) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (category == null) {
            throw new IllegalArgumentException("Parameter category is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        List tags = null;
        Boolean canFetchContent = null;
        String tagsConverted = this.client.serializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, category, tagsConverted, canFetchContent, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<WorkbookInner>>>>(){

            public Observable<ServiceResponse<List<WorkbookInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkbooksInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<WorkbookInner> listByResourceGroup(String resourceGroupName, CategoryType category, List<String> tags, Boolean canFetchContent) {
        return (List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, category, tags, canFetchContent).toBlocking().single()).body();
    }

    public ServiceFuture<List<WorkbookInner>> listByResourceGroupAsync(String resourceGroupName, CategoryType category, List<String> tags, Boolean canFetchContent, ServiceCallback<List<WorkbookInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, category, tags, canFetchContent), serviceCallback);
    }

    public Observable<List<WorkbookInner>> listByResourceGroupAsync(String resourceGroupName, CategoryType category, List<String> tags, Boolean canFetchContent) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, category, tags, canFetchContent).map((Func1)new Func1<ServiceResponse<List<WorkbookInner>>, List<WorkbookInner>>(){

            public List<WorkbookInner> call(ServiceResponse<List<WorkbookInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<WorkbookInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, CategoryType category, List<String> tags, Boolean canFetchContent) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (category == null) {
            throw new IllegalArgumentException("Parameter category is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        String tagsConverted = this.client.serializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, category, tagsConverted, canFetchContent, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<WorkbookInner>>>>(){

            public Observable<ServiceResponse<List<WorkbookInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkbooksInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<WorkbookInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws WorkbookErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<WorkbookInner>>(){}.getType()).registerError(WorkbookErrorException.class).build(response);
    }

    public WorkbookInner get(String resourceGroupName, String resourceName) {
        return (WorkbookInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<WorkbookInner> getAsync(String resourceGroupName, String resourceName, ServiceCallback<WorkbookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<WorkbookInner> getAsync(String resourceGroupName, String resourceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<WorkbookInner>, WorkbookInner>(){

            public WorkbookInner call(ServiceResponse<WorkbookInner> response) {
                return (WorkbookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkbookInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkbookInner>>>(){

            public Observable<ServiceResponse<WorkbookInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkbooksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkbookInner> getDelegate(Response<ResponseBody> response) throws WorkbookErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkbookInner>(){}.getType()).registerError(WorkbookErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkbooksInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws WorkbookErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(WorkbookErrorException.class).build(response);
    }

    public WorkbookInner createOrUpdate(String resourceGroupName, String resourceName, WorkbookInner workbookProperties) {
        return (WorkbookInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, workbookProperties).toBlocking().single()).body());
    }

    public ServiceFuture<WorkbookInner> createOrUpdateAsync(String resourceGroupName, String resourceName, WorkbookInner workbookProperties, ServiceCallback<WorkbookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, workbookProperties), serviceCallback);
    }

    public Observable<WorkbookInner> createOrUpdateAsync(String resourceGroupName, String resourceName, WorkbookInner workbookProperties) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, workbookProperties).map((Func1)new Func1<ServiceResponse<WorkbookInner>, WorkbookInner>(){

            public WorkbookInner call(ServiceResponse<WorkbookInner> response) {
                return (WorkbookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkbookInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, WorkbookInner workbookProperties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (workbookProperties == null) {
            throw new IllegalArgumentException("Parameter workbookProperties is required and cannot be null.");
        }
        Validator.validate((Object)((Object)workbookProperties));
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), workbookProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkbookInner>>>(){

            public Observable<ServiceResponse<WorkbookInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkbooksInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkbookInner> createOrUpdateDelegate(Response<ResponseBody> response) throws WorkbookErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkbookInner>(){}.getType()).register(201, new TypeToken<WorkbookInner>(){}.getType()).registerError(WorkbookErrorException.class).build(response);
    }

    public WorkbookInner update(String resourceGroupName, String resourceName, WorkbookInner workbookProperties) {
        return (WorkbookInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceName, workbookProperties).toBlocking().single()).body());
    }

    public ServiceFuture<WorkbookInner> updateAsync(String resourceGroupName, String resourceName, WorkbookInner workbookProperties, ServiceCallback<WorkbookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceName, workbookProperties), serviceCallback);
    }

    public Observable<WorkbookInner> updateAsync(String resourceGroupName, String resourceName, WorkbookInner workbookProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceName, workbookProperties).map((Func1)new Func1<ServiceResponse<WorkbookInner>, WorkbookInner>(){

            public WorkbookInner call(ServiceResponse<WorkbookInner> response) {
                return (WorkbookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkbookInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, WorkbookInner workbookProperties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (workbookProperties == null) {
            throw new IllegalArgumentException("Parameter workbookProperties is required and cannot be null.");
        }
        Validator.validate((Object)((Object)workbookProperties));
        return this.service.update(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), workbookProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkbookInner>>>(){

            public Observable<ServiceResponse<WorkbookInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkbooksInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkbookInner> updateDelegate(Response<ResponseBody> response) throws WorkbookErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkbookInner>(){}.getType()).registerError(WorkbookErrorException.class).build(response);
    }

    static interface WorkbooksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbooks listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="category") CategoryType var3, @Query(value="tags") String var4, @Query(value="canFetchContent") Boolean var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbooks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbooks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbooks createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body WorkbookInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Workbooks update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body WorkbookInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

