/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.collection.implementation;

import com.microsoft.azure.arm.collection.SupportsBatchCreation;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.CreatedResources;
import com.microsoft.azure.arm.model.Indexable;
import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.arm.resources.collection.implementation.CreatableWrappersImpl;
import com.microsoft.azure.arm.utils.Utils;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

public abstract class CreatableResourcesImpl<T extends Indexable, ImplT extends T, InnerT>
extends CreatableWrappersImpl<T, ImplT, InnerT>
implements SupportsBatchCreation<T> {
    protected CreatableResourcesImpl() {
    }

    @Override
    @SafeVarargs
    public final CreatedResources<T> create(Creatable<T> ... creatables) {
        return (CreatedResources)this.createAsyncNonStream(creatables).toBlocking().single();
    }

    @Override
    public final CreatedResources<T> create(List<Creatable<T>> creatables) {
        return (CreatedResources)this.createAsyncNonStream(creatables).toBlocking().single();
    }

    @Override
    @SafeVarargs
    public final Observable<Indexable> createAsync(Creatable<T> ... creatables) {
        CreatableUpdatableResourcesRootImpl rootResource = new CreatableUpdatableResourcesRootImpl();
        rootResource.addCreatableDependencies(creatables);
        return rootResource.createAsync();
    }

    @Override
    public final Observable<Indexable> createAsync(List<Creatable<T>> creatables) {
        CreatableUpdatableResourcesRootImpl rootResource = new CreatableUpdatableResourcesRootImpl();
        rootResource.addCreatableDependencies(creatables);
        return rootResource.createAsync();
    }

    @Override
    @SafeVarargs
    public final ServiceFuture<CreatedResources<T>> createAsync(ServiceCallback<CreatedResources<T>> callback, Creatable<T> ... creatables) {
        return ServiceFuture.fromBody(this.createAsyncNonStream(creatables), callback);
    }

    @Override
    public final ServiceFuture<CreatedResources<T>> createAsync(ServiceCallback<CreatedResources<T>> callback, List<Creatable<T>> creatables) {
        return ServiceFuture.fromBody(this.createAsyncNonStream(creatables), callback);
    }

    private Observable<CreatedResources<T>> createAsyncNonStream(List<Creatable<T>> creatables) {
        return Utils.rootResource(this.createAsync(creatables)).map(new Func1<CreatableUpdatableResourcesRoot<T>, CreatedResources<T>>(){

            public CreatedResources<T> call(CreatableUpdatableResourcesRoot<T> tCreatableUpdatableResourcesRoot) {
                return new CreatedResourcesImpl(tCreatableUpdatableResourcesRoot);
            }
        });
    }

    private Observable<CreatedResources<T>> createAsyncNonStream(Creatable<T> ... creatables) {
        return Utils.rootResource(this.createAsync(creatables)).map(new Func1<CreatableUpdatableResourcesRoot<T>, CreatedResources<T>>(){

            public CreatedResources<T> call(CreatableUpdatableResourcesRoot<T> tCreatableUpdatableResourcesRoot) {
                return new CreatedResourcesImpl(tCreatableUpdatableResourcesRoot);
            }
        });
    }

    private class CreatableUpdatableResourcesRootImpl<ResourceT extends Indexable>
    extends CreatableUpdatableImpl<CreatableUpdatableResourcesRoot<ResourceT>, Object, CreatableUpdatableResourcesRootImpl<ResourceT>>
    implements CreatableUpdatableResourcesRoot<ResourceT> {
        private List<String> keys;

        CreatableUpdatableResourcesRootImpl() {
            super("CreatableUpdatableResourcesRoot", null);
            this.keys = new ArrayList<String>();
        }

        @Override
        public List<ResourceT> createdTopLevelResources() {
            ArrayList resources = new ArrayList();
            for (String resourceKey : this.keys) {
                resources.add(this.taskResult(resourceKey));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public Indexable createdRelatedResource(String key) {
            return this.taskResult(key);
        }

        void addCreatableDependencies(Creatable<T> ... creatables) {
            for (Creatable item : creatables) {
                this.keys.add(this.addDependency(item));
            }
        }

        void addCreatableDependencies(List<Creatable<T>> creatables) {
            for (Creatable item : creatables) {
                this.keys.add(this.addDependency(item));
            }
        }

        @Override
        public Observable<CreatableUpdatableResourcesRoot<ResourceT>> createResourceAsync() {
            return Observable.just((Object)this);
        }

        @Override
        public Observable<CreatableUpdatableResourcesRoot<ResourceT>> updateResourceAsync() {
            return this.createResourceAsync();
        }

        @Override
        public boolean isInCreateMode() {
            return true;
        }

        @Override
        protected Observable<Object> getInnerAsync() {
            return null;
        }
    }

    static interface CreatableUpdatableResourcesRoot<ResourceT extends Indexable>
    extends Indexable {
        public List<ResourceT> createdTopLevelResources();

        public Indexable createdRelatedResource(String var1);
    }

    private class CreatedResourcesImpl<ResourceT extends Indexable>
    extends HashMap<String, ResourceT>
    implements CreatedResources<ResourceT> {
        private static final long serialVersionUID = -1360746896732289907L;
        private CreatableUpdatableResourcesRoot<ResourceT> creatableUpdatableResourcesRoot;

        CreatedResourcesImpl(CreatableUpdatableResourcesRoot<ResourceT> creatableUpdatableResourcesRoot) {
            this.creatableUpdatableResourcesRoot = creatableUpdatableResourcesRoot;
            for (Indexable resource : this.creatableUpdatableResourcesRoot.createdTopLevelResources()) {
                super.put(resource.key(), resource);
            }
        }

        @Override
        public Indexable createdRelatedResource(String key) {
            return this.creatableUpdatableResourcesRoot.createdRelatedResource(key);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceT put(String key, ResourceT value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceT remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends ResourceT> m) {
            throw new UnsupportedOperationException();
        }
    }
}

