/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.collection.implementation;

import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.resources.collection.implementation.ExternalChildResourceCollectionImpl;
import com.microsoft.azure.arm.resources.models.ExternalChildResource;
import com.microsoft.azure.arm.resources.models.implementation.ExternalChildResourceImpl;

public abstract class ExternalChildResourcesNonCachedImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ExternalChildResourceCollectionImpl<FluentModelTImpl, FluentModelT, InnerModelT, ParentImplT, ParentT> {
    protected ExternalChildResourcesNonCachedImpl(ParentImplT parent, TaskGroup parentTaskGroup, String childResourceName) {
        super(parent, parentTaskGroup, childResourceName);
    }

    protected final FluentModelTImpl prepareIndependentDefine(FluentModelTImpl model) {
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return model;
    }

    protected final FluentModelTImpl prepareInlineDefine(FluentModelTImpl model) {
        Object childResource = this.find(((ExternalChildResourceImpl)model).childResourceKey());
        if (childResource != null) {
            throw new IllegalArgumentException(this.pendingOperationMessage(((ExternalChildResourceImpl)model).name(), ((ExternalChildResourceImpl)model).childResourceKey()));
        }
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        this.childCollection.put(((ExternalChildResourceImpl)model).childResourceKey(), model);
        return super.prepareForFutureCommitOrPostRun(model);
    }

    protected final FluentModelTImpl prepareInlineUpdate(FluentModelTImpl model) {
        Object childResource = this.find(((ExternalChildResourceImpl)model).childResourceKey());
        if (childResource != null) {
            throw new IllegalArgumentException(this.pendingOperationMessage(((ExternalChildResourceImpl)model).name(), ((ExternalChildResourceImpl)model).childResourceKey()));
        }
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        this.childCollection.put(((ExternalChildResourceImpl)model).childResourceKey(), model);
        return super.prepareForFutureCommitOrPostRun(model);
    }

    protected final void prepareInlineRemove(FluentModelTImpl model) {
        Object childResource = this.find(((ExternalChildResourceImpl)model).childResourceKey());
        if (childResource != null) {
            throw new IllegalArgumentException(this.pendingOperationMessage(((ExternalChildResourceImpl)model).name(), ((ExternalChildResourceImpl)model).childResourceKey()));
        }
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
        this.childCollection.put(((ExternalChildResourceImpl)model).childResourceKey(), model);
        super.prepareForFutureCommitOrPostRun(model);
    }

    @Override
    protected final boolean clearAfterCommit() {
        return true;
    }

    private String pendingOperationMessage(String name, String key) {
        return "There is already an operation pending on the child resource ('" + this.childResourceName + "') with name (key) '" + name + " (" + key + ")'";
    }
}

