/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.models.implementation;

import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.arm.resources.ResourceUtilsCore;
import com.microsoft.azure.arm.resources.models.HasResourceGroup;
import com.microsoft.azure.arm.resources.models.IndependentChild;
import com.microsoft.azure.arm.resources.models.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import rx.Observable;

@LangDefinition
public abstract class IndependentChildImpl<FluentModelT extends IndependentChild<ManagerT>, FluentParentModelT extends Resource & HasResourceGroup, InnerModelT, FluentModelImplT extends IndependentChildImpl<FluentModelT, FluentParentModelT, InnerModelT, FluentModelImplT, ManagerT>, ManagerT>
extends CreatableUpdatableImpl<FluentModelT, InnerModelT, FluentModelImplT>
implements IndependentChild<ManagerT>,
IndependentChild.DefinitionStages.WithParentResource<FluentModelT, FluentParentModelT> {
    private String groupName;
    protected String parentName;
    private String creatableParentResourceKey;
    private final ManagerT manager;

    protected IndependentChildImpl(String name, InnerModelT innerObject, ManagerT manager) {
        super(name, innerObject);
        this.manager = manager;
    }

    @Override
    public ManagerT manager() {
        return this.manager;
    }

    @Override
    public String resourceGroupName() {
        if (this.groupName == null) {
            return ResourceUtilsCore.groupFromResourceId(this.id());
        }
        return this.groupName;
    }

    @Override
    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public FluentModelImplT withExistingParentResource(String groupName, String parentName) {
        this.groupName = groupName;
        this.parentName = parentName;
        return (FluentModelImplT)this;
    }

    public FluentModelImplT withExistingParentResource(FluentParentModelT existingParentResource) {
        return (FluentModelImplT)this.withExistingParentResource(((HasResourceGroup)existingParentResource).resourceGroupName(), existingParentResource.name());
    }

    public FluentModelImplT withNewParentResource(Creatable<FluentParentModelT> parentResourceCreatable) {
        if (this.creatableParentResourceKey == null) {
            this.creatableParentResourceKey = this.addDependency(parentResourceCreatable);
        }
        return (FluentModelImplT)this;
    }

    @Override
    public void setInner(InnerModelT inner) {
        super.setInner(inner);
        this.setParentName(inner);
    }

    @Override
    public Observable<FluentModelT> createResourceAsync() {
        if (this.creatableParentResourceKey != null) {
            Resource parentResource = (Resource)this.taskResult(this.creatableParentResourceKey);
            this.withExistingParentResource((FluentParentModelT)parentResource);
        }
        return this.createChildResourceAsync();
    }

    protected void setParentName(InnerModelT inner) {
        if (this.id() != null) {
            this.parentName = ResourceId.fromString(this.id()).parent().name();
        }
    }

    protected abstract Observable<FluentModelT> createChildResourceAsync();
}

