/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.PartitionKeyDefinition;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressCache;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PartitionKeyRangeGoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.cosmosdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternalHelper;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.ICollectionRoutingMapCache;
import com.microsoft.azure.cosmosdb.rx.internal.InvalidPartitionException;
import com.microsoft.azure.cosmosdb.rx.internal.NotFoundException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;
import rx.functions.Func1;

public class AddressResolver
implements IAddressResolver {
    private static Logger logger = LoggerFactory.getLogger(AddressResolver.class);
    private static final PartitionKeyRangeIdentity masterPartitionKeyRangeIdentity = new PartitionKeyRangeIdentity("M");
    private RxCollectionCache collectionCache;
    private ICollectionRoutingMapCache collectionRoutingMapCache;
    private IAddressCache addressCache;

    public void initializeCaches(RxCollectionCache collectionCache, ICollectionRoutingMapCache collectionRoutingMapCache, IAddressCache addressCache) {
        this.collectionCache = collectionCache;
        this.addressCache = addressCache;
        this.collectionRoutingMapCache = collectionRoutingMapCache;
    }

    @Override
    public Single<AddressInformation[]> resolveAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        Single<ResolutionResult> resultObs = this.resolveAddressesAndIdentityAsync(request, forceRefreshPartitionAddresses);
        return resultObs.flatMap(result -> {
            try {
                this.throwIfTargetChanged(request, result.TargetPartitionKeyRange);
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
            request.requestContext.resolvedPartitionKeyRange = result.TargetPartitionKeyRange;
            return Single.just((Object)result.Addresses);
        });
    }

    private static boolean isSameCollection(PartitionKeyRange initiallyResolved, PartitionKeyRange newlyResolved) {
        if (initiallyResolved == null) {
            throw new IllegalArgumentException("parent");
        }
        if (newlyResolved == null) {
            return false;
        }
        if (Strings.areEqual((String)initiallyResolved.getId(), (String)"M") && Strings.areEqual((String)newlyResolved.getId(), (String)"M")) {
            return true;
        }
        if (Strings.areEqual((String)initiallyResolved.getId(), (String)"M") || Strings.areEqual((String)newlyResolved.getId(), (String)"M")) {
            String message = "Request was resolved to master partition and then to server partition.";
            assert (false) : message;
            logger.warn(message);
            return false;
        }
        if (ResourceId.parse((String)initiallyResolved.getResourceId()).getDocumentCollection() != ResourceId.parse((String)newlyResolved.getResourceId()).getDocumentCollection()) {
            return false;
        }
        if (!(Strings.areEqual((String)initiallyResolved.getId(), (String)newlyResolved.getId()) || newlyResolved.getParents() != null && newlyResolved.getParents().contains(initiallyResolved.getId()))) {
            String message = "Request is targeted at a partition key range which is not child of previously targeted range.";
            assert (false) : message;
            logger.warn(message);
            return false;
        }
        return true;
    }

    private void throwIfTargetChanged(RxDocumentServiceRequest request, PartitionKeyRange targetRange) throws DocumentClientException {
        if (request.requestContext.resolvedPartitionKeyRange != null && !AddressResolver.isSameCollection(request.requestContext.resolvedPartitionKeyRange, targetRange)) {
            if (!request.getIsNameBased()) {
                String message = String.format("Target should not change for non name based requests. Previous target {}, Current {}", request.requestContext.resolvedPartitionKeyRange, targetRange);
                assert (false) : message;
                logger.warn(message);
            }
            request.requestContext.resolvedPartitionKeyRange = null;
            throw new InvalidPartitionException("Target for the request is invalid", request.getResourceAddress());
        }
    }

    private static void ensureRoutingMapPresent(RxDocumentServiceRequest request, CollectionRoutingMap routingMap, DocumentCollection collection) throws DocumentClientException {
        if (routingMap == null && request.getIsNameBased() && request.getPartitionKeyRangeIdentity() != null && request.getPartitionKeyRangeIdentity().getCollectionRid() != null) {
            logger.debug("Routing map for request with partitionkeyrageid {} was not found", (Object)request.getPartitionKeyRangeIdentity().toHeader());
            InvalidPartitionException invalidPartitionException = new InvalidPartitionException();
            BridgeInternal.setResourceAddress((DocumentClientException)invalidPartitionException, (String)request.getResourceAddress());
            throw invalidPartitionException;
        }
        if (routingMap == null) {
            logger.debug("Routing map was not found although collection cache is upto date for collection {}", (Object)collection.getResourceId());
            NotFoundException e = new NotFoundException();
            BridgeInternal.setResourceAddress((DocumentClientException)e, (String)request.getResourceAddress());
            throw e;
        }
    }

    private Single<ResolutionResult> tryResolveServerPartitionAsync(RxDocumentServiceRequest request, DocumentCollection collection, CollectionRoutingMap routingMap, boolean collectionCacheIsUptodate, boolean collectionRoutingMapCacheIsUptodate, boolean forceRefreshPartitionAddresses) {
        try {
            if (request.getPartitionKeyRangeIdentity() != null) {
                return this.tryResolveServerPartitionByPartitionKeyRangeIdAsync(request, collection, routingMap, collectionCacheIsUptodate, collectionRoutingMapCacheIsUptodate, forceRefreshPartitionAddresses);
            }
            if (!(request.getResourceType().isPartitioned() || request.getResourceType() == ResourceType.StoredProcedure && request.getOperationType() == OperationType.ExecuteJavaScript || request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Head)) {
                logger.error("Shouldn't come here for non partitioned resources. resourceType : {}, operationtype:{}, resourceaddress:{}", new Object[]{request.getResourceType(), request.getOperationType(), request.getResourceAddress()});
                return Single.error((Throwable)BridgeInternal.setResourceAddress((DocumentClientException)new InternalServerErrorException("Unknown server error occurred when processing this request."), (String)request.getResourceAddress()));
            }
            String partitionKeyString = (String)request.getHeaders().get("x-ms-documentdb-partitionkey");
            PartitionKeyRange range = partitionKeyString != null ? this.tryResolveServerPartitionByPartitionKey(request, partitionKeyString, collectionCacheIsUptodate, collection, routingMap) : this.tryResolveSinglePartitionCollection(request, routingMap, collectionCacheIsUptodate);
            if (range == null) {
                return null;
            }
            Single<AddressInformation[]> addressesObs = this.addressCache.tryGetAddresses(request, new PartitionKeyRangeIdentity(collection.getResourceId(), range.getId()), forceRefreshPartitionAddresses);
            return addressesObs.flatMap(addresses -> {
                if (addresses == null) {
                    logger.info("Could not resolve addresses for identity {}/{}. Potentially collection cache or routing map cache is outdated. Return null - upper logic will refresh and retry. ", (Object)new PartitionKeyRangeIdentity(collection.getResourceId(), range.getId()));
                    return Single.just(null);
                }
                return Single.just((Object)new ResolutionResult(range, (AddressInformation[])addresses));
            });
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
    }

    private PartitionKeyRange tryResolveSinglePartitionCollection(RxDocumentServiceRequest request, CollectionRoutingMap routingMap, boolean collectionCacheIsUptoDate) throws DocumentClientException {
        if (routingMap.getOrderedPartitionKeyRanges().size() == 1) {
            return (PartitionKeyRange)routingMap.getOrderedPartitionKeyRanges().get(0);
        }
        if (collectionCacheIsUptoDate) {
            throw (BadRequestException)BridgeInternal.setResourceAddress((DocumentClientException)new BadRequestException("PartitionKey value must be supplied for this operation."), (String)request.getResourceAddress());
        }
        return null;
    }

    private Single<ResolutionResult> resolveMasterResourceAddress(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        assert (ReplicatedResourceClient.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && request.getPartitionKeyRangeIdentity() == null);
        PartitionKeyRangeIdentity partitionKeyRangeIdentity = masterPartitionKeyRangeIdentity;
        Single<AddressInformation[]> addressesObs = this.addressCache.tryGetAddresses(request, partitionKeyRangeIdentity, forceRefreshPartitionAddresses);
        return addressesObs.flatMap(addresses -> {
            if (addresses == null) {
                logger.warn("Could not get addresses for master partition");
                NotFoundException e = new NotFoundException();
                BridgeInternal.setResourceAddress((DocumentClientException)e, (String)request.getResourceAddress());
                return Single.error((Throwable)e);
            }
            PartitionKeyRange partitionKeyRange = new PartitionKeyRange();
            partitionKeyRange.setId("M");
            return Single.just((Object)new ResolutionResult(partitionKeyRange, (AddressInformation[])addresses));
        });
    }

    private Single<RefreshState> getOrRefreshRoutingMap(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        RefreshState state = new RefreshState();
        state.collectionCacheIsUptoDate = !request.getIsNameBased() || request.getPartitionKeyRangeIdentity() != null && request.getPartitionKeyRangeIdentity().getCollectionRid() != null;
        state.collectionRoutingMapCacheIsUptoDate = false;
        Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
        Single stateObs = collectionObs.flatMap(collection -> {
            state.collection = collection;
            Single routingMapObs = this.collectionRoutingMapCache.tryLookupAsync(collection.getResourceId(), null, request.forceCollectionRoutingMapRefresh, request.properties);
            DocumentCollection underlyingCollection = collection;
            return routingMapObs.flatMap(routingMap -> {
                state.routingMap = routingMap;
                if (request.forcePartitionKeyRangeRefresh) {
                    state.collectionRoutingMapCacheIsUptoDate = true;
                    request.forcePartitionKeyRangeRefresh = false;
                    if (routingMap != null) {
                        return this.collectionRoutingMapCache.tryLookupAsync(underlyingCollection.getResourceId(), routingMap, request.properties).map(newRoutingMap -> {
                            state.routingMap = newRoutingMap;
                            return state;
                        });
                    }
                }
                return Single.just((Object)state);
            });
        });
        return stateObs.flatMap(newState -> {
            if (newState.routingMap == null && !newState.collectionCacheIsUptoDate) {
                request.forceNameCacheRefresh = true;
                newState.collectionCacheIsUptoDate = true;
                newState.collectionRoutingMapCacheIsUptoDate = false;
                Single newCollectionObs = this.collectionCache.resolveCollectionAsync(request);
                return newCollectionObs.flatMap(collection -> {
                    newState.collection = collection;
                    Single newRoutingMapObs = this.collectionRoutingMapCache.tryLookupAsync(collection.getResourceId(), null, request.properties);
                    return newRoutingMapObs.map(routingMap -> {
                        newState.routingMap = routingMap;
                        return newState;
                    });
                });
            }
            return Single.just((Object)newState);
        });
    }

    private Single<RefreshState> getStateWithNewRoutingMap(RefreshState state, Single<CollectionRoutingMap> routingMapSingle) {
        return routingMapSingle.map(r -> {
            state.routingMap = r;
            return state;
        });
    }

    private Single<ResolutionResult> resolveAddressesAndIdentityAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        if (ReplicatedResourceClient.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && request.getPartitionKeyRangeIdentity() == null) {
            return this.resolveMasterResourceAddress(request, forceRefreshPartitionAddresses);
        }
        Single<RefreshState> refreshStateObs = this.getOrRefreshRoutingMap(request, forceRefreshPartitionAddresses);
        return refreshStateObs.flatMap(state -> {
            try {
                AddressResolver.ensureRoutingMapPresent(request, state.routingMap, state.collection);
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
            Single<ResolutionResult> resultObs = this.tryResolveServerPartitionAsync(request, state.collection, state.routingMap, state.collectionCacheIsUptoDate, state.collectionRoutingMapCacheIsUptoDate, forceRefreshPartitionAddresses);
            return resultObs.flatMap(result -> {
                Func1 addCollectionRidIfNameBased = funcResolutionResult -> {
                    assert (funcResolutionResult != null);
                    if (request.getIsNameBased()) {
                        request.getHeaders().put("x-ms-documentdb-collection-rid", state.collection.getResourceId());
                    }
                    return Single.just((Object)funcResolutionResult);
                };
                if (result != null) {
                    return (Single)addCollectionRidIfNameBased.call(result);
                }
                assert (result == null);
                Func1 ensureCollectionRoutingMapCacheIsUptoDateFunc = funcState -> {
                    if (!funcState.collectionRoutingMapCacheIsUptoDate) {
                        funcState.collectionRoutingMapCacheIsUptoDate = true;
                        Single newRoutingMapObs = this.collectionRoutingMapCache.tryLookupAsync(funcState.collection.getResourceId(), funcState.routingMap, request.properties);
                        return this.getStateWithNewRoutingMap((RefreshState)funcState, (Single<CollectionRoutingMap>)newRoutingMapObs);
                    }
                    return Single.just((Object)state);
                };
                Func1 resolveServerPartition = funcState -> {
                    try {
                        AddressResolver.ensureRoutingMapPresent(request, funcState.routingMap, funcState.collection);
                    }
                    catch (Exception e) {
                        return Single.error((Throwable)e);
                    }
                    return this.tryResolveServerPartitionAsync(request, funcState.collection, funcState.routingMap, true, true, forceRefreshPartitionAddresses);
                };
                Func1 onNullThrowNotFound = funcResolutionResult -> {
                    if (funcResolutionResult == null) {
                        logger.debug("Couldn't route partitionkeyrange-oblivious request after retry/cache refresh. Collection doesn't exist.");
                        return Single.error((Throwable)BridgeInternal.setResourceAddress((DocumentClientException)new NotFoundException(), (String)request.getResourceAddress()));
                    }
                    return Single.just((Object)funcResolutionResult);
                };
                if (!state.collectionCacheIsUptoDate) {
                    request.forceNameCacheRefresh = true;
                    state.collectionCacheIsUptoDate = true;
                    Single newCollectionObs = this.collectionCache.resolveCollectionAsync(request);
                    Single newRefreshStateObs = newCollectionObs.flatMap(collection -> {
                        state.collection = collection;
                        if (collection.getResourceId() != state.routingMap.getCollectionUniqueId()) {
                            state.collectionRoutingMapCacheIsUptoDate = false;
                            Single newRoutingMap = this.collectionRoutingMapCache.tryLookupAsync(collection.getResourceId(), null, request.properties);
                            return this.getStateWithNewRoutingMap((RefreshState)state, (Single<CollectionRoutingMap>)newRoutingMap);
                        }
                        return Single.just((Object)state);
                    });
                    Single newResultObs = newRefreshStateObs.flatMap(arg_0 -> ((Func1)ensureCollectionRoutingMapCacheIsUptoDateFunc).call(arg_0)).flatMap(arg_0 -> ((Func1)resolveServerPartition).call(arg_0));
                    return newResultObs.flatMap(arg_0 -> ((Func1)onNullThrowNotFound).call(arg_0)).flatMap(arg_0 -> ((Func1)addCollectionRidIfNameBased).call(arg_0));
                }
                return ((Single)ensureCollectionRoutingMapCacheIsUptoDateFunc.call(state)).flatMap(arg_0 -> ((Func1)resolveServerPartition).call(arg_0)).flatMap(onNullThrowNotFound).flatMap(addCollectionRidIfNameBased);
            });
        });
    }

    private ResolutionResult handleRangeAddressResolutionFailure(RxDocumentServiceRequest request, boolean collectionCacheIsUpToDate, boolean routingMapCacheIsUpToDate, CollectionRoutingMap routingMap) throws DocumentClientException {
        if (collectionCacheIsUpToDate && routingMapCacheIsUpToDate || collectionCacheIsUpToDate && routingMap.IsGone(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId())) {
            String errorMessage = String.format("PartitionKeyRange with id %s in collection %s doesn't exist", request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId(), request.getPartitionKeyRangeIdentity().getCollectionRid());
            throw (PartitionKeyRangeGoneException)BridgeInternal.setResourceAddress((DocumentClientException)new PartitionKeyRangeGoneException(errorMessage), (String)request.getResourceAddress());
        }
        return null;
    }

    private <T> Single<T> returnOrError(Callable<T> function) {
        try {
            return Single.just(function.call());
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
    }

    private Single<ResolutionResult> tryResolveServerPartitionByPartitionKeyRangeIdAsync(RxDocumentServiceRequest request, DocumentCollection collection, CollectionRoutingMap routingMap, boolean collectionCacheIsUpToDate, boolean routingMapCacheIsUpToDate, boolean forceRefreshPartitionAddresses) {
        PartitionKeyRange partitionKeyRange = routingMap.getRangeByPartitionKeyRangeId(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId());
        if (partitionKeyRange == null) {
            logger.debug("Cannot resolve range '{}'", (Object)request.getPartitionKeyRangeIdentity().toHeader());
            return this.returnOrError(() -> this.handleRangeAddressResolutionFailure(request, collectionCacheIsUpToDate, routingMapCacheIsUpToDate, routingMap));
        }
        Single<AddressInformation[]> addressesObs = this.addressCache.tryGetAddresses(request, new PartitionKeyRangeIdentity(collection.getResourceId(), request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId()), forceRefreshPartitionAddresses);
        return addressesObs.flatMap(addresses -> {
            if (addresses == null) {
                logger.debug("Cannot resolve addresses for range '{}'", (Object)request.getPartitionKeyRangeIdentity().toHeader());
                try {
                    return Single.just((Object)this.handleRangeAddressResolutionFailure(request, collectionCacheIsUpToDate, routingMapCacheIsUpToDate, routingMap));
                }
                catch (DocumentClientException e) {
                    return Single.error((Throwable)e);
                }
            }
            return Single.just((Object)new ResolutionResult(partitionKeyRange, (AddressInformation[])addresses));
        });
    }

    private PartitionKeyRange tryResolveServerPartitionByPartitionKey(RxDocumentServiceRequest request, String partitionKeyString, boolean collectionCacheUptoDate, DocumentCollection collection, CollectionRoutingMap routingMap) throws DocumentClientException {
        PartitionKeyInternal partitionKey;
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (partitionKeyString == null) {
            throw new NullPointerException("partitionKeyString");
        }
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        if (routingMap == null) {
            throw new NullPointerException("routingMap");
        }
        try {
            partitionKey = PartitionKeyInternal.fromJsonString((String)partitionKeyString);
        }
        catch (Exception ex) {
            throw (BadRequestException)BridgeInternal.setResourceAddress((DocumentClientException)new BadRequestException(String.format("Partition key %s is invalid.", partitionKeyString), ex), (String)request.getResourceAddress());
        }
        if (partitionKey == null) {
            throw new InternalServerErrorException(String.format("partition key is null '%s'", partitionKeyString));
        }
        if (partitionKey.getComponents().size() == collection.getPartitionKey().getPaths().size()) {
            String effectivePartitionKey = PartitionKeyInternalHelper.getEffectivePartitionKeyString((PartitionKeyInternal)partitionKey, (PartitionKeyDefinition)collection.getPartitionKey());
            return routingMap.getRangeByEffectivePartitionKey(effectivePartitionKey);
        }
        if (collectionCacheUptoDate) {
            BadRequestException badRequestException = (BadRequestException)BridgeInternal.setResourceAddress((DocumentClientException)new BadRequestException("Partition key provided either doesn't correspond to definition in the collection or doesn't match partition key field values specified in the document."), (String)request.getResourceAddress());
            badRequestException.getResponseHeaders().put("x-ms-substatus", Integer.toString(1001));
            throw badRequestException;
        }
        logger.debug("Cannot compute effective partition key. Definition has '{}' paths, values supplied has '{}' paths. Will refresh cache and retry.", (Object)collection.getPartitionKey().getPaths().size(), (Object)partitionKey.getComponents().size());
        return null;
    }

    private class ResolutionResult {
        public final PartitionKeyRange TargetPartitionKeyRange;
        public final AddressInformation[] Addresses;

        public ResolutionResult(PartitionKeyRange targetPartitionKeyRange, AddressInformation[] addresses) {
            if (targetPartitionKeyRange == null) {
                throw new NullPointerException("targetPartitionKeyRange");
            }
            if (addresses == null) {
                throw new NullPointerException("addresses");
            }
            this.TargetPartitionKeyRange = targetPartitionKeyRange;
            this.Addresses = addresses;
        }
    }

    private class RefreshState {
        volatile boolean collectionCacheIsUptoDate;
        volatile boolean collectionRoutingMapCacheIsUptoDate;
        volatile DocumentCollection collection;
        volatile CollectionRoutingMap routingMap;
        volatile ResolutionResult resolutionResult;

        private RefreshState() {
        }
    }
}

