/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.Integers;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.SessionTokenHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressSelector;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.BarrierRequestHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReadMode;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestTimeoutException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResult;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TimeoutHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ComparatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.schedulers.Schedulers;

public class ConsistencyWriter {
    private static final int MAX_NUMBER_OF_WRITE_BARRIER_READ_RETRIES = 30;
    private static final int DELAY_BETWEEN_WRITE_BARRIER_CALLS_IN_MS = 30;
    private static final int MAX_SHORT_BARRIER_RETRIES_FOR_MULTI_REGION = 4;
    private static final int SHORT_BARRIER_RETRY_INTERVAL_IN_MS_FOR_MULTI_REGION = 10;
    private final Logger logger = LoggerFactory.getLogger(ConsistencyWriter.class);
    private final TransportClient transportClient;
    private final AddressSelector addressSelector;
    private final ISessionContainer sessionContainer;
    private final IAuthorizationTokenProvider authorizationTokenProvider;
    private final boolean useMultipleWriteLocations;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private final StoreReader storeReader;

    public ConsistencyWriter(AddressSelector addressSelector, ISessionContainer sessionContainer, TransportClient transportClient, IAuthorizationTokenProvider authorizationTokenProvider, GatewayServiceConfigurationReader serviceConfigReader, boolean useMultipleWriteLocations) {
        this.transportClient = transportClient;
        this.addressSelector = addressSelector;
        this.sessionContainer = sessionContainer;
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.useMultipleWriteLocations = useMultipleWriteLocations;
        this.serviceConfigReader = serviceConfigReader;
        this.storeReader = new StoreReader(transportClient, addressSelector, null);
    }

    public Single<StoreResponse> writeAsync(RxDocumentServiceRequest entity, TimeoutHelper timeout, boolean forceRefresh) {
        if (timeout.isElapsed()) {
            return Single.error((Throwable)new RequestTimeoutException());
        }
        String sessionToken = (String)entity.getHeaders().get("x-ms-session-token");
        return this.writePrivateAsync(entity, timeout, forceRefresh).doOnEach(arg -> {
            try {
                SessionTokenHelper.setOriginalSessionToken((RxDocumentServiceRequest)entity, (String)sessionToken);
            }
            catch (Throwable throwable) {
                this.logger.error("Unexpected failure in handling orig [{}]: new [{}]", new Object[]{arg, throwable.getMessage(), throwable});
            }
        });
    }

    Single<StoreResponse> writePrivateAsync(RxDocumentServiceRequest request, TimeoutHelper timeout, boolean forceRefresh) {
        if (timeout.isElapsed()) {
            return Single.error((Throwable)new RequestTimeoutException());
        }
        request.requestContext.timeoutHelper = timeout;
        if (request.requestContext.requestChargeTracker == null) {
            request.requestContext.requestChargeTracker = new RequestChargeTracker();
        }
        if (request.requestContext.clientSideRequestStatistics == null) {
            request.requestContext.clientSideRequestStatistics = new ClientSideRequestStatistics();
        }
        request.requestContext.forceRefreshAddressCache = forceRefresh;
        if (request.requestContext.globalStrongWriteResponse == null) {
            Single<List<AddressInformation>> replicaAddressesObs = this.addressSelector.resolveAddressesAsync(request, forceRefresh);
            AtomicReference primaryURI = new AtomicReference();
            return replicaAddressesObs.flatMap(replicaAddresses -> {
                try {
                    ArrayList contactedReplicas = new ArrayList();
                    replicaAddresses.forEach(replicaAddress -> contactedReplicas.add(HttpUtils.toURI((String)replicaAddress.getPhysicalUri())));
                    request.requestContext.clientSideRequestStatistics.setContactedReplicas(contactedReplicas);
                    return Single.just((Object)AddressSelector.getPrimaryUri(request, replicaAddresses));
                }
                catch (GoneException e) {
                    return Single.error((Throwable)e);
                }
            }).flatMap(primaryUri -> {
                try {
                    primaryURI.set(primaryUri);
                    if (this.useMultipleWriteLocations && RequestHelper.GetConsistencyLevelToUse(this.serviceConfigReader, request) == ConsistencyLevel.Session) {
                        SessionTokenHelper.setPartitionLocalSessionToken((RxDocumentServiceRequest)request, (ISessionContainer)this.sessionContainer);
                    } else {
                        SessionTokenHelper.validateAndRemoveSessionToken((RxDocumentServiceRequest)request);
                    }
                }
                catch (Exception e) {
                    return Single.error((Throwable)e);
                }
                return this.transportClient.invokeResourceOperationAsync((URI)primaryUri, request).doOnError(t -> {
                    try {
                        Integer result;
                        DocumentClientException ex = (DocumentClientException)((Object)((Object)((Object)Utils.as((Object)t, DocumentClientException.class))));
                        try {
                            request.requestContext.clientSideRequestStatistics.recordResponse(request, this.storeReader.createStoreResult(null, (Exception)((Object)ex), false, false, (URI)primaryUri));
                        }
                        catch (Exception e) {
                            this.logger.error("Error occurred while recording response", (Throwable)e);
                        }
                        String value = (String)ex.getResponseHeaders().get("x-ms-write-request-trigger-refresh");
                        if (!Strings.isNullOrWhiteSpace((String)value) && (result = Integers.tryParse((String)value)) != null && result == 1) {
                            this.startBackgroundAddressRefresh(request);
                        }
                    }
                    catch (Throwable throwable) {
                        this.logger.error("Unexpected failure in handling orig [{}]", (Object)t.getMessage(), t);
                        this.logger.error("Unexpected failure in handling orig [{}] : new [{}]", new Object[]{t.getMessage(), throwable.getMessage(), throwable});
                    }
                });
            }).flatMap(response -> {
                try {
                    request.requestContext.clientSideRequestStatistics.recordResponse(request, this.storeReader.createStoreResult((StoreResponse)response, null, false, false, (URI)primaryURI.get()));
                }
                catch (Exception e) {
                    this.logger.error("Error occurred while recording response", (Throwable)e);
                }
                return this.barrierForGlobalStrong(request, (StoreResponse)response);
            });
        }
        Single<RxDocumentServiceRequest> barrierRequestObs = BarrierRequestHelper.createAsync(request, this.authorizationTokenProvider, null, request.requestContext.globalCommittedSelectedLSN);
        return barrierRequestObs.flatMap(barrierRequest -> this.waitForWriteBarrierAsync((RxDocumentServiceRequest)barrierRequest, request.requestContext.globalCommittedSelectedLSN).flatMap(v -> {
            if (!v.booleanValue()) {
                this.logger.warn("ConsistencyWriter: Write barrier has not been met for global strong request. SelectedGlobalCommittedLsn: {}", (Object)request.requestContext.globalCommittedSelectedLSN);
                return Single.error((Throwable)new GoneException("Global Strong write barrier has not been met for the request."));
            }
            return Single.just((Object)request);
        })).map(req -> req.requestContext.globalStrongWriteResponse);
    }

    boolean isGlobalStrongRequest(RxDocumentServiceRequest request, StoreResponse response) {
        if (this.serviceConfigReader.getDefaultConsistencyLevel() == ConsistencyLevel.Strong) {
            int numberOfReadRegions = -1;
            String headerValue = null;
            headerValue = response.getHeaderValue("x-ms-number-of-read-regions");
            if (headerValue != null) {
                numberOfReadRegions = Integer.parseInt(headerValue);
            }
            if (numberOfReadRegions > 0 && this.serviceConfigReader.getDefaultConsistencyLevel() == ConsistencyLevel.Strong) {
                return true;
            }
        }
        return false;
    }

    Single<StoreResponse> barrierForGlobalStrong(RxDocumentServiceRequest request, StoreResponse response) {
        try {
            if (ReplicatedResourceClient.isGlobalStrongEnabled() && this.isGlobalStrongRequest(request, response)) {
                Utils.ValueHolder lsn = Utils.ValueHolder.initialize((Object)-1L);
                Utils.ValueHolder globalCommittedLsn = Utils.ValueHolder.initialize((Object)-1L);
                ConsistencyWriter.getLsnAndGlobalCommittedLsn(response, (Utils.ValueHolder<Long>)lsn, (Utils.ValueHolder<Long>)globalCommittedLsn);
                if ((Long)lsn.v == -1L || (Long)globalCommittedLsn.v == -1L) {
                    this.logger.error("ConsistencyWriter: lsn {} or GlobalCommittedLsn {} is not set for global strong request", (Object)lsn, (Object)globalCommittedLsn);
                    throw new GoneException("The requested resource is no longer available at the server.");
                }
                request.requestContext.globalStrongWriteResponse = response;
                request.requestContext.globalCommittedSelectedLSN = (Long)lsn.v;
                request.requestContext.forceRefreshAddressCache = false;
                this.logger.debug("ConsistencyWriter: globalCommittedLsn {}, lsn {}", (Object)globalCommittedLsn, (Object)lsn);
                if ((Long)globalCommittedLsn.v < (Long)lsn.v) {
                    Single<RxDocumentServiceRequest> barrierRequestObs = BarrierRequestHelper.createAsync(request, this.authorizationTokenProvider, null, request.requestContext.globalCommittedSelectedLSN);
                    return barrierRequestObs.flatMap(barrierRequest -> {
                        Single<Boolean> barrierWait = this.waitForWriteBarrierAsync((RxDocumentServiceRequest)barrierRequest, request.requestContext.globalCommittedSelectedLSN);
                        return barrierWait.flatMap(res -> {
                            if (!res.booleanValue()) {
                                this.logger.error("ConsistencyWriter: Write barrier has not been met for global strong request. SelectedGlobalCommittedLsn: {}", (Object)request.requestContext.globalCommittedSelectedLSN);
                                return Single.error((Throwable)new GoneException("Global Strong write barrier has not been met for the request."));
                            }
                            return Single.just((Object)request.requestContext.globalStrongWriteResponse);
                        });
                    });
                }
                return Single.just((Object)request.requestContext.globalStrongWriteResponse);
            }
            return Single.just((Object)response);
        }
        catch (DocumentClientException e) {
            return Single.error((Throwable)e);
        }
    }

    private Single<Boolean> waitForWriteBarrierAsync(RxDocumentServiceRequest barrierRequest, long selectedGlobalCommittedLsn) {
        AtomicInteger writeBarrierRetryCount = new AtomicInteger(30);
        AtomicLong maxGlobalCommittedLsnReceived = new AtomicLong(0L);
        return Observable.defer(() -> {
            if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                return Observable.error((Throwable)new RequestTimeoutException());
            }
            Single<List<StoreResult>> storeResultListObs = this.storeReader.readMultipleReplicaAsync(barrierRequest, true, 1, false, false, ReadMode.Strong, false, false);
            return storeResultListObs.toObservable().flatMap(responses -> {
                if (responses != null && responses.stream().anyMatch(response -> response.globalCommittedLSN >= selectedGlobalCommittedLsn)) {
                    return Observable.just((Object)Boolean.TRUE);
                }
                long maxGlobalCommittedLsn = responses != null || !responses.isEmpty() ? responses.stream().map(s -> s.globalCommittedLSN).max(ComparatorUtils.NATURAL_COMPARATOR).get() : 0L;
                maxGlobalCommittedLsnReceived.set(maxGlobalCommittedLsnReceived.get() > maxGlobalCommittedLsn ? maxGlobalCommittedLsnReceived.get() : maxGlobalCommittedLsn);
                barrierRequest.requestContext.forceRefreshAddressCache = false;
                if (writeBarrierRetryCount.getAndDecrement() == 0) {
                    this.logger.debug("ConsistencyWriter: WaitForWriteBarrierAsync - Last barrier multi-region strong. Responses: {}", (Object)String.join((CharSequence)"; ", responses.stream().map(r -> r.toString()).collect(Collectors.toList())));
                    this.logger.debug("ConsistencyWriter: Highest global committed lsn received for write barrier call is {}", (Object)maxGlobalCommittedLsnReceived);
                    return Observable.just((Object)false);
                }
                return Observable.empty();
            });
        }).repeatWhen(s -> s.flatMap(x -> {
            if (30 - writeBarrierRetryCount.get() > 4) {
                return Observable.timer((long)30L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            return Observable.timer((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        })).take(1).toSingle();
    }

    static void getLsnAndGlobalCommittedLsn(StoreResponse response, Utils.ValueHolder<Long> lsn, Utils.ValueHolder<Long> globalCommittedLsn) {
        lsn.v = -1L;
        globalCommittedLsn.v = -1L;
        String headerValue = response.getHeaderValue("lsn");
        if (headerValue != null) {
            lsn.v = Long.parseLong(headerValue);
        }
        if ((headerValue = response.getHeaderValue("x-ms-global-Committed-lsn")) != null) {
            globalCommittedLsn.v = Long.parseLong(headerValue);
        }
    }

    void startBackgroundAddressRefresh(RxDocumentServiceRequest request) {
        this.addressSelector.resolvePrimaryUriAsync(request, true).observeOn(Schedulers.io()).subscribe(r -> {}, e -> this.logger.warn("Background refresh of the primary address failed with {}", (Object)e.getMessage(), e));
    }
}

