/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.internal.directconnectivity.ResponseUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;

public class ErrorUtils {
    private static final Logger logger = LoggerFactory.getLogger(TransportClient.class);

    protected static Single<String> getErrorResponseAsync(HttpClientResponse<ByteBuf> responseMessage) {
        if (responseMessage.getContent() == null) {
            return Single.just((Object)"");
        }
        return ErrorUtils.getErrorFromStream((Observable<ByteBuf>)responseMessage.getContent());
    }

    protected static Single<String> getErrorFromStream(Observable<ByteBuf> stream) {
        return ResponseUtils.toString(stream).toSingle();
    }

    protected static void logGoneException(URI physicalAddress, String activityId) {
        logger.trace("Listener not found. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }

    protected static void logGoneException(String physicalAddress, String activityId) {
        logger.trace("Listener not found. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }

    protected static void logException(URI physicalAddress, String activityId) {
        logger.trace("Store Request Failed. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }

    protected static void logException(String physicalAddress, String activityId) {
        logger.trace("Store Request Failed. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }
}

