/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ResourceOperation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdMetrics;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdReporter;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestRecord;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdTransportClient
extends TransportClient
implements AutoCloseable {
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdTransportClient.class);
    private static final String namePrefix = RntbdTransportClient.class.getSimpleName() + '-';
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RntbdEndpoint.Provider endpointProvider;
    private final RntbdMetrics metrics;
    private final String name = namePrefix + instanceCount.incrementAndGet();

    RntbdTransportClient(RntbdEndpoint.Provider endpointProvider) {
        this.endpointProvider = endpointProvider;
        this.metrics = new RntbdMetrics(this.name);
    }

    RntbdTransportClient(Options options, SslContext sslContext) {
        this(new RntbdServiceEndpoint.Provider(options, sslContext));
    }

    RntbdTransportClient(Configs configs, int requestTimeoutInSeconds, UserAgentContainer userAgent) {
        this(new Options.Builder(requestTimeoutInSeconds).userAgent(userAgent).build(), configs.getSslContext());
    }

    @Override
    public void close() {
        logger.debug("\n  [{}] CLOSE", (Object)this);
        if (this.closed.compareAndSet(false, true)) {
            this.endpointProvider.close();
            this.metrics.close();
            return;
        }
        logger.debug("\n  [{}]\n  already closed", (Object)this);
    }

    @Override
    public Single<StoreResponse> invokeStoreAsync(URI physicalAddress, ResourceOperation unused, RxDocumentServiceRequest request) {
        Preconditions.checkNotNull((Object)physicalAddress, (Object)"physicalAddress");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        this.throwIfClosed();
        RntbdRequestArgs requestArgs = new RntbdRequestArgs(request, physicalAddress);
        if (logger.isDebugEnabled()) {
            requestArgs.traceOperation(logger, null, "invokeStoreAsync", new Object[0]);
            logger.debug("\n  [{}]\n  {}\n  INVOKE_STORE_ASYNC", (Object)this, (Object)requestArgs);
        }
        RntbdEndpoint endpoint = this.endpointProvider.get(physicalAddress);
        this.metrics.incrementRequestCount();
        RntbdRequestRecord requestRecord = endpoint.request(requestArgs);
        return Single.fromEmitter(emitter -> requestRecord.whenComplete((response, error) -> {
            requestArgs.traceOperation(logger, null, "emitSingle", response, error);
            this.metrics.incrementResponseCount();
            if (error == null) {
                emitter.onSuccess(response);
            } else {
                RntbdReporter.reportIssueUnless(error instanceof DocumentClientException, logger, requestRecord, "", error);
                this.metrics.incrementErrorResponseCount();
                emitter.onError(error);
            }
            requestArgs.traceOperation(logger, null, "emitSingleComplete", new Object[0]);
        }));
    }

    public String toString() {
        return RntbdObjectMapper.toJson(this);
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"%s is closed", (Object)this);
    }

    public static final class Options {
        private final String certificateHostNameOverride;
        private final int maxChannelsPerEndpoint;
        private final int maxRequestsPerChannel;
        private final Duration connectionTimeout;
        private final int partitionCount;
        private final Duration receiveHangDetectionTime;
        private final Duration requestTimeout;
        private final Duration sendHangDetectionTime;
        private final UserAgentContainer userAgent;

        private Options(Builder builder) {
            this.certificateHostNameOverride = builder.certificateHostNameOverride;
            this.maxChannelsPerEndpoint = builder.maxChannelsPerEndpoint;
            this.maxRequestsPerChannel = builder.maxRequestsPerChannel;
            this.connectionTimeout = builder.connectionTimeout == null ? builder.requestTimeout : builder.connectionTimeout;
            this.partitionCount = builder.partitionCount;
            this.requestTimeout = builder.requestTimeout;
            this.receiveHangDetectionTime = builder.receiveHangDetectionTime;
            this.sendHangDetectionTime = builder.sendHangDetectionTime;
            this.userAgent = builder.userAgent;
        }

        public String getCertificateHostNameOverride() {
            return this.certificateHostNameOverride;
        }

        public int getMaxChannelsPerEndpoint() {
            return this.maxChannelsPerEndpoint;
        }

        public int getMaxRequestsPerChannel() {
            return this.maxRequestsPerChannel;
        }

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public Duration getReceiveHangDetectionTime() {
            return this.receiveHangDetectionTime;
        }

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public Duration getSendHangDetectionTime() {
            return this.sendHangDetectionTime;
        }

        public UserAgentContainer getUserAgent() {
            return this.userAgent;
        }

        public String toString() {
            return RntbdObjectMapper.toJson(this);
        }

        public static class Builder {
            private static final UserAgentContainer DEFAULT_USER_AGENT_CONTAINER = new UserAgentContainer();
            private static final Duration SIXTY_FIVE_SECONDS = Duration.ofSeconds(65L);
            private static final Duration TEN_SECONDS = Duration.ofSeconds(10L);
            private String certificateHostNameOverride = null;
            private int maxChannelsPerEndpoint = 10;
            private int maxRequestsPerChannel = 30;
            private Duration connectionTimeout = null;
            private int partitionCount = 1;
            private Duration receiveHangDetectionTime = SIXTY_FIVE_SECONDS;
            private Duration requestTimeout;
            private Duration sendHangDetectionTime = TEN_SECONDS;
            private UserAgentContainer userAgent = DEFAULT_USER_AGENT_CONTAINER;

            public Builder(Duration requestTimeout) {
                this.requestTimeout(requestTimeout);
            }

            public Builder(int requestTimeoutInSeconds) {
                this(Duration.ofSeconds(requestTimeoutInSeconds));
            }

            public Options build() {
                return new Options(this);
            }

            public Builder certificateHostNameOverride(String value) {
                this.certificateHostNameOverride = value;
                return this;
            }

            public Builder connectionTimeout(Duration value) {
                Preconditions.checkArgument((value == null || value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.connectionTimeout = value;
                return this;
            }

            public Builder maxRequestsPerChannel(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.maxRequestsPerChannel = value;
                return this;
            }

            public Builder maxChannelsPerEndpoint(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.maxChannelsPerEndpoint = value;
                return this;
            }

            public Builder partitionCount(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.partitionCount = value;
                return this;
            }

            public Builder receiveHangDetectionTime(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.receiveHangDetectionTime = value;
                return this;
            }

            public Builder requestTimeout(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.requestTimeout = value;
                return this;
            }

            public Builder sendHangDetectionTime(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.sendHangDetectionTime = value;
                return this;
            }

            public Builder userAgent(UserAgentContainer value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                this.userAgent = value;
                return this;
            }
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdTransportClient> {
        public JsonSerializer() {
            this(null);
        }

        public JsonSerializer(Class<RntbdTransportClient> type) {
            super(type);
        }

        public void serialize(RntbdTransportClient value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeArrayFieldStart(value.name);
            value.endpointProvider.list().forEach(endpoint -> {
                try {
                    generator.writeObject(endpoint);
                }
                catch (IOException error) {
                    logger.error("failed to serialize {} due to ", (Object)endpoint.getName(), (Object)error);
                }
            });
            generator.writeEndArray();
            generator.writeObjectField("config", (Object)value.endpointProvider.config());
            generator.writeObjectField("metrics", (Object)value.metrics);
            generator.writeEndObject();
        }
    }
}

