/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.Integers;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.MutableVolatile;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.SessionTokenHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressSelector;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PartitionKeyRangeGoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReadMode;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResult;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportException;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionIsMigratingException;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionKeyRangeIsSplittingException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.exceptions.CompositeException;
import rx.schedulers.Schedulers;

public class StoreReader {
    private final Logger logger = LoggerFactory.getLogger(StoreReader.class);
    private final TransportClient transportClient;
    private final AddressSelector addressSelector;
    private final ISessionContainer sessionContainer;
    private String lastReadAddress;

    public StoreReader(TransportClient transportClient, AddressSelector addressSelector, ISessionContainer sessionContainer) {
        this.transportClient = transportClient;
        this.addressSelector = addressSelector;
        this.sessionContainer = sessionContainer;
    }

    public Single<List<StoreResult>> readMultipleReplicaAsync(RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode) {
        return this.readMultipleReplicaAsync(entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, false, false);
    }

    public Single<List<StoreResult>> readMultipleReplicaAsync(RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode, boolean checkMinLSN, boolean forceReadAll) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        String originalSessionToken = (String)entity.getHeaders().get("x-ms-session-token");
        if (entity.requestContext.clientSideRequestStatistics == null) {
            entity.requestContext.clientSideRequestStatistics = new ClientSideRequestStatistics();
        }
        Single<ReadReplicaResult> readQuorumResultObs = this.readMultipleReplicasInternalAsync(entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, checkMinLSN, forceReadAll);
        return readQuorumResultObs.flatMap(readQuorumResult -> {
            if (entity.requestContext.performLocalRefreshOnGoneException && readQuorumResult.retryWithForceRefresh && !entity.requestContext.forceRefreshAddressCache) {
                if (entity.requestContext.timeoutHelper.isElapsed()) {
                    return Single.error((Throwable)new GoneException());
                }
                entity.requestContext.forceRefreshAddressCache = true;
                return this.readMultipleReplicasInternalAsync(entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, false, forceReadAll).map(r -> r.responses);
            }
            return Single.just(readQuorumResult.responses);
        }).toObservable().doAfterTerminate(() -> SessionTokenHelper.setOriginalSessionToken((RxDocumentServiceRequest)entity, (String)originalSessionToken)).toSingle();
    }

    private Observable<ReadReplicaResult> earlyResultIfNotEnoughReplicas(List<URI> replicaAddresses, RxDocumentServiceRequest request, int replicaCountToRead) {
        if (replicaAddresses.size() < replicaCountToRead) {
            if (!request.requestContext.forceRefreshAddressCache) {
                return Observable.just((Object)new ReadReplicaResult(true, Collections.emptyList()));
            }
            return Observable.just((Object)new ReadReplicaResult(false, Collections.emptyList()));
        }
        return Observable.empty();
    }

    private Observable<StoreResult> toStoreResult(RxDocumentServiceRequest request, Pair<Observable<StoreResponse>, URI> storeRespAndURI, ReadMode readMode, boolean requiresValidLsn) {
        return ((Observable)storeRespAndURI.getLeft()).flatMap(storeResponse -> {
            try {
                StoreResult storeResult = this.createStoreResult((StoreResponse)storeResponse, null, requiresValidLsn, readMode != ReadMode.Strong, (URI)storeRespAndURI.getRight());
                request.requestContext.clientSideRequestStatistics.getContactedReplicas().add(storeRespAndURI.getRight());
                return Observable.just((Object)storeResult);
            }
            catch (Exception e) {
                return Observable.error((Throwable)e);
            }
        }).onErrorResumeNext(t -> {
            try {
                this.logger.debug("Exception {} is thrown while doing readMany", t);
                Exception storeException = (Exception)Utils.as((Object)t, Exception.class);
                if (storeException == null) {
                    return Observable.error((Throwable)t);
                }
                StoreResult storeResult = this.createStoreResult(null, storeException, requiresValidLsn, readMode != ReadMode.Strong, null);
                if (storeException instanceof TransportException) {
                    request.requestContext.clientSideRequestStatistics.getFailedReplicas().add(storeRespAndURI.getRight());
                }
                return Observable.just((Object)storeResult);
            }
            catch (Exception e) {
                return Observable.error((Throwable)e);
            }
        });
    }

    private Observable<List<StoreResult>> readFromReplicas(List<StoreResult> resultCollector, List<URI> resolveApiResults, AtomicInteger replicasToRead, RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode, boolean checkMinLSN, boolean forceReadAll, MutableVolatile<ISessionToken> requestSessionToken, MutableVolatile<Boolean> hasGoneException, boolean enforceSessionCheck, MutableVolatile<ReadReplicaResult> shortCircut) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Observable.error((Throwable)new GoneException());
        }
        ArrayList<Pair> readStoreTasks = new ArrayList<Pair>();
        int uriIndex = StoreReader.generateNextRandom(resolveApiResults.size());
        while (resolveApiResults.size() > 0) {
            Pair<Single<StoreResponse>, URI> res;
            URI uri = resolveApiResults.get(uriIndex %= resolveApiResults.size());
            try {
                res = this.readFromStoreAsync(resolveApiResults.get(uriIndex), entity);
            }
            catch (Exception e2) {
                res = Pair.of((Object)Single.error((Throwable)e2), (Object)uri);
            }
            readStoreTasks.add(Pair.of((Object)((Single)res.getLeft()).toObservable(), (Object)res.getRight()));
            resolveApiResults.remove(uriIndex);
            if (forceReadAll || readStoreTasks.size() != replicasToRead.get()) continue;
            break;
        }
        replicasToRead.set(readStoreTasks.size() >= replicasToRead.get() ? 0 : replicasToRead.get() - readStoreTasks.size());
        List storeResult = readStoreTasks.stream().map(item -> this.toStoreResult(entity, (Pair<Observable<StoreResponse>, URI>)item, readMode, requiresValidLsn)).collect(Collectors.toList());
        Observable allStoreResults = Observable.merge(storeResult);
        return allStoreResults.toList().onErrorResumeNext(e -> {
            if (e instanceof CompositeException) {
                this.logger.info("Captured composite exception");
                CompositeException compositeException = (CompositeException)e;
                List exceptions = compositeException.getExceptions();
                assert (exceptions != null && !exceptions.isEmpty());
                return Observable.error((Throwable)((Throwable)exceptions.get(0)));
            }
            return Observable.error((Throwable)e);
        }).map(newStoreResults -> {
            for (StoreResult srr : newStoreResults) {
                entity.requestContext.requestChargeTracker.addCharge(srr.requestCharge);
                try {
                    entity.requestContext.clientSideRequestStatistics.recordResponse(entity, srr);
                }
                catch (Exception e) {
                    this.logger.error("unexpected failure failure", (Throwable)e);
                }
                if (srr.isValid) {
                    try {
                        if (requestSessionToken.v == null || srr.sessionToken != null && ((ISessionToken)requestSessionToken.v).isValid(srr.sessionToken) || !enforceSessionCheck && !srr.isNotFoundException) {
                            resultCollector.add(srr);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hasGoneException.v = (Boolean)hasGoneException.v != false || srr.isGoneException && !srr.isInvalidPartitionException;
                if (resultCollector.size() >= replicaCountToRead) {
                    if (((Boolean)hasGoneException.v).booleanValue() && !entity.requestContext.performedBackgroundAddressRefresh) {
                        this.startBackgroundAddressRefresh(entity);
                        entity.requestContext.performedBackgroundAddressRefresh = true;
                    }
                    shortCircut.v = new ReadReplicaResult(false, resultCollector);
                    replicasToRead.set(0);
                    return resultCollector;
                }
                replicasToRead.set(replicaCountToRead - resultCollector.size());
            }
            return resultCollector;
        });
    }

    private ReadReplicaResult createReadReplicaResult(List<StoreResult> responseResult, int replicaCountToRead, int resolvedAddressCount, boolean hasGoneException, RxDocumentServiceRequest entity) throws DocumentClientException {
        if (responseResult.size() < replicaCountToRead) {
            this.logger.debug("Could not get quorum number of responses. ValidResponsesReceived: {} ResponsesExpected: {}, ResolvedAddressCount: {}, ResponsesString: {}", new Object[]{responseResult.size(), replicaCountToRead, resolvedAddressCount, String.join((CharSequence)";", responseResult.stream().map(r -> r.toString()).collect(Collectors.toList()))});
            if (hasGoneException) {
                if (!entity.requestContext.performLocalRefreshOnGoneException) {
                    throw new GoneException();
                }
                if (!entity.requestContext.forceRefreshAddressCache) {
                    return new ReadReplicaResult(true, responseResult);
                }
            }
        }
        return new ReadReplicaResult(false, responseResult);
    }

    private Single<ReadReplicaResult> readMultipleReplicasInternalAsync(RxDocumentServiceRequest entity, boolean includePrimary, int replicaCountToRead, boolean requiresValidLsn, boolean useSessionToken, ReadMode readMode, boolean checkMinLSN, boolean forceReadAll) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        String requestedCollectionId = null;
        if (entity.forceNameCacheRefresh) {
            requestedCollectionId = entity.requestContext.resolvedCollectionRid;
        }
        Single<List<URI>> resolveApiResultsObs = this.addressSelector.resolveAllUriAsync(entity, includePrimary, entity.requestContext.forceRefreshAddressCache);
        if (!(StringUtils.isEmpty((CharSequence)requestedCollectionId) || StringUtils.isEmpty((CharSequence)entity.requestContext.resolvedCollectionRid) || requestedCollectionId.equals(entity.requestContext.resolvedCollectionRid))) {
            this.sessionContainer.clearTokenByResourceId(requestedCollectionId);
        }
        return resolveApiResultsObs.toObservable().map(list -> Collections.synchronizedList(new ArrayList(list))).flatMap(resolveApiResults -> {
            try {
                MutableVolatile requestSessionToken = new MutableVolatile();
                if (useSessionToken) {
                    SessionTokenHelper.setPartitionLocalSessionToken((RxDocumentServiceRequest)entity, (ISessionContainer)this.sessionContainer);
                    if (checkMinLSN) {
                        requestSessionToken.v = entity.requestContext.sessionToken;
                    }
                } else {
                    entity.getHeaders().remove("x-ms-session-token");
                }
                Observable<ReadReplicaResult> y = this.earlyResultIfNotEnoughReplicas((List<URI>)resolveApiResults, entity, replicaCountToRead);
                return y.switchIfEmpty(Observable.defer(() -> {
                    List storeResultList = Collections.synchronizedList(new ArrayList());
                    AtomicInteger replicasToRead = new AtomicInteger(replicaCountToRead);
                    boolean enforceSessionCheck = true;
                    MutableVolatile hasGoneException = new MutableVolatile((Object)false);
                    MutableVolatile shortCircuitResult = new MutableVolatile();
                    return Observable.defer(() -> this.readFromReplicas(storeResultList, (List<URI>)resolveApiResults, replicasToRead, entity, includePrimary, replicaCountToRead, requiresValidLsn, useSessionToken, readMode, checkMinLSN, forceReadAll, (MutableVolatile<ISessionToken>)requestSessionToken, (MutableVolatile<Boolean>)hasGoneException, enforceSessionCheck, (MutableVolatile<ReadReplicaResult>)shortCircuitResult)).repeat().takeUntil(x -> {
                        if (replicasToRead.get() > 0 && resolveApiResults.size() > 0) {
                            return false;
                        }
                        return true;
                    }).toCompletable().andThen(Observable.defer(() -> {
                        try {
                            return Observable.just((Object)this.createReadReplicaResult(storeResultList, replicaCountToRead, resolveApiResults.size(), (Boolean)hasGoneException.v, entity));
                        }
                        catch (Exception e) {
                            return Observable.error((Throwable)e);
                        }
                    }));
                }));
            }
            catch (Exception e) {
                return Observable.error((Throwable)e);
            }
        }).toSingle();
    }

    public Single<StoreResult> readPrimaryAsync(RxDocumentServiceRequest entity, boolean requiresValidLsn, boolean useSessionToken) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        String originalSessionToken = (String)entity.getHeaders().get("x-ms-session-token");
        if (entity.requestContext.clientSideRequestStatistics == null) {
            entity.requestContext.clientSideRequestStatistics = new ClientSideRequestStatistics();
        }
        return this.readPrimaryInternalAsync(entity, requiresValidLsn, useSessionToken).flatMap(readQuorumResult -> {
            if (entity.requestContext.performLocalRefreshOnGoneException && readQuorumResult.retryWithForceRefresh && !entity.requestContext.forceRefreshAddressCache) {
                if (entity.requestContext.timeoutHelper.isElapsed()) {
                    return Single.error((Throwable)new GoneException());
                }
                entity.requestContext.forceRefreshAddressCache = true;
                return this.readPrimaryInternalAsync(entity, requiresValidLsn, useSessionToken);
            }
            return Single.just((Object)readQuorumResult);
        }).flatMap(readQuorumResult -> {
            if (readQuorumResult.responses.size() == 0) {
                return Single.error((Throwable)new GoneException("The requested resource is no longer available at the server."));
            }
            return Single.just((Object)readQuorumResult.responses.get(0));
        }).doOnEach(arg -> {
            try {
                SessionTokenHelper.setOriginalSessionToken((RxDocumentServiceRequest)entity, (String)originalSessionToken);
            }
            catch (Throwable throwable) {
                this.logger.error("Unexpected failure in handling orig [{}]: new [{}]", new Object[]{arg, throwable.getMessage(), throwable});
            }
        });
    }

    private Single<ReadReplicaResult> readPrimaryInternalAsync(RxDocumentServiceRequest entity, boolean requiresValidLsn, boolean useSessionToken) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        Single<URI> primaryUriObs = this.addressSelector.resolvePrimaryUriAsync(entity, entity.requestContext.forceRefreshAddressCache);
        Single storeResultObs = primaryUriObs.flatMap(primaryUri -> {
            try {
                if (useSessionToken) {
                    SessionTokenHelper.setPartitionLocalSessionToken((RxDocumentServiceRequest)entity, (ISessionContainer)this.sessionContainer);
                } else {
                    entity.getHeaders().remove("x-ms-session-token");
                }
                Pair<Single<StoreResponse>, URI> storeResponseObsAndUri = this.readFromStoreAsync((URI)primaryUri, entity);
                return ((Single)storeResponseObsAndUri.getLeft()).flatMap(storeResponse -> {
                    try {
                        StoreResult storeResult = this.createStoreResult((StoreResponse)(storeResponse != null ? storeResponse : null), null, requiresValidLsn, true, storeResponse != null ? (URI)storeResponseObsAndUri.getRight() : null);
                        return Single.just((Object)storeResult);
                    }
                    catch (DocumentClientException e) {
                        return Single.error((Throwable)e);
                    }
                });
            }
            catch (DocumentClientException e) {
                return Single.error((Throwable)e);
            }
        }).onErrorResumeNext(t -> {
            this.logger.debug("Exception {} is thrown while doing Read Primary", t);
            Exception storeTaskException = (Exception)Utils.as((Object)t, Exception.class);
            if (storeTaskException == null) {
                return Single.error((Throwable)t);
            }
            try {
                StoreResult storeResult = this.createStoreResult(null, storeTaskException, requiresValidLsn, true, null);
                return Single.just((Object)storeResult);
            }
            catch (DocumentClientException e) {
                return Single.error((Throwable)e);
            }
        });
        return storeResultObs.map(storeResult -> {
            try {
                entity.requestContext.clientSideRequestStatistics.recordResponse(entity, storeResult);
            }
            catch (Exception e) {
                this.logger.error("unexpected failure failure", (Throwable)e);
            }
            entity.requestContext.requestChargeTracker.addCharge(storeResult.requestCharge);
            if (storeResult.isGoneException && !storeResult.isInvalidPartitionException) {
                return new ReadReplicaResult(true, Collections.emptyList());
            }
            return new ReadReplicaResult(false, Collections.singletonList(storeResult));
        });
    }

    private Pair<Single<StoreResponse>, URI> readFromStoreAsync(URI physicalAddress, RxDocumentServiceRequest request) throws DocumentClientException {
        if (request.requestContext.timeoutHelper.isElapsed()) {
            throw new GoneException();
        }
        String ifNoneMatch = (String)request.getHeaders().get("If-None-Match");
        String continuation = null;
        String maxPageSize = null;
        this.lastReadAddress = physicalAddress.toString();
        if (request.getOperationType() == OperationType.ReadFeed || request.getOperationType() == OperationType.Query) {
            continuation = (String)request.getHeaders().get("x-ms-continuation");
            maxPageSize = (String)request.getHeaders().get("x-ms-max-item-count");
            if (continuation != null && continuation.contains(";")) {
                String[] parts = StringUtils.split((String)continuation, (char)';');
                if (parts.length < 3) {
                    throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", continuation, "x-ms-continuation"));
                }
                continuation = parts[0];
            }
            request.setContinuation(continuation);
        }
        switch (request.getOperationType()) {
            case Read: 
            case Head: {
                Single<StoreResponse> storeResponseObs = this.transportClient.invokeResourceOperationAsync(physicalAddress, request);
                return Pair.of(storeResponseObs, (Object)physicalAddress);
            }
            case ReadFeed: 
            case HeadFeed: 
            case Query: 
            case SqlQuery: 
            case ExecuteJavaScript: {
                Single<StoreResponse> storeResponseObs = StoreReader.completeActivity(this.transportClient.invokeResourceOperationAsync(physicalAddress, request), null);
                return Pair.of(storeResponseObs, (Object)physicalAddress);
            }
        }
        throw new IllegalStateException(String.format("Unexpected operation type {%s}", request.getOperationType()));
    }

    private static Single<StoreResponse> completeActivity(Single<StoreResponse> task, Object activity) {
        return task;
    }

    StoreResult createStoreResult(StoreResponse storeResponse, Exception responseException, boolean requiresValidLsn, boolean useLocalLSNBasedHeaders, URI storePhysicalAddress) throws DocumentClientException {
        if (responseException == null) {
            String headerValue = null;
            long quorumAckedLSN = -1L;
            int currentReplicaSetSize = -1;
            int currentWriteQuorum = -1;
            long globalCommittedLSN = -1L;
            int numberOfReadRegions = -1;
            long itemLSN = -1L;
            headerValue = storeResponse.getHeaderValue(useLocalLSNBasedHeaders ? "x-ms-cosmos-quorum-acked-llsn" : "x-ms-quorum-acked-lsn");
            if (headerValue != null) {
                quorumAckedLSN = Long.parseLong(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-current-replica-set-size")) != null) {
                currentReplicaSetSize = Integer.parseInt(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-current-write-quorum")) != null) {
                currentWriteQuorum = Integer.parseInt(headerValue);
            }
            double requestCharge = 0.0;
            headerValue = storeResponse.getHeaderValue("x-ms-request-charge");
            if (headerValue != null) {
                requestCharge = Double.parseDouble(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-number-of-read-regions")) != null) {
                numberOfReadRegions = Integer.parseInt(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue("x-ms-global-Committed-lsn")) != null) {
                globalCommittedLSN = Long.parseLong(headerValue);
            }
            if ((headerValue = storeResponse.getHeaderValue(useLocalLSNBasedHeaders ? "x-ms-cosmos-item-llsn" : "x-ms-item-lsn")) != null) {
                itemLSN = Long.parseLong(headerValue);
            }
            long lsn = -1L;
            if (useLocalLSNBasedHeaders) {
                headerValue = storeResponse.getHeaderValue("x-ms-cosmos-llsn");
                if (headerValue != null) {
                    lsn = Long.parseLong(headerValue);
                }
            } else {
                lsn = storeResponse.getLSN();
            }
            ISessionToken sessionToken = null;
            headerValue = storeResponse.getHeaderValue("x-ms-session-token");
            if (headerValue != null) {
                sessionToken = SessionTokenHelper.parse((String)headerValue);
            }
            return new StoreResult(storeResponse, null, storeResponse.getPartitionKeyRangeId(), lsn, quorumAckedLSN, requestCharge, currentReplicaSetSize, currentWriteQuorum, true, storePhysicalAddress, globalCommittedLSN, numberOfReadRegions, itemLSN, sessionToken);
        }
        DocumentClientException documentClientException = (DocumentClientException)((Object)Utils.as((Object)responseException, DocumentClientException.class));
        if (documentClientException != null) {
            StoreReader.verifyCanContinueOnException(documentClientException);
            long quorumAckedLSN = -1L;
            int currentReplicaSetSize = -1;
            int currentWriteQuorum = -1;
            long globalCommittedLSN = -1L;
            int numberOfReadRegions = -1;
            String headerValue = (String)documentClientException.getResponseHeaders().get(useLocalLSNBasedHeaders ? "x-ms-cosmos-quorum-acked-llsn" : "x-ms-quorum-acked-lsn");
            if (!Strings.isNullOrEmpty((String)headerValue)) {
                quorumAckedLSN = Long.parseLong(headerValue);
            }
            if (!Strings.isNullOrEmpty((String)(headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-current-replica-set-size")))) {
                currentReplicaSetSize = Integer.parseInt(headerValue);
            }
            if (!Strings.isNullOrEmpty((String)(headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-current-write-quorum")))) {
                currentReplicaSetSize = Integer.parseInt(headerValue);
            }
            double requestCharge = 0.0;
            headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-request-charge");
            if (!Strings.isNullOrEmpty((String)headerValue)) {
                requestCharge = Double.parseDouble(headerValue);
            }
            if (!Strings.isNullOrEmpty((String)(headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-number-of-read-regions")))) {
                numberOfReadRegions = Integer.parseInt(headerValue);
            }
            if (!Strings.isNullOrEmpty((String)(headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-global-Committed-lsn")))) {
                globalCommittedLSN = Integer.parseInt(headerValue);
            }
            long lsn = -1L;
            if (useLocalLSNBasedHeaders) {
                headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-cosmos-llsn");
                if (!Strings.isNullOrEmpty((String)headerValue)) {
                    lsn = Long.parseLong(headerValue);
                }
            } else {
                lsn = BridgeInternal.getLSN((DocumentClientException)documentClientException);
            }
            ISessionToken sessionToken = null;
            headerValue = (String)documentClientException.getResponseHeaders().get("x-ms-session-token");
            if (!Strings.isNullOrEmpty((String)headerValue)) {
                sessionToken = SessionTokenHelper.parse((String)headerValue);
            }
            return new StoreResult((StoreResponse)null, documentClientException, BridgeInternal.getPartitionKeyRangeId((DocumentClientException)documentClientException), lsn, quorumAckedLSN, requestCharge, currentReplicaSetSize, currentWriteQuorum, !requiresValidLsn || (documentClientException.getStatusCode() != 410 || Exceptions.isSubStatusCode((DocumentClientException)documentClientException, (int)1000)) && lsn >= 0L, storePhysicalAddress == null ? BridgeInternal.getRequestUri((DocumentClientException)documentClientException) : storePhysicalAddress, globalCommittedLSN, numberOfReadRegions, -1L, sessionToken);
        }
        this.logger.error("Unexpected exception {} received while reading from store.", (Object)responseException.getMessage(), (Object)responseException);
        return new StoreResult(null, (DocumentClientException)((Object)new InternalServerErrorException("Unknown server error occurred when processing this request.")), (String)null, -1L, -1L, 0.0, 0, 0, false, storePhysicalAddress, -1L, 0, -1L, null);
    }

    void startBackgroundAddressRefresh(RxDocumentServiceRequest request) {
        this.addressSelector.resolveAllUriAsync(request, true, true).observeOn(Schedulers.io()).subscribe(r -> {}, e -> this.logger.warn("Background refresh of the addresses failed with {}", (Object)e.getMessage(), e));
    }

    private static int generateNextRandom(int maxValue) {
        return ThreadLocalRandom.current().nextInt(maxValue);
    }

    static void verifyCanContinueOnException(DocumentClientException ex) throws DocumentClientException {
        if (ex instanceof PartitionKeyRangeGoneException) {
            throw ex;
        }
        if (ex instanceof PartitionKeyRangeIsSplittingException) {
            throw ex;
        }
        if (ex instanceof PartitionIsMigratingException) {
            throw ex;
        }
        String value = (String)ex.getResponseHeaders().get("x-ms-request-validation-failure");
        if (Strings.isNullOrWhiteSpace((String)value)) {
            return;
        }
        Integer result = Integers.tryParse((String)value);
        if (result != null && result == 1) {
            throw ex;
        }
    }

    private class ReadReplicaResult {
        public final boolean retryWithForceRefresh;
        public final List<StoreResult> responses;

        public ReadReplicaResult(boolean retryWithForceRefresh, List<StoreResult> responses) {
            this.retryWithForceRefresh = retryWithForceRefresh;
            this.responses = responses;
        }
    }
}

