/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.google.common.base.Preconditions;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextNegotiator;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestEncoder;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestManager;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponseDecoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdClientChannelHandler
extends ChannelInitializer<Channel>
implements ChannelPoolHandler {
    private static Logger logger = LoggerFactory.getLogger(RntbdClientChannelHandler.class);
    private final RntbdEndpoint.Config config;

    RntbdClientChannelHandler(RntbdEndpoint.Config config) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        this.config = config;
    }

    public void channelAcquired(Channel channel) {
        logger.trace("{} CHANNEL ACQUIRED", (Object)channel);
    }

    public void channelCreated(Channel channel) {
        logger.trace("{} CHANNEL CREATED", (Object)channel);
        this.initChannel(channel);
    }

    public void channelReleased(Channel channel) {
        logger.trace("{} CHANNEL RELEASED", (Object)channel);
    }

    protected void initChannel(Channel channel) {
        Preconditions.checkNotNull((Object)channel);
        RntbdRequestManager requestManager = new RntbdRequestManager(this.config.getMaxRequestsPerChannel());
        long readerIdleTime = this.config.getReceiveHangDetectionTime();
        long writerIdleTime = this.config.getSendHangDetectionTime();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst(new ChannelHandler[]{new RntbdContextNegotiator(requestManager, this.config.getUserAgent()), new RntbdResponseDecoder(), new RntbdRequestEncoder(), new WriteTimeoutHandler(writerIdleTime, TimeUnit.NANOSECONDS), requestManager});
        if (this.config.getWireLogLevel() != null) {
            pipeline.addFirst(new ChannelHandler[]{new LoggingHandler(this.config.getWireLogLevel())});
        }
        SSLEngine sslEngine = this.config.getSslContext().newEngine(channel.alloc());
        pipeline.addFirst(new ChannelHandler[]{new ReadTimeoutHandler(readerIdleTime, TimeUnit.NANOSECONDS), new SslHandler(sslEngine)});
    }
}

