/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdClientChannelHandler;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdReporter;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestManager;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdClientChannelPool
extends FixedChannelPool {
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelPool.class);
    private static final AtomicReference<Field> pendingAcquireCount = new AtomicReference();
    private final AtomicInteger availableChannelCount;
    private final AtomicBoolean closed;
    private final int maxChannels;
    private final int maxRequestsPerChannel;

    RntbdClientChannelPool(Bootstrap bootstrap, RntbdEndpoint.Config config) {
        super(bootstrap, (ChannelPoolHandler)new RntbdClientChannelHandler(config), ChannelHealthChecker.ACTIVE, null, -1L, config.getMaxChannelsPerEndpoint(), Integer.MAX_VALUE, true);
        this.maxRequestsPerChannel = config.getMaxRequestsPerChannel();
        this.maxChannels = config.getMaxChannelsPerEndpoint();
        this.availableChannelCount = new AtomicInteger();
        this.closed = new AtomicBoolean();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        this.throwIfClosed();
        return super.acquire(promise);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        this.throwIfClosed();
        return super.release(channel, promise);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.availableChannelCount.set(0);
            super.close();
        }
    }

    public int availableChannelCount() {
        return this.availableChannelCount.get();
    }

    public int maxChannels() {
        return this.maxChannels;
    }

    public int maxRequestsPerChannel() {
        return this.maxRequestsPerChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingAcquisitionCount() {
        Field field = pendingAcquireCount.get();
        if (field == null) {
            AtomicReference<Field> atomicReference = pendingAcquireCount;
            synchronized (atomicReference) {
                field = pendingAcquireCount.get();
                if (field == null) {
                    field = FieldUtils.getDeclaredField(FixedChannelPool.class, (String)"pendingAcquireCount", (boolean)true);
                    pendingAcquireCount.set(field);
                }
            }
        }
        try {
            return (Integer)FieldUtils.readField((Field)field, (Object)((Object)this));
        }
        catch (IllegalAccessException error) {
            RntbdReporter.reportIssue(logger, (Object)this, "could not access field due to ", error);
            return -1;
        }
    }

    protected synchronized Channel pollChannel() {
        Channel first = super.pollChannel();
        if (first == null) {
            return null;
        }
        if (this.closed.get()) {
            return first;
        }
        if (this.isInactiveOrServiceableChannel(first)) {
            return this.decrementAvailableChannelCountAndAccept(first);
        }
        super.offerChannel(first);
        Channel next = super.pollChannel();
        while (next != first) {
            if (this.isInactiveOrServiceableChannel(next)) {
                return this.decrementAvailableChannelCountAndAccept(next);
            }
            super.offerChannel(next);
            next = super.pollChannel();
        }
        super.offerChannel(first);
        return null;
    }

    protected boolean offerChannel(Channel channel) {
        if (super.offerChannel(channel)) {
            this.availableChannelCount.incrementAndGet();
            return true;
        }
        return false;
    }

    public SocketAddress remoteAddress() {
        return this.bootstrap().config().remoteAddress();
    }

    public String toString() {
        return "RntbdClientChannelPool(" + RntbdObjectMapper.toJson((Object)this) + ")";
    }

    private Channel decrementAvailableChannelCountAndAccept(Channel first) {
        this.availableChannelCount.decrementAndGet();
        return first;
    }

    private boolean isInactiveOrServiceableChannel(Channel channel) {
        if (!channel.isActive()) {
            return true;
        }
        RntbdRequestManager requestManager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
        if (requestManager == null) {
            RntbdReporter.reportIssueUnless(!channel.isActive(), logger, (Object)this, "{} active with no request manager", channel);
            return true;
        }
        return requestManager.isServiceable(this.maxRequestsPerChannel);
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"%s is closed", (Object)((Object)this));
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdClientChannelPool> {
        public JsonSerializer() {
            this(null);
        }

        public JsonSerializer(Class<RntbdClientChannelPool> type) {
            super(type);
        }

        public void serialize(RntbdClientChannelPool value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("remoteAddress", value.remoteAddress().toString());
            generator.writeNumberField("maxChannels", value.maxChannels());
            generator.writeNumberField("maxRequestsPerChannel", value.maxRequestsPerChannel());
            generator.writeObjectFieldStart("state");
            generator.writeBooleanField("isClosed", value.closed.get());
            generator.writeNumberField("acquiredChannelCount", value.acquiredChannelCount());
            generator.writeNumberField("availableChannelCount", value.availableChannelCount());
            generator.writeNumberField("pendingAcquisitionCount", value.pendingAcquisitionCount());
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }
}

