/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestFrame;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdToken;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdTokenStream;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class RntbdContextRequest {
    @JsonProperty
    private final UUID activityId;
    @JsonProperty
    private final Headers headers;

    RntbdContextRequest(UUID activityId, UserAgentContainer userAgent) {
        this(activityId, new Headers(userAgent));
    }

    private RntbdContextRequest(UUID activityId, Headers headers) {
        this.activityId = activityId;
        this.headers = headers;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public String getClientVersion() {
        return this.headers.clientVersion.getValue(String.class);
    }

    public static RntbdContextRequest decode(ByteBuf in) {
        int resourceOperationTypeCode = in.getInt(in.readerIndex() + 4);
        if (resourceOperationTypeCode != 0) {
            String reason = String.format("resourceOperationCode=0x%08X", resourceOperationTypeCode);
            throw new IllegalStateException(reason);
        }
        int start = in.readerIndex();
        int expectedLength = in.readIntLE();
        RntbdRequestFrame header = RntbdRequestFrame.decode(in);
        Headers headers = Headers.decode(in.readSlice(expectedLength - (in.readerIndex() - start)));
        int observedLength = in.readerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = String.format("expectedLength=%d, observeredLength=%d", expectedLength, observedLength);
            throw new IllegalStateException(reason);
        }
        in.discardReadBytes();
        return new RntbdContextRequest(header.getActivityId(), headers);
    }

    public void encode(ByteBuf out) {
        int expectedLength = 24 + this.headers.computeLength();
        int start = out.writerIndex();
        out.writeIntLE(expectedLength);
        RntbdRequestFrame header = new RntbdRequestFrame(this.getActivityId(), RntbdConstants.RntbdOperationType.Connection, RntbdConstants.RntbdResourceType.Connection);
        header.encode(out);
        this.headers.encode(out);
        int observedLength = out.writerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = String.format("expectedLength=%d, observeredLength=%d", expectedLength, observedLength);
            throw new IllegalStateException(reason);
        }
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    private static final class Headers
    extends RntbdTokenStream<RntbdConstants.RntbdContextRequestHeader> {
        private static final byte[] ClientVersion = "2018-09-17".getBytes(StandardCharsets.UTF_8);
        @JsonProperty
        RntbdToken clientVersion = this.get(RntbdConstants.RntbdContextRequestHeader.ClientVersion);
        @JsonProperty
        RntbdToken protocolVersion = this.get(RntbdConstants.RntbdContextRequestHeader.ProtocolVersion);
        @JsonProperty
        RntbdToken userAgent = this.get(RntbdConstants.RntbdContextRequestHeader.UserAgent);

        Headers(UserAgentContainer container) {
            this();
            this.clientVersion.setValue(ClientVersion);
            this.protocolVersion.setValue(1);
            this.userAgent.setValue(container.getUserAgent());
        }

        private Headers() {
            super(RntbdConstants.RntbdContextRequestHeader.set, RntbdConstants.RntbdContextRequestHeader.map);
        }

        static Headers decode(ByteBuf in) {
            return Headers.decode(in, new Headers());
        }
    }
}

