/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.google.common.base.Preconditions;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RntbdTransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestRecord;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.util.stream.Stream;

public interface RntbdEndpoint
extends AutoCloseable {
    public String getName();

    @Override
    public void close() throws RuntimeException;

    public RntbdRequestRecord request(RntbdRequestArgs var1);

    public static final class Config {
        private final RntbdTransportClient.Options options;
        private final SslContext sslContext;
        private final LogLevel wireLogLevel;

        public Config(RntbdTransportClient.Options options, SslContext sslContext, LogLevel wireLogLevel) {
            Preconditions.checkNotNull((Object)options, (Object)"options");
            Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            this.options = options;
            this.sslContext = sslContext;
            this.wireLogLevel = wireLogLevel;
        }

        public int getConnectionTimeout() {
            long value = this.options.getConnectionTimeout().toMillis();
            assert (value <= Integer.MAX_VALUE);
            return (int)value;
        }

        public int getMaxChannelsPerEndpoint() {
            return this.options.getMaxChannelsPerEndpoint();
        }

        public int getMaxRequestsPerChannel() {
            return this.options.getMaxRequestsPerChannel();
        }

        public long getReceiveHangDetectionTime() {
            return this.options.getReceiveHangDetectionTime().toNanos();
        }

        public long getRequestTimeout() {
            return this.options.getRequestTimeout().toNanos();
        }

        public long getSendHangDetectionTime() {
            return this.options.getSendHangDetectionTime().toNanos();
        }

        public SslContext getSslContext() {
            return this.sslContext;
        }

        public UserAgentContainer getUserAgent() {
            return this.options.getUserAgent();
        }

        public LogLevel getWireLogLevel() {
            return this.wireLogLevel;
        }

        public String toString() {
            return RntbdObjectMapper.toJson(this);
        }
    }

    public static interface Provider
    extends AutoCloseable {
        @Override
        public void close() throws RuntimeException;

        public Config config();

        public int count();

        public RntbdEndpoint get(URI var1);

        public Stream<RntbdEndpoint> list();
    }
}

