/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Stopwatch;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import java.time.Duration;

@JsonPropertyOrder(value={"lifetime", "requests", "responses", "errorResponses", "responseRate", "completionRate", "throughput"})
public final class RntbdMetrics
implements AutoCloseable {
    private static final MetricRegistry registry = new MetricRegistry();
    private final Gauge<Double> completionRate;
    private final Meter errorResponses;
    private final Stopwatch lifetime = Stopwatch.createStarted();
    private final String prefix;
    private final Meter requests;
    private final Gauge<Double> responseRate;
    private final Meter responses;

    public RntbdMetrics(String name) {
        this.prefix = name + '.';
        this.requests = (Meter)registry.register(this.prefix + "requests", (Metric)new Meter());
        this.responses = (Meter)registry.register(this.prefix + "responses", (Metric)new Meter());
        this.errorResponses = (Meter)registry.register(this.prefix + "errorResponses", (Metric)new Meter());
        this.responseRate = (Gauge)registry.register(this.prefix + "responseRate", (Metric)new ResponseRate(this));
        this.completionRate = (Gauge)registry.register(this.prefix + "completionRate", (Metric)new CompletionRate(this));
    }

    public double getCompletionRate() {
        return (Double)this.completionRate.getValue();
    }

    public long getErrorResponses() {
        return this.errorResponses.getCount();
    }

    public double getLifetime() {
        Duration elapsed = this.lifetime.elapsed();
        return (double)elapsed.getSeconds() + 1.0E-9 * (double)elapsed.getNano();
    }

    public long getRequests() {
        return this.requests.getCount();
    }

    public double getResponseRate() {
        return (Double)this.responseRate.getValue();
    }

    public long getResponses() {
        return this.responses.getCount();
    }

    public double getThroughput() {
        return this.responses.getMeanRate();
    }

    @Override
    public void close() {
        registry.removeMatching(MetricFilter.startsWith((String)this.prefix));
    }

    public final void incrementErrorResponseCount() {
        this.errorResponses.mark();
    }

    public final void incrementRequestCount() {
        this.requests.mark();
    }

    public final void incrementResponseCount() {
        this.responses.mark();
    }

    public String toString() {
        return RntbdObjectMapper.toJson(this);
    }

    private static final class ResponseRate
    extends RatioGauge {
        private final RntbdMetrics metrics;

        private ResponseRate(RntbdMetrics metrics) {
            this.metrics = metrics;
        }

        protected RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of((double)this.metrics.responses.getCount(), (double)this.metrics.requests.getCount());
        }
    }

    private static final class CompletionRate
    extends RatioGauge {
        private final RntbdMetrics metrics;

        private CompletionRate(RntbdMetrics metrics) {
            this.metrics = metrics;
        }

        protected RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of((double)(this.metrics.responses.getCount() - this.metrics.errorResponses.getCount()), (double)this.metrics.requests.getCount());
        }
    }
}

