/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.Preconditions;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.io.InputStream;

public final class RntbdObjectMapper {
    private static final SimpleFilterProvider filterProvider = new SimpleFilterProvider();
    private static final ObjectMapper objectMapper = new ObjectMapper().setFilterProvider((FilterProvider)filterProvider);
    private static final ObjectWriter objectWriter = objectMapper.writer();

    private RntbdObjectMapper() {
    }

    static ObjectNode readTree(RntbdResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        return RntbdObjectMapper.readTree(response.getContent());
    }

    static ObjectNode readTree(ByteBuf in) {
        JsonNode node;
        Preconditions.checkNotNull((Object)in, (Object)"in");
        try (ByteBufInputStream istream = new ByteBufInputStream(in);){
            node = objectMapper.readTree((InputStream)istream);
        }
        catch (IOException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
        if (node.isObject()) {
            return (ObjectNode)node;
        }
        String cause = String.format("Expected %s, not %s", JsonNodeType.OBJECT, node.getNodeType());
        throw new CorruptedFrameException(cause);
    }

    static void registerPropertyFilter(Class<?> type, Class<? extends PropertyFilter> filter) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(filter, (Object)"filter");
        try {
            filterProvider.addFilter(type.getSimpleName(), filter.newInstance());
        }
        catch (ReflectiveOperationException error) {
            throw new IllegalStateException(error);
        }
    }

    public static String toJson(Object value) {
        try {
            return objectWriter.writeValueAsString(value);
        }
        catch (JsonProcessingException error) {
            throw new EncoderException((Throwable)error);
        }
    }

    public static ObjectWriter writer() {
        return objectWriter;
    }
}

