/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class RntbdReporter {
    private static final String codeSource;

    private RntbdReporter() {
    }

    public static void reportIssue(Logger logger, Object subject, String format, Object ... arguments) {
        if (logger.isErrorEnabled()) {
            RntbdReporter.doReportIssue(logger, subject, format, arguments);
        }
    }

    public static void reportIssueUnless(boolean predicate, Logger logger, Object subject, String format, Object ... arguments) {
        if (!predicate && logger.isErrorEnabled()) {
            RntbdReporter.doReportIssue(logger, subject, format, arguments);
        }
    }

    private static void doReportIssue(Logger logger, Object subject, String format, Object[] arguments) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        StackTraceElement[] stackTraceElements = new Exception().getStackTrace();
        Throwable throwable = formattingTuple.getThrowable();
        if (throwable == null) {
            logger.error("Report this {} issue to ensure it is addressed:\n[{}]\n[{}]\n[{}]", new Object[]{codeSource, subject, stackTraceElements[2], formattingTuple.getMessage()});
        } else {
            logger.error("Report this {} issue to ensure it is addressed:\n[{}]\n[{}]\n[{}{}{}]", new Object[]{codeSource, subject, stackTraceElements[2], formattingTuple.getMessage(), throwable, ExceptionUtils.getStackTrace((Throwable)throwable)});
        }
    }

    static {
        String value;
        try {
            URL url = RntbdReporter.class.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(url.toURI());
            value = file.getName();
        }
        catch (Throwable error) {
            value = "azure-cosmosdb-direct";
        }
        codeSource = value;
    }
}

