/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.channel.ChannelHandlerContext;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@JsonPropertyOrder(value={"transportRequestId", "origin", "replicaPath", "activityId", "operationType", "resourceType", "birthTime", "lifetime"})
public final class RntbdRequestArgs {
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final String simpleClassName = RntbdRequestArgs.class.getSimpleName();
    private final UUID activityId;
    private final long birthTime;
    private final Stopwatch lifetime;
    private final String origin;
    private final URI physicalAddress;
    private final String replicaPath;
    private final RxDocumentServiceRequest serviceRequest;
    private final long transportRequestId;

    public RntbdRequestArgs(RxDocumentServiceRequest serviceRequest, URI physicalAddress) {
        this.activityId = UUID.fromString(serviceRequest.getActivityId());
        this.birthTime = System.nanoTime();
        this.lifetime = Stopwatch.createStarted();
        this.origin = physicalAddress.getScheme() + "://" + physicalAddress.getAuthority();
        this.physicalAddress = physicalAddress;
        this.replicaPath = StringUtils.stripEnd((String)physicalAddress.getPath(), (String)"/");
        this.serviceRequest = serviceRequest;
        this.transportRequestId = instanceCount.incrementAndGet();
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public long getBirthTime() {
        return this.birthTime;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Duration getLifetime() {
        return this.lifetime.elapsed();
    }

    public String getOrigin() {
        return this.origin;
    }

    @JsonIgnore
    public URI getPhysicalAddress() {
        return this.physicalAddress;
    }

    public String getReplicaPath() {
        return this.replicaPath;
    }

    @JsonIgnore
    public RxDocumentServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public long getTransportRequestId() {
        return this.transportRequestId;
    }

    public String toString() {
        return simpleClassName + '(' + RntbdObjectMapper.toJson(this) + ')';
    }

    public void traceOperation(Logger logger, ChannelHandlerContext context, String operationName, Object ... args) {
        Preconditions.checkNotNull((Object)logger, (Object)"logger");
        if (logger.isTraceEnabled()) {
            BigDecimal lifetime = BigDecimal.valueOf(this.lifetime.elapsed().toNanos(), 6);
            logger.trace("{},{},\"{}({})\",\"{}\",\"{}\"", new Object[]{this.birthTime, lifetime, operationName, Stream.of(args).map(arg -> arg == null ? "null" : arg.toString()).collect(Collectors.joining(",")), this, context});
        }
    }
}

