/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.google.common.base.Preconditions;
import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestTimeoutException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class RntbdRequestRecord
extends CompletableFuture<StoreResponse> {
    private static final String simpleClassName = RntbdRequestRecord.class.getSimpleName();
    private final RntbdRequestArgs args;
    private final RntbdRequestTimer timer;

    public RntbdRequestRecord(RntbdRequestArgs args, RntbdRequestTimer timer) {
        Preconditions.checkNotNull((Object)args, (Object)"args");
        Preconditions.checkNotNull((Object)timer, (Object)"timer");
        this.args = args;
        this.timer = timer;
    }

    public UUID getActivityId() {
        return this.args.getActivityId();
    }

    public RntbdRequestArgs getArgs() {
        return this.args;
    }

    public long getBirthTime() {
        return this.args.getBirthTime();
    }

    public Duration getLifetime() {
        return this.args.getLifetime();
    }

    public long getTransportRequestId() {
        return this.args.getTransportRequestId();
    }

    public boolean expire() {
        long timeoutInterval = this.timer.getRequestTimeout(TimeUnit.MILLISECONDS);
        String message = String.format("Request timeout interval (%,d ms) elapsed", timeoutInterval);
        RequestTimeoutException error = new RequestTimeoutException(message, this.args.getPhysicalAddress());
        BridgeInternal.setRequestHeaders((DocumentClientException)error, (Map)this.args.getServiceRequest().getHeaders());
        return this.completeExceptionally((Throwable)error);
    }

    public Timeout newTimeout(TimerTask task) {
        return this.timer.newTimeout(task);
    }

    @Override
    public String toString() {
        return simpleClassName + '(' + RntbdObjectMapper.toJson(this.args) + ')';
    }
}

