/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RntbdTransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdClientChannelPool;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdMetrics;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestRecord;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestTimer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdServiceEndpoint
implements RntbdEndpoint {
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdServiceEndpoint.class);
    private static final String namePrefix = RntbdServiceEndpoint.class.getSimpleName() + '-';
    private final RntbdClientChannelPool channelPool;
    private final AtomicBoolean closed;
    private final RntbdMetrics metrics;
    private final String name;
    private final SocketAddress remoteAddress;
    private final RntbdRequestTimer requestTimer;

    private RntbdServiceEndpoint(RntbdEndpoint.Config config, NioEventLoopGroup group, RntbdRequestTimer timer, URI physicalAddress) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group((EventLoopGroup)group)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectionTimeout())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress(physicalAddress.getHost(), physicalAddress.getPort());
        this.name = namePrefix + instanceCount.incrementAndGet();
        this.channelPool = new RntbdClientChannelPool(bootstrap, config);
        this.remoteAddress = bootstrap.config().remoteAddress();
        this.metrics = new RntbdMetrics(this.name);
        this.closed = new AtomicBoolean();
        this.requestTimer = timer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.channelPool.close();
            this.metrics.close();
        }
    }

    @Override
    public RntbdRequestRecord request(RntbdRequestArgs args) {
        this.throwIfClosed();
        if (logger.isDebugEnabled()) {
            args.traceOperation(logger, null, "request", new Object[0]);
            logger.debug("\n  {}\n  {}\n  REQUEST", (Object)this, (Object)args);
        }
        RntbdRequestRecord requestRecord = this.write(args);
        this.metrics.incrementRequestCount();
        requestRecord.whenComplete((response, error) -> {
            args.traceOperation(logger, null, "requestComplete", response, error);
            this.metrics.incrementResponseCount();
            if (error != null) {
                this.metrics.incrementErrorResponseCount();
            }
            if (logger.isDebugEnabled()) {
                if (error == null) {
                    int status = response.getStatus();
                    logger.debug("\n  [{}]\n  {}\n  request succeeded with response status: {}", new Object[]{this, args, status});
                } else {
                    logger.debug("\n  [{}]\n  {}\n  request failed due to ", new Object[]{this, args, error});
                }
            }
        });
        return requestRecord;
    }

    public String toString() {
        return RntbdObjectMapper.toJson(this);
    }

    private void releaseToPool(Channel channel) {
        logger.debug("\n  [{}]\n  {}\n  RELEASE", (Object)this, (Object)channel);
        this.channelPool.release(channel).addListener(future -> {
            if (logger.isDebugEnabled()) {
                if (future.isSuccess()) {
                    logger.debug("\n  [{}]\n  {}\n  release succeeded", (Object)this, (Object)channel);
                } else {
                    logger.debug("\n  [{}]\n  {}\n  release failed due to {}", new Object[]{this, channel, future.cause()});
                }
            }
        });
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"%s is closed", (Object)this);
    }

    private RntbdRequestRecord write(RntbdRequestArgs requestArgs) {
        RntbdRequestRecord requestRecord = new RntbdRequestRecord(requestArgs, this.requestTimer);
        logger.debug("\n  [{}]\n  {}\n  WRITE", (Object)this, (Object)requestArgs);
        this.channelPool.acquire().addListener(connected -> {
            if (connected.isSuccess()) {
                requestArgs.traceOperation(logger, null, "write", new Object[0]);
                Channel channel = (Channel)connected.get();
                this.releaseToPool(channel);
                channel.write((Object)requestRecord).addListener(future -> {
                    requestArgs.traceOperation(logger, null, "writeComplete", channel);
                    if (!future.isSuccess()) {
                        this.metrics.incrementErrorResponseCount();
                    }
                });
                return;
            }
            UUID activityId = requestArgs.getActivityId();
            Throwable cause = connected.cause();
            if (connected.isCancelled()) {
                logger.debug("\n  [{}]\n  {}\n  write cancelled: {}", new Object[]{this, requestArgs, cause});
                requestRecord.cancel(true);
            } else {
                logger.debug("\n  [{}]\n  {}\n  write failed due to {} ", new Object[]{this, requestArgs, cause});
                String reason = cause.getMessage();
                GoneException goneException = new GoneException(String.format("failed to establish connection to %s: %s", this.remoteAddress, reason), cause instanceof Exception ? (Exception)cause : new IOException(reason, cause), (Map)ImmutableMap.of((Object)"x-ms-activity-id", (Object)activityId.toString()), requestArgs.getReplicaPath());
                BridgeInternal.setRequestHeaders((DocumentClientException)((Object)((Object)((Object)goneException))), (Map)requestArgs.getServiceRequest().getHeaders());
                requestRecord.completeExceptionally(goneException);
            }
        });
        return requestRecord;
    }

    public static final class Provider
    implements RntbdEndpoint.Provider {
        private static final Logger logger = LoggerFactory.getLogger(Provider.class);
        private final AtomicBoolean closed = new AtomicBoolean();
        private final RntbdEndpoint.Config config;
        private final ConcurrentHashMap<String, RntbdEndpoint> endpoints = new ConcurrentHashMap();
        private final NioEventLoopGroup eventLoopGroup;
        private final RntbdRequestTimer requestTimer;

        public Provider(RntbdTransportClient.Options options, SslContext sslContext) {
            Preconditions.checkNotNull((Object)options, (Object)"options");
            Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            DefaultThreadFactory threadFactory = new DefaultThreadFactory("CosmosEventLoop", true);
            int threadCount = Runtime.getRuntime().availableProcessors();
            Object wireLogLevel = logger.isTraceEnabled() ? LogLevel.TRACE : (logger.isDebugEnabled() ? LogLevel.DEBUG : null);
            this.config = new RntbdEndpoint.Config(options, sslContext, (LogLevel)wireLogLevel);
            this.requestTimer = new RntbdRequestTimer(this.config.getRequestTimeout());
            this.eventLoopGroup = new NioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
        }

        @Override
        public void close() throws RuntimeException {
            if (this.closed.compareAndSet(false, true)) {
                this.requestTimer.close();
                for (RntbdEndpoint endpoint : this.endpoints.values()) {
                    endpoint.close();
                }
                this.eventLoopGroup.shutdownGracefully().addListener(future -> {
                    if (future.isSuccess()) {
                        logger.debug("\n  [{}]\n  closed endpoints", (Object)this);
                        return;
                    }
                    logger.error("\n  [{}]\n  failed to close endpoints due to ", (Object)this, (Object)future.cause());
                });
                return;
            }
            logger.debug("\n  [{}]\n  already closed", (Object)this);
        }

        @Override
        public RntbdEndpoint.Config config() {
            return this.config;
        }

        @Override
        public int count() {
            return this.endpoints.size();
        }

        @Override
        public RntbdEndpoint get(URI physicalAddress) {
            return this.endpoints.computeIfAbsent(physicalAddress.getAuthority(), authority -> new RntbdServiceEndpoint(this.config, this.eventLoopGroup, this.requestTimer, physicalAddress));
        }

        @Override
        public Stream<RntbdEndpoint> list() {
            return this.endpoints.values().stream();
        }

        private void deleteEndpoint(URI physicalAddress) {
            Preconditions.checkNotNull((Object)physicalAddress, (String)"physicalAddress: %s", (Object)physicalAddress);
            String authority = physicalAddress.getAuthority();
            RntbdEndpoint endpoint = this.endpoints.remove(authority);
            if (endpoint != null) {
                endpoint.close();
            }
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdServiceEndpoint> {
        public JsonSerializer() {
            this(null);
        }

        public JsonSerializer(Class<RntbdServiceEndpoint> type) {
            super(type);
        }

        public void serialize(RntbdServiceEndpoint value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeStringField(value.name, value.remoteAddress.toString());
            generator.writeObjectField("channelPool", (Object)value.channelPool);
            generator.writeEndObject();
        }
    }
}

