/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.cryptography.SymmetricEncryptionAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AesCbc
extends SymmetricEncryptionAlgorithm {
    final int keySizeInBytes;
    final int keySize;

    protected AesCbc(String name, int size) {
        super(name);
        this.keySize = size;
        this.keySizeInBytes = size >> 3;
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv, byte[] authenticationData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null || key.length < this.keySizeInBytes) {
            throw new InvalidKeyException("key must be at least " + this.keySize + " bits in length");
        }
        return new AesCbcEncryptor(Arrays.copyOfRange(key, 0, this.keySizeInBytes), iv, null);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv, byte[] authenticationData, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null || key.length < this.keySizeInBytes) {
            throw new InvalidKeyException("key must be at least " + this.keySize + " bits in length");
        }
        return new AesCbcEncryptor(Arrays.copyOfRange(key, 0, this.keySizeInBytes), iv, provider);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null || key.length < this.keySizeInBytes) {
            throw new InvalidKeyException("key must be at least " + this.keySize + " bits in length");
        }
        return new AesCbcDecryptor(Arrays.copyOfRange(key, 0, this.keySizeInBytes), iv, null);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null || key.length < this.keySizeInBytes) {
            throw new InvalidKeyException("key must be at least " + this.keySize + " bits in length");
        }
        return new AesCbcDecryptor(Arrays.copyOfRange(key, 0, this.keySizeInBytes), iv, provider);
    }

    static class AesCbcEncryptor
    implements ICryptoTransform {
        private final Cipher _cipher;

        AesCbcEncryptor(byte[] key, byte[] iv, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            this._cipher = provider == null ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance("AES/CBC/PKCS5Padding", provider);
            this._cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this._cipher.doFinal(plaintext);
        }
    }

    static class AesCbcDecryptor
    implements ICryptoTransform {
        private final Cipher _cipher;

        AesCbcDecryptor(byte[] key, byte[] iv, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            this._cipher = provider == null ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance("AES/CBC/PKCS5Padding", provider);
            this._cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this._cipher.doFinal(plaintext);
        }
    }
}

