/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.ByteExtensions;
import com.microsoft.azure.keyvault.cryptography.IAuthenticatedCryptoTransform;
import com.microsoft.azure.keyvault.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.cryptography.SymmetricEncryptionAlgorithm;
import com.microsoft.azure.keyvault.cryptography.algorithms.AesCbc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AesCbcHmacSha2
extends SymmetricEncryptionAlgorithm {
    protected AesCbcHmacSha2(String name) {
        super(name);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.CreateDecryptor(key, iv, authenticationData, authenticationTag, null);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("No key material");
        }
        if (iv == null) {
            throw new IllegalArgumentException("No initialization vector");
        }
        if (authenticationData == null) {
            throw new IllegalArgumentException("No authentication data");
        }
        if (authenticationTag == null) {
            throw new IllegalArgumentException("No authentication tag");
        }
        return new AesCbcHmacSha2Decryptor(this.getName(), key, iv, authenticationData, authenticationTag, provider);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv, byte[] authenticationData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.CreateEncryptor(key, iv, authenticationData, null);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv, byte[] authenticationData, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("No key material");
        }
        if (iv == null) {
            throw new IllegalArgumentException("No initialization vector");
        }
        if (authenticationData == null) {
            throw new IllegalArgumentException("No authentication data");
        }
        return new AesCbcHmacSha2Encryptor(this.getName(), key, iv, authenticationData, provider);
    }

    private static Triple<byte[], byte[], Mac> GetAlgorithmParameters(String algorithm, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac hmac;
        byte[] aes_key;
        byte[] hmac_key;
        if (algorithm.equalsIgnoreCase("A128CBC-HS256")) {
            if (key.length << 3 < 256) {
                throw new IllegalArgumentException(String.format("%s key length in bits %d < 256", algorithm, key.length << 3));
            }
            hmac_key = new byte[16];
            aes_key = new byte[16];
            System.arraycopy(key, 0, hmac_key, 0, 16);
            System.arraycopy(key, 16, aes_key, 0, 16);
            hmac = Mac.getInstance("HmacSHA256");
            hmac.init(new SecretKeySpec(hmac_key, "HmacSHA256"));
        } else if (algorithm.equalsIgnoreCase("A192CBC-HS384")) {
            if (key.length << 3 < 384) {
                throw new IllegalArgumentException(String.format("%s key length in bits %d < 384", algorithm, key.length << 3));
            }
            hmac_key = new byte[24];
            aes_key = new byte[24];
            System.arraycopy(key, 0, hmac_key, 0, 24);
            System.arraycopy(key, 24, aes_key, 0, 24);
            hmac = Mac.getInstance("HmacSHA384");
            hmac.init(new SecretKeySpec(hmac_key, "HmacSHA384"));
        } else if (algorithm.equalsIgnoreCase("A256CBC-HS512")) {
            if (key.length << 3 < 512) {
                throw new IllegalArgumentException(String.format("%s key length in bits %d < 512", algorithm, key.length << 3));
            }
            hmac_key = new byte[32];
            aes_key = new byte[32];
            System.arraycopy(key, 0, hmac_key, 0, 32);
            System.arraycopy(key, 32, aes_key, 0, 32);
            hmac = Mac.getInstance("HmacSHA512");
            hmac.init(new SecretKeySpec(hmac_key, "HmacSHA512"));
        } else {
            throw new IllegalArgumentException(String.format("Unsupported algorithm: %s", algorithm));
        }
        return Triple.of((Object)aes_key, (Object)hmac_key, (Object)hmac);
    }

    static byte[] toBigEndian(long i) {
        byte[] shortRepresentation = BigInteger.valueOf(i).toByteArray();
        byte[] longRepresentation = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(shortRepresentation, 0, longRepresentation, longRepresentation.length - shortRepresentation.length, shortRepresentation.length);
        return longRepresentation;
    }

    static class AesCbcHmacSha2Encryptor
    implements IAuthenticatedCryptoTransform {
        final byte[] _aad_length;
        final Mac _hmac;
        final byte[] _hmac_key;
        final ICryptoTransform _inner;
        byte[] _tag;

        AesCbcHmacSha2Encryptor(String name, byte[] key, byte[] iv, byte[] authenticationData, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
            Triple parameters = AesCbcHmacSha2.GetAlgorithmParameters(name, key);
            this._hmac = (Mac)parameters.getRight();
            this._hmac_key = (byte[])parameters.getMiddle();
            this._inner = new AesCbc.AesCbcEncryptor((byte[])parameters.getLeft(), iv, provider);
            this._aad_length = AesCbcHmacSha2.toBigEndian(authenticationData.length * 8);
            this._hmac.update(authenticationData);
            this._hmac.update(iv);
        }

        @Override
        public byte[] getTag() {
            return this._tag;
        }

        @Override
        public byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] output = this._inner.doFinal(input);
            this._hmac.update(output);
            byte[] hash = this._hmac.doFinal(this._aad_length);
            this._tag = new byte[this._hmac_key.length];
            System.arraycopy(hash, 0, this._tag, 0, this._tag.length);
            return output;
        }
    }

    static class AesCbcHmacSha2Decryptor
    implements IAuthenticatedCryptoTransform {
        final byte[] _aad_length;
        final Mac _hmac;
        final byte[] _hmac_key;
        final ICryptoTransform _inner;
        byte[] _tag;

        AesCbcHmacSha2Decryptor(String name, byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
            Triple parameters = AesCbcHmacSha2.GetAlgorithmParameters(name, key);
            this._hmac = (Mac)parameters.getRight();
            this._hmac_key = (byte[])parameters.getMiddle();
            this._inner = new AesCbc.AesCbcDecryptor((byte[])parameters.getLeft(), iv, provider);
            this._aad_length = AesCbcHmacSha2.toBigEndian(authenticationData.length * 8);
            this._tag = authenticationTag;
            this._hmac.update(authenticationData);
            this._hmac.update(iv);
        }

        @Override
        public byte[] getTag() {
            return this._tag;
        }

        @Override
        public byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException {
            this._hmac.update(input);
            byte[] hash = this._hmac.doFinal(this._aad_length);
            byte[] tag = new byte[this._hmac_key.length];
            System.arraycopy(hash, 0, tag, 0, this._hmac_key.length);
            if (!ByteExtensions.sequenceEqualConstantTime(this._tag, tag)) {
                throw new IllegalArgumentException("Data is not authentic");
            }
            return this._inner.doFinal(input);
        }
    }
}

