/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.cryptography.KeyWrapAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AesKw
extends KeyWrapAlgorithm {
    static final byte[] _defaultIv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    static final String _cipherName = "AESWrap";

    protected AesKw(String name) {
        super(name);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.CreateEncryptor(key, null, null);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.CreateEncryptor(key, null, provider);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.CreateEncryptor(key, iv, null);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("key length must be 128, 192 or 256 bits");
        }
        if (iv != null) {
            if (iv.length != 8) {
                throw new IllegalArgumentException("iv length must be 64 bits");
            }
            if (provider == null) {
                throw new IllegalArgumentException("user specified iv is not supported with the default provider");
            }
        }
        return new AesKwEncryptor(key, iv == null ? _defaultIv : iv, provider);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.CreateDecryptor(key, null, null);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.CreateDecryptor(key, null, provider);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.CreateDecryptor(key, iv, null);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("key length must be 128, 192 or 256 bits");
        }
        if (iv != null) {
            if (iv.length != 8) {
                throw new IllegalArgumentException("iv length must be 64 bits");
            }
            if (provider == null) {
                throw new IllegalArgumentException("user specified iv is not supported with the default provider");
            }
        }
        return new AesKwDecryptor(key, iv == null ? _defaultIv : iv, provider);
    }

    class AesKwEncryptor
    implements ICryptoTransform {
        final Cipher _cipher;

        AesKwEncryptor(byte[] key, byte[] iv, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            this._cipher = provider == null ? Cipher.getInstance(AesKw._cipherName) : Cipher.getInstance(AesKw._cipherName, provider);
            if (provider == null) {
                this._cipher.init(3, new SecretKeySpec(key, "AES"));
            } else {
                this._cipher.init(3, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            }
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
            return this._cipher.wrap(new SecretKeySpec(plaintext, "AES"));
        }
    }

    class AesKwDecryptor
    implements ICryptoTransform {
        final Cipher _cipher;

        AesKwDecryptor(byte[] key, byte[] iv, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            this._cipher = provider == null ? Cipher.getInstance(AesKw._cipherName) : Cipher.getInstance(AesKw._cipherName, provider);
            if (provider == null) {
                this._cipher.init(4, new SecretKeySpec(key, "AES"));
            } else {
                this._cipher.init(4, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            }
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException {
            return this._cipher.unwrap(plaintext, AesKw._cipherName, 3).getEncoded();
        }
    }
}

