/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.BaseEncoding;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlots;
import com.microsoft.azure.management.appservice.FunctionRuntimeStack;
import com.microsoft.azure.management.appservice.NameValuePair;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.SkuDescription;
import com.microsoft.azure.management.appservice.SkuName;
import com.microsoft.azure.management.appservice.implementation.AppServiceBaseImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.AppServicePlanInner;
import com.microsoft.azure.management.appservice.implementation.FunctionDeploymentSlotsImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.StorageAccountSkuType;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.joda.time.DateTime;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionAppImpl
extends AppServiceBaseImpl<FunctionApp, FunctionAppImpl, FunctionApp.DefinitionStages.WithCreate, FunctionApp.Update>
implements FunctionApp,
FunctionApp.Definition,
FunctionApp.DefinitionStages.NewAppServicePlanWithGroup,
FunctionApp.DefinitionStages.ExistingLinuxPlanWithGroup,
FunctionApp.Update {
    private static final String SETTING_FUNCTIONS_WORKER_RUNTIME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String SETTING_FUNCTIONS_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    private static final String SETTING_WEBSITE_CONTENTAZUREFILECONNECTIONSTRING = "WEBSITE_CONTENTAZUREFILECONNECTIONSTRING";
    private static final String SETTING_WEBSITE_CONTENTSHARE = "WEBSITE_CONTENTSHARE";
    private static final String SETTING_WEB_JOBS_STORAGE = "AzureWebJobsStorage";
    private static final String SETTING_WEB_JOBS_DASHBOARD = "AzureWebJobsDashboard";
    private Creatable<StorageAccount> storageAccountCreatable;
    private StorageAccount storageAccountToSet;
    private StorageAccount currentStorageAccount;
    private final FunctionAppKeyService functionAppKeyService;
    private FunctionService functionService;
    private FunctionServiceViaKey functionServiceViaKey;
    private String cachedFunctionAppMasterKey;
    private FunctionDeploymentSlots deploymentSlots;
    private Func1<AppServicePlan, Void> linuxFxVersionSetter = null;
    private Observable<AppServicePlan> cachedAppServicePlanObservable = null;

    FunctionAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, AppServiceManager manager) {
        super(name, innerObject, siteConfig, logConfig, manager);
        this.functionAppKeyService = (FunctionAppKeyService)manager.restClient().retrofit().create(FunctionAppKeyService.class);
        if (!this.isInCreateMode()) {
            this.initializeFunctionService();
        }
    }

    private void initializeFunctionService() {
        if (this.functionService == null) {
            HttpUrl defaultHostName = HttpUrl.parse((String)this.defaultHostName());
            if (defaultHostName == null) {
                defaultHostName = new HttpUrl.Builder().host(this.defaultHostName()).scheme("http").build();
            }
            this.functionService = (FunctionService)((AppServiceManager)this.manager()).restClient().newBuilder().withBaseUrl(defaultHostName.toString()).withCredentials((ServiceClientCredentials)new FunctionCredentials(this)).withLogLevel(LogLevel.BODY_AND_HEADERS).build().retrofit().create(FunctionService.class);
            this.functionServiceViaKey = (FunctionServiceViaKey)((AppServiceManager)this.manager()).restClient().newBuilder().withBaseUrl(defaultHostName.toString()).withLogLevel(LogLevel.BODY_AND_HEADERS).build().retrofit().create(FunctionServiceViaKey.class);
        }
    }

    @Override
    public void setInner(SiteInner innerObject) {
        super.setInner(innerObject);
    }

    @Override
    public FunctionDeploymentSlots deploymentSlots() {
        if (this.deploymentSlots == null) {
            this.deploymentSlots = new FunctionDeploymentSlotsImpl(this);
        }
        return this.deploymentSlots;
    }

    @Override
    public FunctionAppImpl withNewConsumptionPlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withNewConsumptionPlan(String appServicePlanName) {
        return this.withNewAppServicePlan(appServicePlanName, OperatingSystem.WINDOWS, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withRuntime(String runtime) {
        return (FunctionAppImpl)this.withAppSetting(SETTING_FUNCTIONS_WORKER_RUNTIME, runtime);
    }

    @Override
    public FunctionAppImpl withRuntimeVersion(String version) {
        return (FunctionAppImpl)this.withAppSetting(SETTING_FUNCTIONS_EXTENSION_VERSION, version.startsWith("~") ? version : "~" + version);
    }

    @Override
    public FunctionAppImpl withLatestRuntimeVersion() {
        return this.withRuntimeVersion("latest");
    }

    @Override
    Observable<Indexable> submitSiteConfig() {
        if (this.linuxFxVersionSetter != null) {
            this.cachedAppServicePlanObservable = this.cachedAppServicePlanObservable();
            return this.cachedAppServicePlanObservable.map(this.linuxFxVersionSetter).flatMap((Func1)new Func1<Void, Observable<Indexable>>(){

                public Observable<Indexable> call(Void aVoid) {
                    return FunctionAppImpl.super.submitSiteConfig();
                }
            });
        }
        return super.submitSiteConfig();
    }

    @Override
    Observable<Indexable> submitAppSettings() {
        if (this.storageAccountCreatable != null && this.taskResult(this.storageAccountCreatable.key()) != null) {
            this.storageAccountToSet = (StorageAccount)this.taskResult(this.storageAccountCreatable.key());
        }
        if (this.storageAccountToSet == null) {
            return super.submitAppSettings();
        }
        if (this.cachedAppServicePlanObservable == null) {
            this.cachedAppServicePlanObservable = this.cachedAppServicePlanObservable();
        }
        return Observable.merge((Observable)this.storageAccountToSet.getKeysAsync().flatMapIterable((Func1)new Func1<List<StorageAccountKey>, Iterable<StorageAccountKey>>(){

            public Iterable<StorageAccountKey> call(List<StorageAccountKey> storageAccountKeys) {
                return storageAccountKeys;
            }
        }).first().zipWith(this.cachedAppServicePlanObservable, (Func2)new Func2<StorageAccountKey, AppServicePlan, Observable<Indexable>>(){

            public Observable<Indexable> call(StorageAccountKey storageAccountKey, AppServicePlan appServicePlan) {
                String connectionString = Utils.getStorageConnectionString((String)FunctionAppImpl.this.storageAccountToSet.name(), (String)storageAccountKey.value(), (RestClient)((AppServiceManager)FunctionAppImpl.this.manager()).restClient());
                FunctionAppImpl.this.addAppSettingIfNotModified(FunctionAppImpl.SETTING_WEB_JOBS_STORAGE, connectionString);
                FunctionAppImpl.this.addAppSettingIfNotModified(FunctionAppImpl.SETTING_WEB_JOBS_DASHBOARD, connectionString);
                if (OperatingSystem.WINDOWS.equals((Object)FunctionAppImpl.this.operatingSystem()) && (appServicePlan == null || FunctionAppImpl.isConsumptionOrPremiumAppServicePlan(appServicePlan.pricingTier()))) {
                    FunctionAppImpl.this.addAppSettingIfNotModified(FunctionAppImpl.SETTING_WEBSITE_CONTENTAZUREFILECONNECTIONSTRING, connectionString);
                    FunctionAppImpl.this.addAppSettingIfNotModified(FunctionAppImpl.SETTING_WEBSITE_CONTENTSHARE, SdkContext.randomResourceName((String)FunctionAppImpl.this.name(), (int)32));
                }
                return FunctionAppImpl.super.submitAppSettings();
            }
        })).doOnCompleted(new Action0(){

            public void call() {
                FunctionAppImpl.this.currentStorageAccount = FunctionAppImpl.this.storageAccountToSet;
                FunctionAppImpl.this.storageAccountToSet = null;
                FunctionAppImpl.this.storageAccountCreatable = null;
                FunctionAppImpl.this.cachedAppServicePlanObservable = null;
            }
        });
    }

    @Override
    public OperatingSystem operatingSystem() {
        return ((SiteInner)((Object)this.inner())).reserved() == null || ((SiteInner)((Object)this.inner())).reserved() == false ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    private void addAppSettingIfNotModified(String key, String value) {
        if (!this.appSettingModified(key)) {
            this.withAppSetting(key, value);
        }
    }

    private boolean appSettingModified(String key) {
        return this.appSettingsToAdd != null && this.appSettingsToAdd.containsKey(key) || this.appSettingsToRemove != null && this.appSettingsToRemove.contains(key);
    }

    private static boolean isConsumptionOrPremiumAppServicePlan(PricingTier pricingTier) {
        if (pricingTier == null || pricingTier.toSkuDescription() == null) {
            return true;
        }
        SkuDescription description = pricingTier.toSkuDescription();
        return SkuName.DYNAMIC.toString().equalsIgnoreCase(description.tier()) || SkuName.ELASTIC_PREMIUM.toString().equalsIgnoreCase(description.tier());
    }

    private static boolean isConsumptionPlan(PricingTier pricingTier) {
        if (pricingTier == null || pricingTier.toSkuDescription() == null) {
            return true;
        }
        SkuDescription description = pricingTier.toSkuDescription();
        return SkuName.DYNAMIC.toString().equalsIgnoreCase(description.tier());
    }

    @Override
    FunctionAppImpl withNewAppServicePlan(OperatingSystem operatingSystem, PricingTier pricingTier) {
        return ((FunctionAppImpl)super.withNewAppServicePlan(operatingSystem, pricingTier)).autoSetAlwaysOn(pricingTier);
    }

    @Override
    FunctionAppImpl withNewAppServicePlan(String appServicePlan, OperatingSystem operatingSystem, PricingTier pricingTier) {
        return ((FunctionAppImpl)super.withNewAppServicePlan(appServicePlan, operatingSystem, pricingTier)).autoSetAlwaysOn(pricingTier);
    }

    @Override
    public FunctionAppImpl withExistingAppServicePlan(AppServicePlan appServicePlan) {
        super.withExistingAppServicePlan(appServicePlan);
        return this.autoSetAlwaysOn(appServicePlan.pricingTier());
    }

    private FunctionAppImpl autoSetAlwaysOn(PricingTier pricingTier) {
        SkuDescription description = pricingTier.toSkuDescription();
        if (description.tier().equalsIgnoreCase(SkuName.BASIC.toString()) || description.tier().equalsIgnoreCase(SkuName.STANDARD.toString()) || description.tier().equalsIgnoreCase(SkuName.PREMIUM.toString()) || description.tier().equalsIgnoreCase(SkuName.PREMIUM_V2.toString())) {
            return (FunctionAppImpl)this.withWebAppAlwaysOn(true);
        }
        return (FunctionAppImpl)this.withWebAppAlwaysOn(false);
    }

    @Override
    public FunctionAppImpl withNewStorageAccount(String name, com.microsoft.azure.management.storage.SkuName sku) {
        StorageAccount.DefinitionStages.WithGroup storageDefine = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)((AppServiceManager)this.manager()).storageManager().storageAccounts().define(name)).withRegion(this.regionName());
        this.storageAccountCreatable = this.creatableGroup != null && this.isInCreateMode() ? ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withNewResourceGroup(this.creatableGroup)).withGeneralPurposeAccountKind().withSku(sku) : ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withExistingResourceGroup(this.resourceGroupName())).withGeneralPurposeAccountKind().withSku(sku);
        this.addDependency(this.storageAccountCreatable);
        return this;
    }

    @Override
    public FunctionAppImpl withNewStorageAccount(String name, StorageAccountSkuType sku) {
        StorageAccount.DefinitionStages.WithGroup storageDefine = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)((AppServiceManager)this.manager()).storageManager().storageAccounts().define(name)).withRegion(this.regionName());
        this.storageAccountCreatable = this.creatableGroup != null && this.isInCreateMode() ? ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withNewResourceGroup(this.creatableGroup)).withGeneralPurposeAccountKind().withSku(sku) : ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withExistingResourceGroup(this.resourceGroupName())).withGeneralPurposeAccountKind().withSku(sku);
        this.addDependency(this.storageAccountCreatable);
        return this;
    }

    @Override
    public FunctionAppImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.storageAccountToSet = storageAccount;
        return this;
    }

    @Override
    public FunctionAppImpl withDailyUsageQuota(int quota) {
        ((SiteInner)((Object)this.inner())).withDailyMemoryTimeQuota(quota);
        return this;
    }

    @Override
    public FunctionAppImpl withoutDailyUsageQuota() {
        return this.withDailyUsageQuota(0);
    }

    @Override
    public FunctionAppImpl withNewLinuxConsumptionPlan() {
        return this.withNewAppServicePlan(OperatingSystem.LINUX, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withNewLinuxConsumptionPlan(String appServicePlanName) {
        return this.withNewAppServicePlan(appServicePlanName, OperatingSystem.LINUX, new PricingTier(SkuName.DYNAMIC.toString(), "Y1"));
    }

    @Override
    public FunctionAppImpl withNewLinuxAppServicePlan(PricingTier pricingTier) {
        return (FunctionAppImpl)super.withNewAppServicePlan(OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public FunctionAppImpl withNewLinuxAppServicePlan(String appServicePlanName, PricingTier pricingTier) {
        return (FunctionAppImpl)super.withNewAppServicePlan(appServicePlanName, OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public FunctionAppImpl withNewLinuxAppServicePlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        super.withNewAppServicePlan(appServicePlanCreatable);
        if (appServicePlanCreatable instanceof AppServicePlan) {
            this.autoSetAlwaysOn(((AppServicePlan)appServicePlanCreatable).pricingTier());
        }
        return this;
    }

    @Override
    public FunctionAppImpl withExistingLinuxAppServicePlan(AppServicePlan appServicePlan) {
        return ((FunctionAppImpl)super.withExistingAppServicePlan(appServicePlan)).autoSetAlwaysOn(appServicePlan.pricingTier());
    }

    @Override
    public FunctionAppImpl withBuiltInImage(final FunctionRuntimeStack runtimeStack) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.withRuntime(runtimeStack.runtime());
        this.withRuntimeVersion(runtimeStack.version());
        this.linuxFxVersionSetter = new Func1<AppServicePlan, Void>(){

            public Void call(AppServicePlan appServicePlan) {
                if (appServicePlan == null || FunctionAppImpl.isConsumptionPlan(appServicePlan.pricingTier())) {
                    FunctionAppImpl.this.siteConfig.withLinuxFxVersion(runtimeStack.getLinuxFxVersionForConsumptionPlan());
                } else {
                    FunctionAppImpl.this.siteConfig.withLinuxFxVersion(runtimeStack.getLinuxFxVersionForDedicatedPlan());
                }
                return null;
            }
        };
        return this;
    }

    @Override
    public FunctionAppImpl withPublicDockerHubImage(String imageAndTag) {
        this.ensureLinuxPlan();
        return (FunctionAppImpl)super.withPublicDockerHubImage(imageAndTag);
    }

    @Override
    public FunctionAppImpl withPrivateDockerHubImage(String imageAndTag) {
        this.ensureLinuxPlan();
        return (FunctionAppImpl)super.withPublicDockerHubImage(imageAndTag);
    }

    @Override
    public FunctionAppImpl withPrivateRegistryImage(String imageAndTag, String serverUrl) {
        this.ensureLinuxPlan();
        return (FunctionAppImpl)super.withPrivateRegistryImage(imageAndTag, serverUrl);
    }

    @Override
    protected void cleanUpContainerSettings() {
        this.linuxFxVersionSetter = null;
        if (this.siteConfig != null && this.siteConfig.linuxFxVersion() != null) {
            this.siteConfig.withLinuxFxVersion(null);
        }
        this.withoutAppSetting("DOCKER_CUSTOM_IMAGE_NAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_URL");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_USERNAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD");
    }

    @Override
    protected OperatingSystem appServicePlanOperatingSystem(AppServicePlan appServicePlan) {
        return ((AppServicePlanInner)((Object)appServicePlan.inner())).reserved() == null || ((AppServicePlanInner)((Object)appServicePlan.inner())).reserved() == false ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    private Observable<AppServicePlan> cachedAppServicePlanObservable() {
        return ((AppServiceManager)this.manager()).appServicePlans().getByIdAsync(this.appServicePlanId()).cacheWithInitialCapacity(1);
    }

    @Override
    public StorageAccount storageAccount() {
        return this.currentStorageAccount;
    }

    @Override
    public String getMasterKey() {
        return (String)this.getMasterKeyAsync().toBlocking().single();
    }

    @Override
    public Observable<String> getMasterKeyAsync() {
        return this.functionAppKeyService.getMasterKey(this.resourceGroupName(), this.name(), ((AppServiceManager)this.manager()).subscriptionId(), "2019-08-01", ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).userAgent()).map((Func1)new Func1<ListKeysResult, String>(){

            public String call(ListKeysResult keys) {
                return keys.getMasterKey();
            }
        });
    }

    @Override
    public Map<String, String> listFunctionKeys(String functionName) {
        return (Map)this.listFunctionKeysAsync(functionName).toBlocking().single();
    }

    @Override
    public Observable<Map<String, String>> listFunctionKeysAsync(String functionName) {
        return this.functionService.listFunctionKeys(functionName).map((Func1)new Func1<FunctionKeyListResult, Map<String, String>>(){

            public Map<String, String> call(FunctionKeyListResult result) {
                HashMap<String, String> keys = new HashMap<String, String>();
                if (result.keys != null) {
                    for (NameValuePair pair : result.keys) {
                        keys.put(pair.name(), pair.value());
                    }
                }
                return keys;
            }
        });
    }

    @Override
    public NameValuePair addFunctionKey(String functionName, String keyName, String keyValue) {
        return (NameValuePair)this.addFunctionKeyAsync(functionName, keyName, keyValue).toBlocking().single();
    }

    @Override
    public Observable<NameValuePair> addFunctionKeyAsync(String functionName, String keyName, String keyValue) {
        if (keyValue != null) {
            return this.functionService.addFunctionKey(functionName, keyName, new NameValuePair().withName(keyName).withValue(keyValue));
        }
        return this.functionService.generateFunctionKey(functionName, keyName);
    }

    @Override
    public void removeFunctionKey(String functionName, String keyName) {
        this.removeFunctionKeyAsync(functionName, keyName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable removeFunctionKeyAsync(String functionName, String keyName) {
        return this.functionService.deleteFunctionKey(functionName, keyName).toCompletable();
    }

    @Override
    public void triggerFunction(String functionName, Object payload) {
        this.triggerFunctionAsync(functionName, payload).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable triggerFunctionAsync(final String functionName, final Object payload) {
        return this.getCachedMasterKey().flatMap((Func1)new Func1<String, Observable<Void>>(){

            public Observable<Void> call(String s) {
                return FunctionAppImpl.this.functionServiceViaKey.triggerFunction(s, functionName, payload);
            }
        }).toCompletable();
    }

    private Observable<String> getCachedMasterKey() {
        if (this.cachedFunctionAppMasterKey != null) {
            return Observable.just((Object)this.cachedFunctionAppMasterKey);
        }
        return this.getMasterKeyAsync().map((Func1)new Func1<String, String>(){

            public String call(String s) {
                FunctionAppImpl.this.cachedFunctionAppMasterKey = s;
                return s;
            }
        });
    }

    @Override
    public void syncTriggers() {
        this.syncTriggersAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable syncTriggersAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().syncFunctionTriggersAsync(this.resourceGroupName(), this.name()).toCompletable().onErrorResumeNext((Func1)new Func1<Throwable, Completable>(){

            public Completable call(Throwable throwable) {
                if (throwable instanceof CloudException && ((CloudException)throwable).response().code() == 200) {
                    return Completable.complete();
                }
                return Completable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<String> streamApplicationLogsAsync() {
        return this.functionService.ping().mergeWith(this.functionService.getHostStatus()).last().flatMap((Func1)new Func1<Void, Observable<String>>(){

            public Observable<String> call(Void aVoid) {
                return FunctionAppImpl.super.streamApplicationLogsAsync();
            }
        });
    }

    @Override
    public Observable<String> streamHttpLogsAsync() {
        return this.functionService.ping().mergeWith(this.functionService.getHostStatus()).last().flatMap((Func1)new Func1<Void, Observable<String>>(){

            public Observable<String> call(Void aVoid) {
                return FunctionAppImpl.super.streamHttpLogsAsync();
            }
        });
    }

    @Override
    public Observable<String> streamTraceLogsAsync() {
        return this.functionService.ping().mergeWith(this.functionService.getHostStatus()).last().flatMap((Func1)new Func1<Void, Observable<String>>(){

            public Observable<String> call(Void aVoid) {
                return FunctionAppImpl.super.streamTraceLogsAsync();
            }
        });
    }

    @Override
    public Observable<String> streamDeploymentLogsAsync() {
        return this.functionService.ping().mergeWith(this.functionService.getHostStatus()).last().flatMap((Func1)new Func1<Void, Observable<String>>(){

            public Observable<String> call(Void aVoid) {
                return FunctionAppImpl.super.streamDeploymentLogsAsync();
            }
        });
    }

    @Override
    public Observable<String> streamAllLogsAsync() {
        return this.functionService.ping().mergeWith(this.functionService.getHostStatus()).last().flatMap((Func1)new Func1<Void, Observable<String>>(){

            public Observable<String> call(Void aVoid) {
                return FunctionAppImpl.super.streamAllLogsAsync();
            }
        });
    }

    @Override
    public Completable zipDeployAsync(File zipFile) {
        try {
            return this.zipDeployAsync(new FileInputStream(zipFile));
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    public Completable zipDeployAsync(InputStream zipFile) {
        return this.kuduClient.zipDeployAsync(zipFile);
    }

    @Override
    public void zipDeploy(InputStream zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    public Observable<Indexable> createAsync() {
        if (this.isInCreateMode()) {
            if (((SiteInner)((Object)this.inner())).serverFarmId() == null) {
                this.withNewConsumptionPlan();
            }
            if (this.currentStorageAccount == null && this.storageAccountToSet == null && this.storageAccountCreatable == null) {
                this.withNewStorageAccount(SdkContext.randomResourceName((String)this.name(), (int)20), com.microsoft.azure.management.storage.SkuName.STANDARD_GRS);
            }
        }
        return super.createAsync();
    }

    @Override
    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        if (!isGroupFaulted) {
            this.initializeFunctionService();
        }
        return super.afterPostRunAsync(isGroupFaulted);
    }

    private static final class FunctionCredentials
    extends TokenCredentials {
        private String token;
        private long expire;
        private final FunctionAppImpl functionApp;

        private FunctionCredentials(FunctionAppImpl functionApp) {
            super("Bearer", null);
            this.functionApp = functionApp;
        }

        public String getToken(Request request) {
            if (this.token == null || this.expire < DateTime.now().getMillis()) {
                this.token = ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.functionApp.manager()).inner())).webApps().getFunctionsAdminToken(this.functionApp.resourceGroupName(), this.functionApp.name());
                String jwt = new String(BaseEncoding.base64Url().decode((CharSequence)this.token.split("\\.")[1]));
                Pattern pattern = Pattern.compile("\"exp\": *([0-9]+),");
                Matcher matcher = pattern.matcher(jwt);
                matcher.find();
                this.expire = Long.parseLong(matcher.group(1));
            }
            return this.token;
        }
    }

    private static class FunctionKeyListResult {
        @JsonProperty(value="keys")
        private List<NameValuePair> keys;

        private FunctionKeyListResult() {
        }
    }

    private static interface FunctionServiceViaKey {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps triggerFunction"})
        @POST(value="admin/functions/{name}")
        public Observable<Void> triggerFunction(@Header(value="x-functions-key") String var1, @Path(value="name") String var2, @Body Object var3);
    }

    private static interface FunctionService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listFunctionKeys"})
        @GET(value="admin/functions/{name}/keys")
        public Observable<FunctionKeyListResult> listFunctionKeys(@Path(value="name") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps addFunctionKey"})
        @PUT(value="admin/functions/{name}/keys/{keyName}")
        public Observable<NameValuePair> addFunctionKey(@Path(value="name") String var1, @Path(value="keyName") String var2, @Body NameValuePair var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps generateFunctionKey"})
        @POST(value="admin/functions/{name}/keys/{keyName}")
        public Observable<NameValuePair> generateFunctionKey(@Path(value="name") String var1, @Path(value="keyName") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteFunctionKey"})
        @DELETE(value="admin/functions/{name}/keys/{keyName}")
        public Observable<Void> deleteFunctionKey(@Path(value="name") String var1, @Path(value="keyName") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps ping"})
        @POST(value="admin/host/ping")
        public Observable<Void> ping();

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getHostStatus"})
        @GET(value="admin/host/status")
        public Observable<Void> getHostStatus();
    }

    private static interface FunctionAppKeyService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMasterKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listkeys")
        public Observable<ListKeysResult> getMasterKey(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="User-Agent") String var5);
    }

    private static class ListKeysResult {
        @JsonProperty(value="masterKey")
        private String masterKey;
        @JsonProperty(value="functionKeys")
        private Map<String, String> functionKeys;
        @JsonProperty(value="systemKeys")
        private Map<String, String> systemKeys;

        private ListKeysResult() {
        }

        public String getMasterKey() {
            return this.masterKey;
        }
    }
}

