/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Application logs azure blob storage configuration.
 */
public class AzureBlobStorageApplicationLogsConfig {
    /**
     * Log level. Possible values include: 'Off', 'Verbose', 'Information',
     * 'Warning', 'Error'.
     */
    @JsonProperty(value = "level")
    private LogLevel level;

    /**
     * SAS url to a azure blob container with read/write/list/delete
     * permissions.
     */
    @JsonProperty(value = "sasUrl")
    private String sasUrl;

    /**
     * Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    @JsonProperty(value = "retentionInDays")
    private Integer retentionInDays;

    /**
     * Get log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'.
     *
     * @return the level value
     */
    public LogLevel level() {
        return this.level;
    }

    /**
     * Set log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'.
     *
     * @param level the level value to set
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get sAS url to a azure blob container with read/write/list/delete permissions.
     *
     * @return the sasUrl value
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set sAS url to a azure blob container with read/write/list/delete permissions.
     *
     * @param sasUrl the sasUrl value to set
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
     *
     * @return the retentionInDays value
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
     *
     * @param retentionInDays the retentionInDays value to set
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

}
