/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ContainerCpuStatistics model.
 */
public class ContainerCpuStatistics {
    /**
     * The cpuUsage property.
     */
    @JsonProperty(value = "cpuUsage")
    private ContainerCpuUsage cpuUsage;

    /**
     * The systemCpuUsage property.
     */
    @JsonProperty(value = "systemCpuUsage")
    private Long systemCpuUsage;

    /**
     * The onlineCpuCount property.
     */
    @JsonProperty(value = "onlineCpuCount")
    private Integer onlineCpuCount;

    /**
     * The throttlingData property.
     */
    @JsonProperty(value = "throttlingData")
    private ContainerThrottlingData throttlingData;

    /**
     * Get the cpuUsage value.
     *
     * @return the cpuUsage value
     */
    public ContainerCpuUsage cpuUsage() {
        return this.cpuUsage;
    }

    /**
     * Set the cpuUsage value.
     *
     * @param cpuUsage the cpuUsage value to set
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withCpuUsage(ContainerCpuUsage cpuUsage) {
        this.cpuUsage = cpuUsage;
        return this;
    }

    /**
     * Get the systemCpuUsage value.
     *
     * @return the systemCpuUsage value
     */
    public Long systemCpuUsage() {
        return this.systemCpuUsage;
    }

    /**
     * Set the systemCpuUsage value.
     *
     * @param systemCpuUsage the systemCpuUsage value to set
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withSystemCpuUsage(Long systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
        return this;
    }

    /**
     * Get the onlineCpuCount value.
     *
     * @return the onlineCpuCount value
     */
    public Integer onlineCpuCount() {
        return this.onlineCpuCount;
    }

    /**
     * Set the onlineCpuCount value.
     *
     * @param onlineCpuCount the onlineCpuCount value to set
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withOnlineCpuCount(Integer onlineCpuCount) {
        this.onlineCpuCount = onlineCpuCount;
        return this;
    }

    /**
     * Get the throttlingData value.
     *
     * @return the throttlingData value
     */
    public ContainerThrottlingData throttlingData() {
        return this.throttlingData;
    }

    /**
     * Set the throttlingData value.
     *
     * @param throttlingData the throttlingData value to set
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withThrottlingData(ContainerThrottlingData throttlingData) {
        this.throttlingData = throttlingData;
        return this;
    }

}
