/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.DetectorInfo;
import java.util.List;
import com.microsoft.azure.management.appservice.DiagnosticData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Class representing Response from Detector.
 */
@JsonFlatten
public class DetectorResponseInner extends ProxyOnlyResource {
    /**
     * metadata for the detector.
     */
    @JsonProperty(value = "properties.metadata")
    private DetectorInfo metadata;

    /**
     * Data Set.
     */
    @JsonProperty(value = "properties.dataset")
    private List<DiagnosticData> dataset;

    /**
     * Get metadata for the detector.
     *
     * @return the metadata value
     */
    public DetectorInfo metadata() {
        return this.metadata;
    }

    /**
     * Set metadata for the detector.
     *
     * @param metadata the metadata value to set
     * @return the DetectorResponseInner object itself.
     */
    public DetectorResponseInner withMetadata(DetectorInfo metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get data Set.
     *
     * @return the dataset value
     */
    public List<DiagnosticData> dataset() {
        return this.dataset;
    }

    /**
     * Set data Set.
     *
     * @param dataset the dataset value to set
     * @return the DetectorResponseInner object itself.
     */
    public DetectorResponseInner withDataset(List<DiagnosticData> dataset) {
        this.dataset = dataset;
        return this;
    }

}
