/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Providers.
 */
public class ProvidersInner {
    /** The Retrofit service to perform REST calls. */
    private ProvidersService service;
    /** The service client containing this operation class. */
    private WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of ProvidersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ProvidersInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = retrofit.create(ProvidersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Providers to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ProvidersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacks" })
        @GET("providers/Microsoft.Web/availableStacks")
        Observable<Response<ResponseBody>> getAvailableStacks(@Query("osTypeSelected") String osTypeSelected, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listOperations" })
        @GET("providers/Microsoft.Web/operations")
        Observable<Response<ResponseBody>> listOperations(@Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("osTypeSelected") String osTypeSelected, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacksNext" })
        @GET
        Observable<Response<ResponseBody>> getAvailableStacksNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listOperationsNext" })
        @GET
        Observable<Response<ResponseBody>> listOperationsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object if successful.
     */
    public PagedList<ApplicationStackResourceInner> getAvailableStacks() {
        ServiceResponse<Page<ApplicationStackResourceInner>> response = getAvailableStacksSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>(response.body()) {
            @Override
            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ApplicationStackResourceInner>> getAvailableStacksAsync(final ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getAvailableStacksSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                    return getAvailableStacksNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<Page<ApplicationStackResourceInner>> getAvailableStacksAsync() {
        return getAvailableStacksWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>() {
                @Override
                public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksWithServiceResponseAsync() {
        return getAvailableStacksSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getAvailableStacksNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String osTypeSelected = null;
        return service.getAvailableStacks(osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationStackResourceInner>> result = getAvailableStacksDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationStackResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object if successful.
     */
    public PagedList<ApplicationStackResourceInner> getAvailableStacks(final String osTypeSelected) {
        ServiceResponse<Page<ApplicationStackResourceInner>> response = getAvailableStacksSinglePageAsync(osTypeSelected).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>(response.body()) {
            @Override
            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ApplicationStackResourceInner>> getAvailableStacksAsync(final String osTypeSelected, final ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getAvailableStacksSinglePageAsync(osTypeSelected),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                    return getAvailableStacksNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<Page<ApplicationStackResourceInner>> getAvailableStacksAsync(final String osTypeSelected) {
        return getAvailableStacksWithServiceResponseAsync(osTypeSelected)
            .map(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>() {
                @Override
                public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksWithServiceResponseAsync(final String osTypeSelected) {
        return getAvailableStacksSinglePageAsync(osTypeSelected)
            .concatMap(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getAvailableStacksNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
    ServiceResponse<PageImpl<ApplicationStackResourceInner>> * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksSinglePageAsync(final String osTypeSelected) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAvailableStacks(osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationStackResourceInner>> result = getAvailableStacksDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationStackResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> getAvailableStacksDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ApplicationStackResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CsmOperationDescriptionInner&gt; object if successful.
     */
    public PagedList<CsmOperationDescriptionInner> listOperations() {
        ServiceResponse<Page<CsmOperationDescriptionInner>> response = listOperationsSinglePageAsync().toBlocking().single();
        return new PagedList<CsmOperationDescriptionInner>(response.body()) {
            @Override
            public Page<CsmOperationDescriptionInner> nextPage(String nextPageLink) {
                return listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CsmOperationDescriptionInner>> listOperationsAsync(final ListOperationCallback<CsmOperationDescriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listOperationsSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(String nextPageLink) {
                    return listOperationsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmOperationDescriptionInner&gt; object
     */
    public Observable<Page<CsmOperationDescriptionInner>> listOperationsAsync() {
        return listOperationsWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Page<CsmOperationDescriptionInner>>() {
                @Override
                public Page<CsmOperationDescriptionInner> call(ServiceResponse<Page<CsmOperationDescriptionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmOperationDescriptionInner&gt; object
     */
    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsWithServiceResponseAsync() {
        return listOperationsSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(ServiceResponse<Page<CsmOperationDescriptionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listOperationsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CsmOperationDescriptionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listOperations(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CsmOperationDescriptionInner>> result = listOperationsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CsmOperationDescriptionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CsmOperationDescriptionInner>> listOperationsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CsmOperationDescriptionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CsmOperationDescriptionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object if successful.
     */
    public PagedList<ApplicationStackResourceInner> list() {
        ServiceResponse<Page<ApplicationStackResourceInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>(response.body()) {
            @Override
            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ApplicationStackResourceInner>> listAsync(final ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<Page<ApplicationStackResourceInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>() {
                @Override
                public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String osTypeSelected = null;
        return service.list(this.client.subscriptionId(), osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationStackResourceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationStackResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object if successful.
     */
    public PagedList<ApplicationStackResourceInner> list(final String osTypeSelected) {
        ServiceResponse<Page<ApplicationStackResourceInner>> response = listSinglePageAsync(osTypeSelected).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>(response.body()) {
            @Override
            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ApplicationStackResourceInner>> listAsync(final String osTypeSelected, final ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(osTypeSelected),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<Page<ApplicationStackResourceInner>> listAsync(final String osTypeSelected) {
        return listWithServiceResponseAsync(osTypeSelected)
            .map(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>() {
                @Override
                public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listWithServiceResponseAsync(final String osTypeSelected) {
        return listSinglePageAsync(osTypeSelected)
            .concatMap(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
    ServiceResponse<PageImpl<ApplicationStackResourceInner>> * @param osTypeSelected Possible values include: 'Windows', 'Linux', 'WindowsFunctions', 'LinuxFunctions'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listSinglePageAsync(final String osTypeSelected) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationStackResourceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationStackResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ApplicationStackResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object if successful.
     */
    public PagedList<ApplicationStackResourceInner> getAvailableStacksNext(final String nextPageLink) {
        ServiceResponse<Page<ApplicationStackResourceInner>> response = getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>(response.body()) {
            @Override
            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ApplicationStackResourceInner>> getAvailableStacksNextAsync(final String nextPageLink, final ServiceFuture<List<ApplicationStackResourceInner>> serviceFuture, final ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getAvailableStacksNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                    return getAvailableStacksNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<Page<ApplicationStackResourceInner>> getAvailableStacksNextAsync(final String nextPageLink) {
        return getAvailableStacksNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>() {
                @Override
                public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksNextWithServiceResponseAsync(final String nextPageLink) {
        return getAvailableStacksNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getAvailableStacksNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
    ServiceResponse<PageImpl<ApplicationStackResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.getAvailableStacksNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationStackResourceInner>> result = getAvailableStacksNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationStackResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> getAvailableStacksNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ApplicationStackResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CsmOperationDescriptionInner&gt; object if successful.
     */
    public PagedList<CsmOperationDescriptionInner> listOperationsNext(final String nextPageLink) {
        ServiceResponse<Page<CsmOperationDescriptionInner>> response = listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CsmOperationDescriptionInner>(response.body()) {
            @Override
            public Page<CsmOperationDescriptionInner> nextPage(String nextPageLink) {
                return listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CsmOperationDescriptionInner>> listOperationsNextAsync(final String nextPageLink, final ServiceFuture<List<CsmOperationDescriptionInner>> serviceFuture, final ListOperationCallback<CsmOperationDescriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listOperationsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(String nextPageLink) {
                    return listOperationsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmOperationDescriptionInner&gt; object
     */
    public Observable<Page<CsmOperationDescriptionInner>> listOperationsNextAsync(final String nextPageLink) {
        return listOperationsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Page<CsmOperationDescriptionInner>>() {
                @Override
                public Page<CsmOperationDescriptionInner> call(ServiceResponse<Page<CsmOperationDescriptionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmOperationDescriptionInner&gt; object
     */
    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsNextWithServiceResponseAsync(final String nextPageLink) {
        return listOperationsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(ServiceResponse<Page<CsmOperationDescriptionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listOperationsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions.
     *
    ServiceResponse<PageImpl<CsmOperationDescriptionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CsmOperationDescriptionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listOperationsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CsmOperationDescriptionInner>> result = listOperationsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CsmOperationDescriptionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CsmOperationDescriptionInner>> listOperationsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CsmOperationDescriptionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CsmOperationDescriptionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object if successful.
     */
    public PagedList<ApplicationStackResourceInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ApplicationStackResourceInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>(response.body()) {
            @Override
            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ApplicationStackResourceInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ApplicationStackResourceInner>> serviceFuture, final ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<Page<ApplicationStackResourceInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>() {
                @Override
                public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ApplicationStackResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available application frameworks and their versions.
     * Description for Get available application frameworks and their versions.
     *
    ServiceResponse<PageImpl<ApplicationStackResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ApplicationStackResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationStackResourceInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationStackResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ApplicationStackResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

}
