/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for FileServerProvisioningState.
 */
public enum FileServerProvisioningState {
    /** Enum value creating. */
    CREATING("creating"),

    /** Enum value updating. */
    UPDATING("updating"),

    /** Enum value deleting. */
    DELETING("deleting"),

    /** Enum value succeeded. */
    SUCCEEDED("succeeded"),

    /** Enum value failed. */
    FAILED("failed");

    /** The actual serialized value for a FileServerProvisioningState instance. */
    private String value;

    FileServerProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a FileServerProvisioningState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed FileServerProvisioningState object, or null if unable to parse.
     */
    @JsonCreator
    public static FileServerProvisioningState fromString(String value) {
        FileServerProvisioningState[] items = FileServerProvisioningState.values();
        for (FileServerProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
