/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Counts of various compute node states on the cluster.
 */
public class NodeStateCounts {
    /**
     * Number of compute nodes in idle state.
     */
    @JsonProperty(value = "idleNodeCount", required = true)
    private int idleNodeCount;

    /**
     * Number of compute nodes which are running jobs.
     */
    @JsonProperty(value = "runningNodeCount", required = true)
    private int runningNodeCount;

    /**
     * Number of compute nodes which are being prepared.
     */
    @JsonProperty(value = "preparingNodeCount", required = true)
    private int preparingNodeCount;

    /**
     * Number of compute nodes which are unusable.
     */
    @JsonProperty(value = "unusableNodeCount", required = true)
    private int unusableNodeCount;

    /**
     * Number of compute nodes which are leaving the cluster.
     */
    @JsonProperty(value = "leavingNodeCount", required = true)
    private int leavingNodeCount;

    /**
     * Get the idleNodeCount value.
     *
     * @return the idleNodeCount value
     */
    public int idleNodeCount() {
        return this.idleNodeCount;
    }

    /**
     * Set the idleNodeCount value.
     *
     * @param idleNodeCount the idleNodeCount value to set
     * @return the NodeStateCounts object itself.
     */
    public NodeStateCounts withIdleNodeCount(int idleNodeCount) {
        this.idleNodeCount = idleNodeCount;
        return this;
    }

    /**
     * Get the runningNodeCount value.
     *
     * @return the runningNodeCount value
     */
    public int runningNodeCount() {
        return this.runningNodeCount;
    }

    /**
     * Set the runningNodeCount value.
     *
     * @param runningNodeCount the runningNodeCount value to set
     * @return the NodeStateCounts object itself.
     */
    public NodeStateCounts withRunningNodeCount(int runningNodeCount) {
        this.runningNodeCount = runningNodeCount;
        return this;
    }

    /**
     * Get the preparingNodeCount value.
     *
     * @return the preparingNodeCount value
     */
    public int preparingNodeCount() {
        return this.preparingNodeCount;
    }

    /**
     * Set the preparingNodeCount value.
     *
     * @param preparingNodeCount the preparingNodeCount value to set
     * @return the NodeStateCounts object itself.
     */
    public NodeStateCounts withPreparingNodeCount(int preparingNodeCount) {
        this.preparingNodeCount = preparingNodeCount;
        return this;
    }

    /**
     * Get the unusableNodeCount value.
     *
     * @return the unusableNodeCount value
     */
    public int unusableNodeCount() {
        return this.unusableNodeCount;
    }

    /**
     * Set the unusableNodeCount value.
     *
     * @param unusableNodeCount the unusableNodeCount value to set
     * @return the NodeStateCounts object itself.
     */
    public NodeStateCounts withUnusableNodeCount(int unusableNodeCount) {
        this.unusableNodeCount = unusableNodeCount;
        return this;
    }

    /**
     * Get the leavingNodeCount value.
     *
     * @return the leavingNodeCount value
     */
    public int leavingNodeCount() {
        return this.leavingNodeCount;
    }

    /**
     * Set the leavingNodeCount value.
     *
     * @param leavingNodeCount the leavingNodeCount value to set
     * @return the NodeStateCounts object itself.
     */
    public NodeStateCounts withLeavingNodeCount(int leavingNodeCount) {
        this.leavingNodeCount = leavingNodeCount;
        return this;
    }

}
