/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Performance counters reporting settings.
 */
public class PerformanceCountersSettings {
    /**
     * Specifies Azure Application Insights information for performance
     * counters reporting.
     * If provided, Batch AI will upload node performance counters to the
     * corresponding Azure Application Insights account.
     */
    @JsonProperty(value = "appInsightsReference", required = true)
    private AppInsightsReference appInsightsReference;

    /**
     * Get the appInsightsReference value.
     *
     * @return the appInsightsReference value
     */
    public AppInsightsReference appInsightsReference() {
        return this.appInsightsReference;
    }

    /**
     * Set the appInsightsReference value.
     *
     * @param appInsightsReference the appInsightsReference value to set
     * @return the PerformanceCountersSettings object itself.
     */
    public PerformanceCountersSettings withAppInsightsReference(AppInsightsReference appInsightsReference) {
        this.appInsightsReference = appInsightsReference;
        return this;
    }

}
