/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Jobs.
 */
public class JobsInner implements InnerSupportsGet<JobInner>, InnerSupportsDelete<Void>, InnerSupportsListing<JobInner> {
    /** The Retrofit service to perform REST calls. */
    private JobsService service;
    /** The service client containing this operation class. */
    private BatchAIManagementClientImpl client;

    /**
     * Initializes an instance of JobsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public JobsInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = retrofit.create(JobsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Jobs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface JobsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Body JobCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Body JobCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformation" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/listRemoteLoginInformation")
        Observable<Response<ResponseBody>> listRemoteLoginInformation(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs terminate" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/terminate")
        Observable<Response<ResponseBody>> terminate(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginTerminate" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/terminate")
        Observable<Response<ResponseBody>> beginTerminate(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/jobs")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Query("$filter") String filter, @Query("$select") String select, @Query("maxresults") Integer maxResults, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Query("$filter") String filter, @Query("$select") String select, @Query("maxresults") Integer maxResults, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFiles" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/listOutputFiles")
        Observable<Response<ResponseBody>> listOutputFiles(@Path("resourceGroupName") String resourceGroupName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Query("outputdirectoryid") String outputdirectoryid, @Query("directory") String directory, @Query("linkexpiryinminutes") Integer linkexpiryinminutes, @Query("maxresults") Integer maxResults, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformationNext" })
        @GET
        Observable<Response<ResponseBody>> listRemoteLoginInformationNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFilesNext" })
        @GET
        Observable<Response<ResponseBody>> listOutputFilesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInner object if successful.
     */
    public JobInner create(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, jobName, parameters).toBlocking().last().body();
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInner> createAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters, final ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, jobName, parameters), serviceCallback);
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<JobInner> createAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, jobName, parameters).map(new Func1<ServiceResponse<JobInner>, JobInner>() {
            @Override
            public JobInner call(ServiceResponse<JobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<JobInner>> createWithServiceResponseAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInner>() { }.getType());
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInner object if successful.
     */
    public JobInner beginCreate(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, jobName, parameters).toBlocking().single().body();
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInner> beginCreateAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters, final ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, jobName, parameters), serviceCallback);
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<JobInner> beginCreateAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, jobName, parameters).map(new Func1<ServiceResponse<JobInner>, JobInner>() {
            @Override
            public JobInner call(ServiceResponse<JobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Adds a Job that gets executed on a cluster.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<ServiceResponse<JobInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreate(resourceGroupName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>() {
                @Override
                public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String jobName) {
        deleteWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().last().body();
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String jobName) {
        return deleteWithServiceResponseAsync(resourceGroupName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String jobName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().single().body();
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String jobName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInner object if successful.
     */
    public JobInner getByResourceGroup(String resourceGroupName, String jobName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().single().body();
    }

    /**
     * Gets information about the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInner> getByResourceGroupAsync(String resourceGroupName, String jobName, final ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    /**
     * Gets information about the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<JobInner> getByResourceGroupAsync(String resourceGroupName, String jobName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, jobName).map(new Func1<ServiceResponse<JobInner>, JobInner>() {
            @Override
            public JobInner call(ServiceResponse<JobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about the specified Batch AI job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<ServiceResponse<JobInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>() {
                @Override
                public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object if successful.
     */
    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformation(final String resourceGroupName, final String jobName) {
        ServiceResponse<Page<RemoteLoginInformationInner>> response = listRemoteLoginInformationSinglePageAsync(resourceGroupName, jobName).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>(response.body()) {
            @Override
            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(final String resourceGroupName, final String jobName, final ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listRemoteLoginInformationSinglePageAsync(resourceGroupName, jobName),
            new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                    return listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(final String resourceGroupName, final String jobName) {
        return listRemoteLoginInformationWithServiceResponseAsync(resourceGroupName, jobName)
            .map(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>() {
                @Override
                public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationWithServiceResponseAsync(final String resourceGroupName, final String jobName) {
        return listRemoteLoginInformationSinglePageAsync(resourceGroupName, jobName)
            .concatMap(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationSinglePageAsync(final String resourceGroupName, final String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listRemoteLoginInformation(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RemoteLoginInformationInner>> result = listRemoteLoginInformationDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RemoteLoginInformationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RemoteLoginInformationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void terminate(String resourceGroupName, String jobName) {
        terminateWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().last().body();
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> terminateAsync(String resourceGroupName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(terminateWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> terminateAsync(String resourceGroupName, String jobName) {
        return terminateWithServiceResponseAsync(resourceGroupName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> terminateWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.terminate(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginTerminate(String resourceGroupName, String jobName) {
        beginTerminateWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().single().body();
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginTerminateAsync(String resourceGroupName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginTerminateWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginTerminateAsync(String resourceGroupName, String jobName) {
        return beginTerminateWithServiceResponseAsync(resourceGroupName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginTerminateWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginTerminate(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginTerminateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginTerminateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> list() {
        ServiceResponse<Page<JobInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listAsync(final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final JobsListOptionsInner jobsListOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param jobsListOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> list(final JobsListOptionsInner jobsListOptions) {
        ServiceResponse<Page<JobInner>> response = listSinglePageAsync(jobsListOptions).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param jobsListOptions Additional parameters for the operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listAsync(final JobsListOptionsInner jobsListOptions, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(jobsListOptions),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param jobsListOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listAsync(final JobsListOptionsInner jobsListOptions) {
        return listWithServiceResponseAsync(jobsListOptions)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param jobsListOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listWithServiceResponseAsync(final JobsListOptionsInner jobsListOptions) {
        return listSinglePageAsync(jobsListOptions)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
    ServiceResponse<PageImpl<JobInner>> * @param jobsListOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listSinglePageAsync(final JobsListOptionsInner jobsListOptions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(jobsListOptions);
        String filter = null;
        if (jobsListOptions != null) {
            filter = jobsListOptions.filter();
        }
        String select = null;
        if (jobsListOptions != null) {
            select = jobsListOptions.select();
        }
        Integer maxResults = null;
        if (jobsListOptions != null) {
            maxResults = jobsListOptions.maxResults();
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<JobInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobsListByResourceGroupOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listByResourceGroup(final String resourceGroupName, final JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        ServiceResponse<Page<JobInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, jobsListByResourceGroupOptions).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobsListByResourceGroupOptions Additional parameters for the operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listByResourceGroupAsync(final String resourceGroupName, final JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, jobsListByResourceGroupOptions),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobsListByResourceGroupOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listByResourceGroupAsync(final String resourceGroupName, final JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, jobsListByResourceGroupOptions)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobsListByResourceGroupOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, jobsListByResourceGroupOptions)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
    ServiceResponse<PageImpl<JobInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<JobInner>> * @param jobsListByResourceGroupOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(jobsListByResourceGroupOptions);
        String filter = null;
        if (jobsListByResourceGroupOptions != null) {
            filter = jobsListByResourceGroupOptions.filter();
        }
        String select = null;
        if (jobsListByResourceGroupOptions != null) {
            select = jobsListByResourceGroupOptions.select();
        }
        Integer maxResults = null;
        if (jobsListByResourceGroupOptions != null) {
            maxResults = jobsListByResourceGroupOptions.maxResults();
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FileInner&gt; object if successful.
     */
    public PagedList<FileInner> listOutputFiles(final String resourceGroupName, final String jobName, final JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        ServiceResponse<Page<FileInner>> response = listOutputFilesSinglePageAsync(resourceGroupName, jobName, jobsListOutputFilesOptions).toBlocking().single();
        return new PagedList<FileInner>(response.body()) {
            @Override
            public Page<FileInner> nextPage(String nextPageLink) {
                return listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FileInner>> listOutputFilesAsync(final String resourceGroupName, final String jobName, final JobsListOutputFilesOptionsInner jobsListOutputFilesOptions, final ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listOutputFilesSinglePageAsync(resourceGroupName, jobName, jobsListOutputFilesOptions),
            new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                    return listOutputFilesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<Page<FileInner>> listOutputFilesAsync(final String resourceGroupName, final String jobName, final JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        return listOutputFilesWithServiceResponseAsync(resourceGroupName, jobName, jobsListOutputFilesOptions)
            .map(new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>() {
                @Override
                public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesWithServiceResponseAsync(final String resourceGroupName, final String jobName, final JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        return listOutputFilesSinglePageAsync(resourceGroupName, jobName, jobsListOutputFilesOptions)
            .concatMap(new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listOutputFilesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
    ServiceResponse<PageImpl<FileInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<FileInner>> * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<FileInner>> * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FileInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesSinglePageAsync(final String resourceGroupName, final String jobName, final JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (jobsListOutputFilesOptions == null) {
            throw new IllegalArgumentException("Parameter jobsListOutputFilesOptions is required and cannot be null.");
        }
        Validator.validate(jobsListOutputFilesOptions);
        String outputdirectoryid = jobsListOutputFilesOptions.outputdirectoryid();
        String directory = jobsListOutputFilesOptions.directory();
        Integer linkexpiryinminutes = jobsListOutputFilesOptions.linkexpiryinminutes();
        Integer maxResults = jobsListOutputFilesOptions.maxResults();
        return service.listOutputFiles(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), outputdirectoryid, directory, linkexpiryinminutes, maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FileInner>> result = listOutputFilesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FileInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FileInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FileInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object if successful.
     */
    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformationNext(final String nextPageLink) {
        ServiceResponse<Page<RemoteLoginInformationInner>> response = listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>(response.body()) {
            @Override
            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(final String nextPageLink, final ServiceFuture<List<RemoteLoginInformationInner>> serviceFuture, final ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listRemoteLoginInformationNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                    return listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(final String nextPageLink) {
        return listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>() {
                @Override
                public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextWithServiceResponseAsync(final String nextPageLink) {
        return listRemoteLoginInformationNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the IP address and port information of all the compute nodes which are used for job execution.
     *
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listRemoteLoginInformationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RemoteLoginInformationInner>> result = listRemoteLoginInformationNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RemoteLoginInformationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RemoteLoginInformationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<JobInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<JobInner>> serviceFuture, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the jobs associated with the subscription.
     *
    ServiceResponse<PageImpl<JobInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<JobInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<JobInner>> serviceFuture, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the Batch AI jobs associated within the specified resource group.
     *
    ServiceResponse<PageImpl<JobInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FileInner&gt; object if successful.
     */
    public PagedList<FileInner> listOutputFilesNext(final String nextPageLink) {
        ServiceResponse<Page<FileInner>> response = listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileInner>(response.body()) {
            @Override
            public Page<FileInner> nextPage(String nextPageLink) {
                return listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FileInner>> listOutputFilesNextAsync(final String nextPageLink, final ServiceFuture<List<FileInner>> serviceFuture, final ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listOutputFilesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                    return listOutputFilesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<Page<FileInner>> listOutputFilesNextAsync(final String nextPageLink) {
        return listOutputFilesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>() {
                @Override
                public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextWithServiceResponseAsync(final String nextPageLink) {
        return listOutputFilesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listOutputFilesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the output directory (Only if the output directory is on Azure File Share or Azure Storage container).
     *
    ServiceResponse<PageImpl<FileInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FileInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listOutputFilesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FileInner>> result = listOutputFilesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FileInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FileInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FileInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
