/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.RegistryTask;
import com.microsoft.azure.management.containerregistry.RegistryTasks;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryTaskImpl;
import com.microsoft.azure.management.containerregistry.implementation.TaskInner;
import com.microsoft.azure.management.containerregistry.implementation.TasksInner;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class RegistryTasksImpl
implements RegistryTasks {
    private final ContainerRegistryManager registryManager;

    RegistryTasksImpl(ContainerRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    public RegistryTask.DefinitionStages.Blank define(String name) {
        return new RegistryTaskImpl(this.registryManager, name);
    }

    @Override
    public Observable<RegistryTask> listByRegistryAsync(String resourceGroupName, String registryName) {
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).tasks().listAsync(resourceGroupName, registryName).flatMapIterable((Func1)new Func1<Page<TaskInner>, Iterable<TaskInner>>(){

            public Iterable<TaskInner> call(Page<TaskInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<TaskInner, RegistryTask>(){

            public RegistryTask call(TaskInner inner) {
                return RegistryTasksImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public PagedList<RegistryTask> listByRegistry(String resourceGroupName, String registryName) {
        RegistryTasksImpl self = this;
        return new PagedListConverter<TaskInner, RegistryTask>(){

            public Observable<RegistryTask> typeConvertAsync(TaskInner inner) {
                return Observable.just((Object)RegistryTasksImpl.this.wrapModel(inner));
            }
        }.convert(self.inner().list(resourceGroupName, registryName));
    }

    @Override
    public Observable<RegistryTask> getByRegistryAsync(String resourceGroupName, String registryName, String taskName, boolean includeSecrets) {
        if (includeSecrets) {
            return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).tasks().getDetailsAsync(resourceGroupName, registryName, taskName).map((Func1)new Func1<TaskInner, RegistryTask>(){

                public RegistryTask call(TaskInner taskInner) {
                    return new RegistryTaskImpl(RegistryTasksImpl.this.registryManager, taskInner);
                }
            });
        }
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).tasks().getAsync(resourceGroupName, registryName, taskName).map((Func1)new Func1<TaskInner, RegistryTask>(){

            public RegistryTask call(TaskInner taskInner) {
                return new RegistryTaskImpl(RegistryTasksImpl.this.registryManager, taskInner);
            }
        });
    }

    @Override
    public RegistryTask getByRegistry(String resourceGroupName, String registryName, String taskName, boolean includeSecrets) {
        return (RegistryTask)this.getByRegistryAsync(resourceGroupName, registryName, taskName, includeSecrets).toBlocking().last();
    }

    @Override
    public Completable deleteByRegistryAsync(String resourceGroupName, String registryName, String taskName) {
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).tasks().deleteAsync(resourceGroupName, registryName, taskName).toCompletable();
    }

    @Override
    public void deleteByRegistry(String resourceGroupName, String registryName, String taskName) {
        this.deleteByRegistryAsync(resourceGroupName, registryName, taskName).await();
    }

    private RegistryTaskImpl wrapModel(TaskInner innerModel) {
        return new RegistryTaskImpl(this.registryManager, innerModel);
    }

    public TasksInner inner() {
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).tasks();
    }
}

