/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.ContainerService;
import com.microsoft.azure.management.containerservice.ContainerServiceAgentPool;
import com.microsoft.azure.management.containerservice.ContainerServiceAgentPoolProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceStorageProfileTypes;
import com.microsoft.azure.management.containerservice.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.containerservice.OSType;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.List;

@LangDefinition
class ContainerServiceAgentPoolImpl
extends ChildResourceImpl<ContainerServiceAgentPoolProfile, ContainerServiceImpl, OrchestratorServiceBase>
implements ContainerServiceAgentPool,
ContainerServiceAgentPool.Definition {
    private String subnetName;

    ContainerServiceAgentPoolImpl(ContainerServiceAgentPoolProfile inner, ContainerServiceImpl parent) {
        super((Object)inner, (Object)parent);
        String subnetId = inner != null ? ((ContainerServiceAgentPoolProfile)this.inner()).vnetSubnetID() : null;
        this.subnetName = ResourceUtils.nameFromResourceId((String)subnetId);
    }

    public String name() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).name();
    }

    @Override
    public int count() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).count();
    }

    @Override
    public ContainerServiceVMSizeTypes vmSize() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).vmSize();
    }

    @Override
    public String dnsPrefix() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).dnsPrefix();
    }

    @Override
    public int osDiskSizeInGB() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).osDiskSizeGB();
    }

    @Override
    public int[] ports() {
        List<Integer> portsList = ((ContainerServiceAgentPoolProfile)this.inner()).ports();
        if (portsList != null && portsList.size() > 0) {
            int[] ports = new int[portsList.size()];
            for (int i = 0; i < ports.length; ++i) {
                ports[i] = portsList.get(i);
            }
            return ports;
        }
        return new int[0];
    }

    @Override
    public OSType osType() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).osType();
    }

    @Override
    public ContainerServiceStorageProfileTypes storageProfile() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).storageProfile();
    }

    @Override
    public String subnetName() {
        if (this.subnetName != null) {
            return this.subnetName;
        }
        return ResourceUtils.nameFromResourceId((String)((ContainerServiceAgentPoolProfile)this.inner()).vnetSubnetID());
    }

    @Override
    public String networkId() {
        String subnetId = this.inner() != null ? ((ContainerServiceAgentPoolProfile)this.inner()).vnetSubnetID() : null;
        return subnetId != null ? ResourceUtils.parentResourceIdFromResourceId((String)subnetId) : null;
    }

    @Override
    public String fqdn() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).fqdn();
    }

    public ContainerServiceAgentPoolImpl withVirtualMachineCount(int agentPoolCount) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withCount(agentPoolCount);
        return this;
    }

    public ContainerServiceAgentPoolImpl withVirtualMachineSize(ContainerServiceVMSizeTypes param0) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withVmSize(param0);
        return this;
    }

    public ContainerServiceAgentPoolImpl withDnsPrefix(String param0) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withDnsPrefix(param0);
        return this;
    }

    public ContainerServiceAgentPoolImpl withPorts(int ... ports) {
        if (ports != null && ports.length > 0) {
            ((ContainerServiceAgentPoolProfile)this.inner()).withPorts(new ArrayList<Integer>());
            for (int port : ports) {
                ((ContainerServiceAgentPoolProfile)this.inner()).ports().add(port);
            }
        }
        return this;
    }

    public ContainerServiceAgentPoolImpl withOSType(OSType osType) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withOsType(osType);
        return this;
    }

    public ContainerServiceAgentPoolImpl withOSDiskSizeInGB(int osDiskSizeInGB) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withOsDiskSizeGB(osDiskSizeInGB);
        return this;
    }

    public ContainerServiceAgentPoolImpl withStorageProfile(ContainerServiceStorageProfileTypes storageProfile) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withStorageProfile(storageProfile);
        return this;
    }

    public ContainerServiceAgentPoolImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        String vnetSubnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.subnetName = subnetName;
        ((ContainerServiceAgentPoolProfile)this.inner()).withVnetSubnetID(vnetSubnetId);
        return this;
    }

    public ContainerService.Definition attach() {
        ((ContainerServiceInner)((Object)((ContainerServiceImpl)this.parent()).inner())).agentPoolProfiles().add((ContainerServiceAgentPoolProfile)this.inner());
        return (ContainerService.Definition)this.parent();
    }
}

