/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerservice.TagsObject;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.OpenShiftManagedClusterInner;
import com.microsoft.azure.management.containerservice.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class OpenShiftManagedClustersInner
implements InnerSupportsGet<OpenShiftManagedClusterInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<OpenShiftManagedClusterInner> {
    private OpenShiftManagedClustersService service;
    private ContainerServiceManagementClientImpl client;

    public OpenShiftManagedClustersInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (OpenShiftManagedClustersService)retrofit.create(OpenShiftManagedClustersService.class);
        this.client = client;
    }

    public PagedList<OpenShiftManagedClusterInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>((Page)response.body()){

            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OpenShiftManagedClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OpenShiftManagedClusterInner>> listAsync(ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                return OpenShiftManagedClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OpenShiftManagedClusterInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>(){

            public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OpenShiftManagedClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        return this.service.list(this.client.subscriptionId(), "2019-04-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OpenShiftManagedClustersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<OpenShiftManagedClusterInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>((Page)response.body()){

            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OpenShiftManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OpenShiftManagedClusterInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                return OpenShiftManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OpenShiftManagedClusterInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>(){

            public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OpenShiftManagedClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-04-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OpenShiftManagedClustersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OpenShiftManagedClusterInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>(){

            public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OpenShiftManagedClustersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OpenShiftManagedClusterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OpenShiftManagedClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OpenShiftManagedClusterInner createOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-04-30";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OpenShiftManagedClusterInner>(){}.getType());
    }

    public OpenShiftManagedClusterInner beginCreateOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-04-30";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>(){

            public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OpenShiftManagedClustersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OpenShiftManagedClusterInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OpenShiftManagedClusterInner>(){}.getType()).register(201, new TypeToken<OpenShiftManagedClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OpenShiftManagedClusterInner updateTags(String resourceGroupName, String resourceName) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OpenShiftManagedClusterInner>(){}.getType());
    }

    public OpenShiftManagedClusterInner updateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-04-30";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OpenShiftManagedClusterInner>(){}.getType());
    }

    public OpenShiftManagedClusterInner beginUpdateTags(String resourceGroupName, String resourceName) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>(){

            public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OpenShiftManagedClustersInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public OpenShiftManagedClusterInner beginUpdateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return (OpenShiftManagedClusterInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    public Observable<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map((Func1)new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>(){

            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return (OpenShiftManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-04-30";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>(){

            public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OpenShiftManagedClustersInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OpenShiftManagedClusterInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OpenShiftManagedClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2019-04-30";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, resourceName, "2019-04-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OpenShiftManagedClustersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<OpenShiftManagedClusterInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>((Page)response.body()){

            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OpenShiftManagedClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OpenShiftManagedClusterInner>> listNextAsync(String nextPageLink, ServiceFuture<List<OpenShiftManagedClusterInner>> serviceFuture, ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                return OpenShiftManagedClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OpenShiftManagedClusterInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>(){

            public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OpenShiftManagedClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OpenShiftManagedClustersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<OpenShiftManagedClusterInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>((Page)response.body()){

            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OpenShiftManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OpenShiftManagedClusterInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<OpenShiftManagedClusterInner>> serviceFuture, ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                return OpenShiftManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OpenShiftManagedClusterInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>(){

            public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OpenShiftManagedClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OpenShiftManagedClustersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface OpenShiftManagedClustersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/openShiftManagedClusters")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body OpenShiftManagedClusterInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body OpenShiftManagedClusterInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

