/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The password profile associated with a user.
 */
public class PasswordProfile {
    /**
     * Unmatched properties from the message are deserialized this collection.
     */
    @JsonProperty(value = "")
    private Map<String, Object> additionalProperties;

    /**
     * Password.
     */
    @JsonProperty(value = "password", required = true)
    private String password;

    /**
     * Whether to force a password change on next login.
     */
    @JsonProperty(value = "forceChangePasswordNextLogin")
    private Boolean forceChangePasswordNextLogin;

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set
     * @return the PasswordProfile object itself.
     */
    public PasswordProfile withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Get the password value.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password value.
     *
     * @param password the password value to set
     * @return the PasswordProfile object itself.
     */
    public PasswordProfile withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the forceChangePasswordNextLogin value.
     *
     * @return the forceChangePasswordNextLogin value
     */
    public Boolean forceChangePasswordNextLogin() {
        return this.forceChangePasswordNextLogin;
    }

    /**
     * Set the forceChangePasswordNextLogin value.
     *
     * @param forceChangePasswordNextLogin the forceChangePasswordNextLogin value to set
     * @return the PasswordProfile object itself.
     */
    public PasswordProfile withForceChangePasswordNextLogin(Boolean forceChangePasswordNextLogin) {
        this.forceChangePasswordNextLogin = forceChangePasswordNextLogin;
        return this;
    }

}
