/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RoleAssignments.
 */
public class RoleAssignmentsInner implements InnerSupportsDelete<RoleAssignmentInner>, InnerSupportsListing<RoleAssignmentInner> {
    /** The Retrofit service to perform REST calls. */
    private RoleAssignmentsService service;
    /** The service client containing this operation class. */
    private AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of RoleAssignmentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RoleAssignmentsInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = retrofit.create(RoleAssignmentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RoleAssignments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RoleAssignmentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResource" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> listForResource(@Path("resourceGroupName") String resourceGroupName, @Path("resourceProviderNamespace") String resourceProviderNamespace, @Path(value = "parentResourcePath", encoded = true) String parentResourcePath, @Path(value = "resourceType", encoded = true) String resourceType, @Path("resourceName") String resourceName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments delete" })
        @HTTP(path = "{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "scope", encoded = true) String scope, @Path("roleAssignmentName") String roleAssignmentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments create" })
        @PUT("{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        Observable<Response<ResponseBody>> create(@Path(value = "scope", encoded = true) String scope, @Path("roleAssignmentName") String roleAssignmentName, @Body RoleAssignmentCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments get" })
        @GET("{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        Observable<Response<ResponseBody>> get(@Path(value = "scope", encoded = true) String scope, @Path("roleAssignmentName") String roleAssignmentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments deleteById" })
        @HTTP(path = "{roleId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteById(@Path(value = "roleId", encoded = true) String roleId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments createById" })
        @PUT("{roleId}")
        Observable<Response<ResponseBody>> createById(@Path(value = "roleId", encoded = true) String roleId, @Body RoleAssignmentCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments getById" })
        @GET("{roleId}")
        Observable<Response<ResponseBody>> getById(@Path(value = "roleId", encoded = true) String roleId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForScope" })
        @GET("{scope}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> listForScope(@Path(value = "scope", encoded = true) String scope, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResourceNext" })
        @GET
        Observable<Response<ResponseBody>> listForResourceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForScopeNext" })
        @GET
        Observable<Response<ResponseBody>> listForScopeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResource(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        return listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceWithServiceResponseAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        return listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceSinglePageAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        final String filter = null;
        return service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResource(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        return listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceWithServiceResponseAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        return listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceProviderNamespace The namespace of the resource provider.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param parentResourcePath The parent resource identity.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceType The resource type of the resource.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceName The name of the resource to get role assignments for.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceSinglePageAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        final String filter = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listByResourceGroup(final String resourceGroupName, final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listByResourceGroupAsync(final String resourceGroupName, final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listByResourceGroupAsync(final String resourceGroupName, final String filter) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final String filter) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner delete(String scope, String roleAssignmentName) {
        return deleteWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single().body();
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName) {
        return deleteWithServiceResponseAsync(scope, roleAssignmentName).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> deleteWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.delete(scope, roleAssignmentName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner create(String scope, String roleAssignmentName, RoleAssignmentCreateParametersInner parameters) {
        return createWithServiceResponseAsync(scope, roleAssignmentName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParametersInner parameters, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(scope, roleAssignmentName, parameters), serviceCallback);
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParametersInner parameters) {
        return createWithServiceResponseAsync(scope, roleAssignmentName, parameters).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> createWithServiceResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParametersInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-01-01-preview";
        return service.create(scope, roleAssignmentName, parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner get(String scope, String roleAssignmentName) {
        return getWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single().body();
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName) {
        return getWithServiceResponseAsync(scope, roleAssignmentName).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> getWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.get(scope, roleAssignmentName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner deleteById(String roleId) {
        return deleteByIdWithServiceResponseAsync(roleId).toBlocking().single().body();
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> deleteByIdAsync(String roleId, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteByIdWithServiceResponseAsync(roleId), serviceCallback);
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> deleteByIdAsync(String roleId) {
        return deleteByIdWithServiceResponseAsync(roleId).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> deleteByIdWithServiceResponseAsync(String roleId) {
        if (roleId == null) {
            throw new IllegalArgumentException("Parameter roleId is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.deleteById(roleId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = deleteByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> deleteByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner createById(String roleId, RoleAssignmentCreateParametersInner parameters) {
        return createByIdWithServiceResponseAsync(roleId, parameters).toBlocking().single().body();
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Parameters for the role assignment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> createByIdAsync(String roleId, RoleAssignmentCreateParametersInner parameters, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createByIdWithServiceResponseAsync(roleId, parameters), serviceCallback);
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> createByIdAsync(String roleId, RoleAssignmentCreateParametersInner parameters) {
        return createByIdWithServiceResponseAsync(roleId, parameters).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> createByIdWithServiceResponseAsync(String roleId, RoleAssignmentCreateParametersInner parameters) {
        if (roleId == null) {
            throw new IllegalArgumentException("Parameter roleId is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-01-01-preview";
        return service.createById(roleId, parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = createByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> createByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner getById(String roleId) {
        return getByIdWithServiceResponseAsync(roleId).toBlocking().single().body();
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> getByIdAsync(String roleId, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByIdWithServiceResponseAsync(roleId), serviceCallback);
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> getByIdAsync(String roleId) {
        return getByIdWithServiceResponseAsync(roleId).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> getByIdWithServiceResponseAsync(String roleId) {
        if (roleId == null) {
            throw new IllegalArgumentException("Parameter roleId is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.getById(roleId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = getByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> getByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> list() {
        ServiceResponse<Page<RoleAssignmentInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listAsync(final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        final String filter = null;
        return service.list(this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> list(final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listAsync(final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listSinglePageAsync(final String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.list(this.client.subscriptionId(), filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForScope(final String scope) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForScopeSinglePageAsync(scope).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForScopeAsync(final String scope, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForScopeSinglePageAsync(scope),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForScopeAsync(final String scope) {
        return listForScopeWithServiceResponseAsync(scope)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeWithServiceResponseAsync(final String scope) {
        return listForScopeSinglePageAsync(scope)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeSinglePageAsync(final String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        final String filter = null;
        return service.listForScope(scope, filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForScope(final String scope, final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForScopeSinglePageAsync(scope, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForScopeAsync(final String scope, final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForScopeSinglePageAsync(scope, filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForScopeAsync(final String scope, final String filter) {
        return listForScopeWithServiceResponseAsync(scope, filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeWithServiceResponseAsync(final String scope, final String filter) {
        return listForScopeSinglePageAsync(scope, filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param scope The scope of the role assignments.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeSinglePageAsync(final String scope, final String filter) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        final String apiVersion = "2018-01-01-preview";
        return service.listForScope(scope, filter, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResourceNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceNextAsync(final String nextPageLink) {
        return listForResourceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceNextWithServiceResponseAsync(final String nextPageLink) {
        return listForResourceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listForResourceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForScopeNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForScopeNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForScopeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForScopeNextAsync(final String nextPageLink) {
        return listForScopeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeNextWithServiceResponseAsync(final String nextPageLink) {
        return listForScopeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listForScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForScopeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
