/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Azure Automation Runbook notification receiver.
 */
public class AutomationRunbookReceiver {
    /**
     * The Azure automation account Id which holds this runbook and
     * authenticate to Azure resource.
     */
    @JsonProperty(value = "automationAccountId", required = true)
    private String automationAccountId;

    /**
     * The name for this runbook.
     */
    @JsonProperty(value = "runbookName", required = true)
    private String runbookName;

    /**
     * The resource id for webhook linked to this runbook.
     */
    @JsonProperty(value = "webhookResourceId", required = true)
    private String webhookResourceId;

    /**
     * Indicates whether this instance is global runbook.
     */
    @JsonProperty(value = "isGlobalRunbook", required = true)
    private boolean isGlobalRunbook;

    /**
     * Indicates name of the webhook.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * The URI where webhooks should be sent.
     */
    @JsonProperty(value = "serviceUri")
    private String serviceUri;

    /**
     * Get the automationAccountId value.
     *
     * @return the automationAccountId value
     */
    public String automationAccountId() {
        return this.automationAccountId;
    }

    /**
     * Set the automationAccountId value.
     *
     * @param automationAccountId the automationAccountId value to set
     * @return the AutomationRunbookReceiver object itself.
     */
    public AutomationRunbookReceiver withAutomationAccountId(String automationAccountId) {
        this.automationAccountId = automationAccountId;
        return this;
    }

    /**
     * Get the runbookName value.
     *
     * @return the runbookName value
     */
    public String runbookName() {
        return this.runbookName;
    }

    /**
     * Set the runbookName value.
     *
     * @param runbookName the runbookName value to set
     * @return the AutomationRunbookReceiver object itself.
     */
    public AutomationRunbookReceiver withRunbookName(String runbookName) {
        this.runbookName = runbookName;
        return this;
    }

    /**
     * Get the webhookResourceId value.
     *
     * @return the webhookResourceId value
     */
    public String webhookResourceId() {
        return this.webhookResourceId;
    }

    /**
     * Set the webhookResourceId value.
     *
     * @param webhookResourceId the webhookResourceId value to set
     * @return the AutomationRunbookReceiver object itself.
     */
    public AutomationRunbookReceiver withWebhookResourceId(String webhookResourceId) {
        this.webhookResourceId = webhookResourceId;
        return this;
    }

    /**
     * Get the isGlobalRunbook value.
     *
     * @return the isGlobalRunbook value
     */
    public boolean isGlobalRunbook() {
        return this.isGlobalRunbook;
    }

    /**
     * Set the isGlobalRunbook value.
     *
     * @param isGlobalRunbook the isGlobalRunbook value to set
     * @return the AutomationRunbookReceiver object itself.
     */
    public AutomationRunbookReceiver withIsGlobalRunbook(boolean isGlobalRunbook) {
        this.isGlobalRunbook = isGlobalRunbook;
        return this;
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the AutomationRunbookReceiver object itself.
     */
    public AutomationRunbookReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the serviceUri value.
     *
     * @return the serviceUri value
     */
    public String serviceUri() {
        return this.serviceUri;
    }

    /**
     * Set the serviceUri value.
     *
     * @param serviceUri the serviceUri value to set
     * @return the AutomationRunbookReceiver object itself.
     */
    public AutomationRunbookReceiver withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

}
