/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.DynamicMetricCriteria;
import com.microsoft.azure.management.monitor.MetricAlert;
import com.microsoft.azure.management.monitor.MetricAlertAction;
import com.microsoft.azure.management.monitor.MetricAlertCondition;
import com.microsoft.azure.management.monitor.MetricAlertMultipleResourceMultipleMetricCriteria;
import com.microsoft.azure.management.monitor.MetricAlertSingleResourceMultipleMetricCriteria;
import com.microsoft.azure.management.monitor.MetricCriteria;
import com.microsoft.azure.management.monitor.MetricDynamicAlertCondition;
import com.microsoft.azure.management.monitor.MultiMetricCriteria;
import com.microsoft.azure.management.monitor.implementation.MetricAlertConditionImpl;
import com.microsoft.azure.management.monitor.implementation.MetricAlertResourceInner;
import com.microsoft.azure.management.monitor.implementation.MetricDynamicAlertConditionImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.Period;
import rx.Observable;

@LangDefinition
class MetricAlertImpl
extends GroupableResourceImpl<MetricAlert, MetricAlertResourceInner, MetricAlertImpl, MonitorManager>
implements MetricAlert,
MetricAlert.Definition,
MetricAlert.DefinitionMultipleResource,
MetricAlert.Update,
MetricAlert.UpdateStages.WithMetricUpdate {
    private Map<String, MetricAlertCondition> conditions;
    private Map<String, MetricDynamicAlertCondition> dynamicConditions;
    private boolean multipleResource;

    MetricAlertImpl(String name, MetricAlertResourceInner innerModel, MonitorManager monitorManager) {
        block5: {
            block6: {
                super(name, (Resource)innerModel, (ManagerBase)monitorManager);
                this.multipleResource = false;
                this.conditions = new TreeMap<String, MetricAlertCondition>();
                this.dynamicConditions = new TreeMap<String, MetricDynamicAlertCondition>();
                if (innerModel.criteria() == null) break block5;
                if (!(innerModel.criteria() instanceof MetricAlertSingleResourceMultipleMetricCriteria)) break block6;
                this.multipleResource = false;
                MetricAlertSingleResourceMultipleMetricCriteria crits = (MetricAlertSingleResourceMultipleMetricCriteria)innerModel.criteria();
                List<MetricCriteria> criteria = crits.allOf();
                if (criteria == null) break block5;
                for (MetricCriteria crit : criteria) {
                    this.conditions.put(crit.name(), new MetricAlertConditionImpl(crit.name(), crit, this));
                }
                break block5;
            }
            if (innerModel.criteria() instanceof MetricAlertMultipleResourceMultipleMetricCriteria) {
                this.multipleResource = true;
                MetricAlertMultipleResourceMultipleMetricCriteria crits = (MetricAlertMultipleResourceMultipleMetricCriteria)innerModel.criteria();
                List<MultiMetricCriteria> criteria = crits.allOf();
                if (criteria != null) {
                    for (MultiMetricCriteria crit : criteria) {
                        if (crit instanceof MetricCriteria) {
                            this.conditions.put(crit.name(), new MetricAlertConditionImpl(crit.name(), (MetricCriteria)crit, this));
                            continue;
                        }
                        if (!(crit instanceof DynamicMetricCriteria)) continue;
                        this.dynamicConditions.put(crit.name(), new MetricDynamicAlertConditionImpl(crit.name(), (DynamicMetricCriteria)crit, this));
                    }
                }
            }
        }
    }

    public Observable<MetricAlert> createResourceAsync() {
        if (this.conditions.isEmpty() && this.dynamicConditions.isEmpty()) {
            throw new IllegalArgumentException("Condition cannot be empty");
        }
        if (!this.conditions.isEmpty() && !this.dynamicConditions.isEmpty()) {
            throw new IllegalArgumentException("Static condition and dynamic condition cannot co-exist");
        }
        ((MetricAlertResourceInner)((Object)this.inner())).withLocation("global");
        if (!this.conditions.isEmpty()) {
            if (!this.multipleResource) {
                MetricAlertSingleResourceMultipleMetricCriteria crit = new MetricAlertSingleResourceMultipleMetricCriteria();
                crit.withAllOf(new ArrayList<MetricCriteria>());
                for (MetricAlertCondition mc : this.conditions.values()) {
                    crit.allOf().add((MetricCriteria)mc.inner());
                }
                ((MetricAlertResourceInner)((Object)this.inner())).withCriteria(crit);
            } else {
                MetricAlertMultipleResourceMultipleMetricCriteria crit = new MetricAlertMultipleResourceMultipleMetricCriteria();
                crit.withAllOf(new ArrayList<MultiMetricCriteria>());
                for (MetricAlertCondition mc : this.conditions.values()) {
                    crit.allOf().add((MultiMetricCriteria)mc.inner());
                }
                ((MetricAlertResourceInner)((Object)this.inner())).withCriteria(crit);
            }
        } else if (!this.dynamicConditions.isEmpty()) {
            MetricAlertMultipleResourceMultipleMetricCriteria crit = new MetricAlertMultipleResourceMultipleMetricCriteria();
            crit.withAllOf(new ArrayList<MultiMetricCriteria>());
            for (MetricDynamicAlertCondition mc : this.dynamicConditions.values()) {
                crit.allOf().add((MultiMetricCriteria)mc.inner());
            }
            ((MetricAlertResourceInner)((Object)this.inner())).withCriteria(crit);
        }
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).metricAlerts().createOrUpdateAsync(this.resourceGroupName(), this.name(), (MetricAlertResourceInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<MetricAlertResourceInner> getInnerAsync() {
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).metricAlerts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public MetricAlertImpl withTargetResource(String resourceId) {
        this.multipleResource = false;
        ((MetricAlertResourceInner)((Object)this.inner())).withScopes(new ArrayList<String>());
        ((MetricAlertResourceInner)((Object)this.inner())).scopes().add(resourceId);
        return this;
    }

    @Override
    public MetricAlertImpl withTargetResource(HasId resource) {
        this.multipleResource = false;
        return this.withTargetResource(resource.id());
    }

    @Override
    public MetricAlertImpl withPeriod(Period size) {
        ((MetricAlertResourceInner)((Object)this.inner())).withWindowSize(size);
        return this;
    }

    @Override
    public MetricAlertImpl withFrequency(Period frequency) {
        ((MetricAlertResourceInner)((Object)this.inner())).withEvaluationFrequency(frequency);
        return this;
    }

    @Override
    public MetricAlertImpl withSeverity(int severity) {
        ((MetricAlertResourceInner)((Object)this.inner())).withSeverity(severity);
        return this;
    }

    @Override
    public MetricAlertImpl withAlertDetails(int severity, String description) {
        this.withSeverity(severity);
        return this.withDescription(description);
    }

    @Override
    public MetricAlertImpl withDescription(String description) {
        ((MetricAlertResourceInner)((Object)this.inner())).withDescription(description);
        return this;
    }

    @Override
    public MetricAlertImpl withRuleEnabled() {
        ((MetricAlertResourceInner)((Object)this.inner())).withEnabled(true);
        return this;
    }

    @Override
    public MetricAlertImpl withRuleDisabled() {
        ((MetricAlertResourceInner)((Object)this.inner())).withEnabled(false);
        return this;
    }

    @Override
    public MetricAlertImpl withAutoMitigation() {
        ((MetricAlertResourceInner)((Object)this.inner())).withAutoMitigate(true);
        return this;
    }

    @Override
    public MetricAlertImpl withoutAutoMitigation() {
        ((MetricAlertResourceInner)((Object)this.inner())).withAutoMitigate(false);
        return this;
    }

    @Override
    public MetricAlertImpl withActionGroups(String ... actionGroupId) {
        if (((MetricAlertResourceInner)((Object)this.inner())).actions() == null) {
            ((MetricAlertResourceInner)((Object)this.inner())).withActions(new ArrayList<MetricAlertAction>());
        }
        ((MetricAlertResourceInner)((Object)this.inner())).actions().clear();
        for (String agid : actionGroupId) {
            MetricAlertAction maa = new MetricAlertAction();
            maa.withActionGroupId(agid);
            ((MetricAlertResourceInner)((Object)this.inner())).actions().add(maa);
        }
        return this;
    }

    @Override
    public MetricAlertImpl withoutActionGroup(String actionGroupId) {
        if (((MetricAlertResourceInner)((Object)this.inner())).actions() != null) {
            ArrayList<MetricAlertAction> toDelete = new ArrayList<MetricAlertAction>();
            for (MetricAlertAction maa : ((MetricAlertResourceInner)((Object)this.inner())).actions()) {
                if (!maa.actionGroupId().equalsIgnoreCase(actionGroupId)) continue;
                toDelete.add(maa);
            }
            ((MetricAlertResourceInner)((Object)this.inner())).actions().removeAll(toDelete);
        }
        return this;
    }

    public MetricAlertConditionImpl defineAlertCriteria(String name) {
        return new MetricAlertConditionImpl(name, new MetricCriteria(), this);
    }

    public MetricDynamicAlertConditionImpl defineDynamicAlertCriteria(String name) {
        return new MetricDynamicAlertConditionImpl(name, new DynamicMetricCriteria(), this);
    }

    @Override
    public MetricAlertConditionImpl updateAlertCriteria(String name) {
        return (MetricAlertConditionImpl)this.conditions.get(name);
    }

    @Override
    public MetricDynamicAlertConditionImpl updateDynamicAlertCriteria(String name) {
        return (MetricDynamicAlertConditionImpl)this.dynamicConditions.get(name);
    }

    @Override
    public MetricAlertImpl withoutAlertCriteria(String name) {
        if (this.conditions.containsKey(name)) {
            this.conditions.remove(name);
        }
        if (this.dynamicConditions.containsKey(name)) {
            this.dynamicConditions.remove(name);
        }
        return this;
    }

    MetricAlertImpl withAlertCriteria(MetricAlertConditionImpl criteria) {
        this.withoutAlertCriteria(criteria.name());
        this.conditions.put(criteria.name(), criteria);
        return this;
    }

    MetricAlertImpl withDynamicAlertCriteria(MetricDynamicAlertConditionImpl criteria) {
        this.withoutAlertCriteria(criteria.name());
        this.dynamicConditions.put(criteria.name(), criteria);
        return this;
    }

    @Override
    public MetricAlertImpl withMultipleTargetResources(Collection<String> resourceIds, String type, String region) {
        if (resourceIds == null || resourceIds.isEmpty()) {
            throw new IllegalArgumentException("Target resource cannot be empty");
        }
        this.multipleResource = true;
        ((MetricAlertResourceInner)((Object)this.inner())).withScopes(new ArrayList<String>(resourceIds));
        ((MetricAlertResourceInner)((Object)this.inner())).withTargetResourceType(type);
        ((MetricAlertResourceInner)((Object)this.inner())).withTargetResourceRegion(region);
        return this;
    }

    @Override
    public MetricAlertImpl withMultipleTargetResources(Collection<? extends com.microsoft.azure.management.resources.fluentcore.arm.models.Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            throw new IllegalArgumentException("Target resource cannot be empty");
        }
        this.multipleResource = true;
        ArrayList<String> resourceIds = new ArrayList<String>();
        String type = resources.iterator().next().type();
        String regionName = resources.iterator().next().regionName();
        for (com.microsoft.azure.management.resources.fluentcore.arm.models.Resource resource : resources) {
            if (!type.equalsIgnoreCase(resource.type()) || !regionName.equalsIgnoreCase(resource.regionName())) {
                throw new IllegalArgumentException("Target resource must be of the same resource type and in the same region");
            }
            resourceIds.add(resource.id());
        }
        return this.withMultipleTargetResources(resourceIds, type, regionName);
    }

    @Override
    public String description() {
        return ((MetricAlertResourceInner)((Object)this.inner())).description();
    }

    @Override
    public int severity() {
        return ((MetricAlertResourceInner)((Object)this.inner())).severity();
    }

    @Override
    public boolean enabled() {
        return ((MetricAlertResourceInner)((Object)this.inner())).enabled();
    }

    @Override
    public Period evaluationFrequency() {
        return ((MetricAlertResourceInner)((Object)this.inner())).evaluationFrequency();
    }

    @Override
    public Period windowSize() {
        return ((MetricAlertResourceInner)((Object)this.inner())).windowSize();
    }

    @Override
    public boolean autoMitigate() {
        return ((MetricAlertResourceInner)((Object)this.inner())).autoMitigate();
    }

    @Override
    public DateTime lastUpdatedTime() {
        return ((MetricAlertResourceInner)((Object)this.inner())).lastUpdatedTime();
    }

    @Override
    public Collection<String> scopes() {
        return Collections.unmodifiableCollection(((MetricAlertResourceInner)((Object)this.inner())).scopes());
    }

    @Override
    public Collection<String> actionGroupIds() {
        if (((MetricAlertResourceInner)((Object)this.inner())).actions() != null && ((MetricAlertResourceInner)((Object)this.inner())).actions() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (MetricAlertAction maag : ((MetricAlertResourceInner)((Object)this.inner())).actions()) {
                ids.add(maag.actionGroupId());
            }
            return Collections.unmodifiableCollection(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, MetricAlertCondition> alertCriterias() {
        return Collections.unmodifiableMap(this.conditions);
    }

    @Override
    public Map<String, MetricDynamicAlertCondition> dynamicAlertCriterias() {
        return Collections.unmodifiableMap(this.dynamicConditions);
    }
}

