/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for UnavailableReason.
 */
public final class UnavailableReason {
    /** Static value None for UnavailableReason. */
    public static final UnavailableReason NONE = new UnavailableReason("None");

    /** Static value InvalidName for UnavailableReason. */
    public static final UnavailableReason INVALID_NAME = new UnavailableReason("InvalidName");

    /** Static value SubscriptionIsDisabled for UnavailableReason. */
    public static final UnavailableReason SUBSCRIPTION_IS_DISABLED = new UnavailableReason("SubscriptionIsDisabled");

    /** Static value NameInUse for UnavailableReason. */
    public static final UnavailableReason NAME_IN_USE = new UnavailableReason("NameInUse");

    /** Static value NameInLockdown for UnavailableReason. */
    public static final UnavailableReason NAME_IN_LOCKDOWN = new UnavailableReason("NameInLockdown");

    /** Static value TooManyNamespaceInCurrentSubscription for UnavailableReason. */
    public static final UnavailableReason TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION = new UnavailableReason("TooManyNamespaceInCurrentSubscription");

    private String value;

    /**
     * Creates a custom value for UnavailableReason.
     * @param value the custom value
     */
    public UnavailableReason(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnavailableReason)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UnavailableReason rhs = (UnavailableReason) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
