/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.servicebus.AccessRights;
import com.microsoft.azure.management.servicebus.Policykey;
import com.microsoft.azure.management.servicebus.RegenerateKeysParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Queues.
 */
public class QueuesInner {
    /** The Retrofit service to perform REST calls. */
    private QueuesService service;
    /** The service client containing this operation class. */
    private ServiceBusManagementClientImpl client;

    /**
     * Initializes an instance of QueuesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public QueuesInner(Retrofit retrofit, ServiceBusManagementClientImpl client) {
        this.service = retrofit.create(QueuesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Queues to be
     * used by Retrofit to perform actually REST calls.
     */
    interface QueuesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues listByNamespace" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues")
        Observable<Response<ResponseBody>> listByNamespace(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("subscriptionId") String subscriptionId, @Body QueueInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues listAuthorizationRules" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules")
        Observable<Response<ResponseBody>> listAuthorizationRules(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues createOrUpdateAuthorizationRule" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}")
        Observable<Response<ResponseBody>> createOrUpdateAuthorizationRule(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SharedAccessAuthorizationRuleInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues deleteAuthorizationRule" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAuthorizationRule(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues getAuthorizationRule" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}")
        Observable<Response<ResponseBody>> getAuthorizationRule(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues listKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}/ListKeys")
        Observable<Response<ResponseBody>> listKeys(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues regenerateKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}/regenerateKeys")
        Observable<Response<ResponseBody>> regenerateKeys(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("queueName") String queueName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegenerateKeysParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues listByNamespaceNext" })
        @GET
        Observable<Response<ResponseBody>> listByNamespaceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Queues listAuthorizationRulesNext" })
        @GET
        Observable<Response<ResponseBody>> listAuthorizationRulesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;QueueInner&gt; object if successful.
     */
    public PagedList<QueueInner> listByNamespace(final String resourceGroupName, final String namespaceName) {
        ServiceResponse<Page<QueueInner>> response = listByNamespaceSinglePageAsync(resourceGroupName, namespaceName).toBlocking().single();
        return new PagedList<QueueInner>(response.body()) {
            @Override
            public Page<QueueInner> nextPage(String nextPageLink) {
                return listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<QueueInner>> listByNamespaceAsync(final String resourceGroupName, final String namespaceName, final ListOperationCallback<QueueInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByNamespaceSinglePageAsync(resourceGroupName, namespaceName),
            new Func1<String, Observable<ServiceResponse<Page<QueueInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<QueueInner>>> call(String nextPageLink) {
                    return listByNamespaceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;QueueInner&gt; object
     */
    public Observable<Page<QueueInner>> listByNamespaceAsync(final String resourceGroupName, final String namespaceName) {
        return listByNamespaceWithServiceResponseAsync(resourceGroupName, namespaceName)
            .map(new Func1<ServiceResponse<Page<QueueInner>>, Page<QueueInner>>() {
                @Override
                public Page<QueueInner> call(ServiceResponse<Page<QueueInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;QueueInner&gt; object
     */
    public Observable<ServiceResponse<Page<QueueInner>>> listByNamespaceWithServiceResponseAsync(final String resourceGroupName, final String namespaceName) {
        return listByNamespaceSinglePageAsync(resourceGroupName, namespaceName)
            .concatMap(new Func1<ServiceResponse<Page<QueueInner>>, Observable<ServiceResponse<Page<QueueInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<QueueInner>>> call(ServiceResponse<Page<QueueInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByNamespaceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the queues within a namespace.
     *
    ServiceResponse<PageImpl<QueueInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<QueueInner>> * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;QueueInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<QueueInner>>> listByNamespaceSinglePageAsync(final String resourceGroupName, final String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByNamespace(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<QueueInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<QueueInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<QueueInner>> result = listByNamespaceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<QueueInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<QueueInner>> listByNamespaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<QueueInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<QueueInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param parameters Parameters supplied to create or update a queue resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the QueueInner object if successful.
     */
    public QueueInner createOrUpdate(String resourceGroupName, String namespaceName, String queueName, QueueInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param parameters Parameters supplied to create or update a queue resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<QueueInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String queueName, QueueInner parameters, final ServiceCallback<QueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param parameters Parameters supplied to create or update a queue resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the QueueInner object
     */
    public Observable<QueueInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String queueName, QueueInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, parameters).map(new Func1<ServiceResponse<QueueInner>, QueueInner>() {
            @Override
            public QueueInner call(ServiceResponse<QueueInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param parameters Parameters supplied to create or update a queue resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the QueueInner object
     */
    public Observable<ServiceResponse<QueueInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, QueueInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdate(resourceGroupName, namespaceName, queueName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueueInner>>>() {
                @Override
                public Observable<ServiceResponse<QueueInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<QueueInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<QueueInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<QueueInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<QueueInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String namespaceName, String queueName) {
        deleteWithServiceResponseAsync(resourceGroupName, namespaceName, queueName).toBlocking().single().body();
    }

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String queueName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, namespaceName, queueName), serviceCallback);
    }

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String queueName) {
        return deleteWithServiceResponseAsync(resourceGroupName, namespaceName, queueName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, namespaceName, queueName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the QueueInner object if successful.
     */
    public QueueInner get(String resourceGroupName, String namespaceName, String queueName) {
        return getWithServiceResponseAsync(resourceGroupName, namespaceName, queueName).toBlocking().single().body();
    }

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<QueueInner> getAsync(String resourceGroupName, String namespaceName, String queueName, final ServiceCallback<QueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, namespaceName, queueName), serviceCallback);
    }

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the QueueInner object
     */
    public Observable<QueueInner> getAsync(String resourceGroupName, String namespaceName, String queueName) {
        return getWithServiceResponseAsync(resourceGroupName, namespaceName, queueName).map(new Func1<ServiceResponse<QueueInner>, QueueInner>() {
            @Override
            public QueueInner call(ServiceResponse<QueueInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the QueueInner object
     */
    public Observable<ServiceResponse<QueueInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, namespaceName, queueName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueueInner>>>() {
                @Override
                public Observable<ServiceResponse<QueueInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<QueueInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<QueueInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<QueueInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<QueueInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object if successful.
     */
    public PagedList<SharedAccessAuthorizationRuleInner> listAuthorizationRules(final String resourceGroupName, final String namespaceName, final String queueName) {
        ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response = listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, queueName).toBlocking().single();
        return new PagedList<SharedAccessAuthorizationRuleInner>(response.body()) {
            @Override
            public Page<SharedAccessAuthorizationRuleInner> nextPage(String nextPageLink) {
                return listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesAsync(final String resourceGroupName, final String namespaceName, final String queueName, final ListOperationCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, queueName),
            new Func1<String, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(String nextPageLink) {
                    return listAuthorizationRulesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<Page<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesAsync(final String resourceGroupName, final String namespaceName, final String queueName) {
        return listAuthorizationRulesWithServiceResponseAsync(resourceGroupName, namespaceName, queueName)
            .map(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Page<SharedAccessAuthorizationRuleInner>>() {
                @Override
                public Page<SharedAccessAuthorizationRuleInner> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesWithServiceResponseAsync(final String resourceGroupName, final String namespaceName, final String queueName) {
        return listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, queueName)
            .concatMap(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all authorization rules for a queue.
     *
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param namespaceName The namespace name
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesSinglePageAsync(final String resourceGroupName, final String namespaceName, final String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAuthorizationRules(resourceGroupName, namespaceName, queueName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> result = listAuthorizationRulesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SharedAccessAuthorizationRuleInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SharedAccessAuthorizationRuleInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SharedAccessAuthorizationRuleInner object if successful.
     */
    public SharedAccessAuthorizationRuleInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, List<AccessRights> rights) {
        return createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName, rights).toBlocking().single().body();
    }

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, List<AccessRights> rights, final ServiceCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName, rights), serviceCallback);
    }

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, List<AccessRights> rights) {
        return createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName, rights).map(new Func1<ServiceResponse<SharedAccessAuthorizationRuleInner>, SharedAccessAuthorizationRuleInner>() {
            @Override
            public SharedAccessAuthorizationRuleInner call(ServiceResponse<SharedAccessAuthorizationRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, List<AccessRights> rights) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rights == null) {
            throw new IllegalArgumentException("Parameter rights is required and cannot be null.");
        }
        Validator.validate(rights);
        SharedAccessAuthorizationRuleInner parameters = new SharedAccessAuthorizationRuleInner();
        parameters.withRights(rights);
        return service.createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, queueName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SharedAccessAuthorizationRuleInner> clientResponse = createOrUpdateAuthorizationRuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SharedAccessAuthorizationRuleInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SharedAccessAuthorizationRuleInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName), serviceCallback);
    }

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteAuthorizationRule(resourceGroupName, namespaceName, queueName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAuthorizationRuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SharedAccessAuthorizationRuleInner object if successful.
     */
    public SharedAccessAuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SharedAccessAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, final ServiceCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName), serviceCallback);
    }

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<SharedAccessAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).map(new Func1<ServiceResponse<SharedAccessAuthorizationRuleInner>, SharedAccessAuthorizationRuleInner>() {
            @Override
            public SharedAccessAuthorizationRuleInner call(ServiceResponse<SharedAccessAuthorizationRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> getAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAuthorizationRule(resourceGroupName, namespaceName, queueName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SharedAccessAuthorizationRuleInner> clientResponse = getAuthorizationRuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SharedAccessAuthorizationRuleInner> getAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SharedAccessAuthorizationRuleInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SharedAccessAuthorizationRuleInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceListKeysInner object if successful.
     */
    public ResourceListKeysInner listKeys(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, final ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName), serviceCallback);
    }

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).map(new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>() {
            @Override
            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ServiceResponse<ResourceListKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeys(resourceGroupName, namespaceName, queueName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceListKeysInner> clientResponse = listKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceListKeysInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourceListKeysInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourceListKeysInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceListKeysInner object if successful.
     */
    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, final ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName), serviceCallback);
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName).map(new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>() {
            @Override
            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ServiceResponse<ResourceListKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Policykey policykey = null;
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(null);
        return service.regenerateKeys(resourceGroupName, namespaceName, queueName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceListKeysInner> clientResponse = regenerateKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceListKeysInner object if successful.
     */
    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, Policykey policykey) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName, policykey).toBlocking().single().body();
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, Policykey policykey, final ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName, policykey), serviceCallback);
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, Policykey policykey) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, queueName, authorizationRuleName, policykey).map(new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>() {
            @Override
            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param queueName The queue name.
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ServiceResponse<ResourceListKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName, Policykey policykey) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(policykey);
        return service.regenerateKeys(resourceGroupName, namespaceName, queueName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceListKeysInner> clientResponse = regenerateKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceListKeysInner> regenerateKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourceListKeysInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourceListKeysInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;QueueInner&gt; object if successful.
     */
    public PagedList<QueueInner> listByNamespaceNext(final String nextPageLink) {
        ServiceResponse<Page<QueueInner>> response = listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<QueueInner>(response.body()) {
            @Override
            public Page<QueueInner> nextPage(String nextPageLink) {
                return listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<QueueInner>> listByNamespaceNextAsync(final String nextPageLink, final ServiceFuture<List<QueueInner>> serviceFuture, final ListOperationCallback<QueueInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByNamespaceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<QueueInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<QueueInner>>> call(String nextPageLink) {
                    return listByNamespaceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;QueueInner&gt; object
     */
    public Observable<Page<QueueInner>> listByNamespaceNextAsync(final String nextPageLink) {
        return listByNamespaceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<QueueInner>>, Page<QueueInner>>() {
                @Override
                public Page<QueueInner> call(ServiceResponse<Page<QueueInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the queues within a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;QueueInner&gt; object
     */
    public Observable<ServiceResponse<Page<QueueInner>>> listByNamespaceNextWithServiceResponseAsync(final String nextPageLink) {
        return listByNamespaceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<QueueInner>>, Observable<ServiceResponse<Page<QueueInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<QueueInner>>> call(ServiceResponse<Page<QueueInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByNamespaceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the queues within a namespace.
     *
    ServiceResponse<PageImpl<QueueInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;QueueInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<QueueInner>>> listByNamespaceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByNamespaceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<QueueInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<QueueInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<QueueInner>> result = listByNamespaceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<QueueInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<QueueInner>> listByNamespaceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<QueueInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<QueueInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object if successful.
     */
    public PagedList<SharedAccessAuthorizationRuleInner> listAuthorizationRulesNext(final String nextPageLink) {
        ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response = listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SharedAccessAuthorizationRuleInner>(response.body()) {
            @Override
            public Page<SharedAccessAuthorizationRuleInner> nextPage(String nextPageLink) {
                return listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextAsync(final String nextPageLink, final ServiceFuture<List<SharedAccessAuthorizationRuleInner>> serviceFuture, final ListOperationCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAuthorizationRulesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(String nextPageLink) {
                    return listAuthorizationRulesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<Page<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextAsync(final String nextPageLink) {
        return listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Page<SharedAccessAuthorizationRuleInner>>() {
                @Override
                public Page<SharedAccessAuthorizationRuleInner> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all authorization rules for a queue.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesNextWithServiceResponseAsync(final String nextPageLink) {
        return listAuthorizationRulesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all authorization rules for a queue.
     *
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAuthorizationRulesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> result = listAuthorizationRulesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SharedAccessAuthorizationRuleInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SharedAccessAuthorizationRuleInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
