/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Namespace/ServiceBus Connection String.
 */
public class ResourceListKeysInner {
    /**
     * Primary connection string of the created namespace authorization rule.
     */
    @JsonProperty(value = "primaryConnectionString")
    private String primaryConnectionString;

    /**
     * Secondary connection string of the created namespace authorization rule.
     */
    @JsonProperty(value = "secondaryConnectionString")
    private String secondaryConnectionString;

    /**
     * A base64-encoded 256-bit primary key for signing and validating the SAS
     * token.
     */
    @JsonProperty(value = "primaryKey")
    private String primaryKey;

    /**
     * A base64-encoded 256-bit secondary key for signing and validating the
     * SAS token.
     */
    @JsonProperty(value = "secondaryKey")
    private String secondaryKey;

    /**
     * A string that describes the authorization rule.
     */
    @JsonProperty(value = "keyName")
    private String keyName;

    /**
     * Get the primaryConnectionString value.
     *
     * @return the primaryConnectionString value
     */
    public String primaryConnectionString() {
        return this.primaryConnectionString;
    }

    /**
     * Set the primaryConnectionString value.
     *
     * @param primaryConnectionString the primaryConnectionString value to set
     * @return the ResourceListKeysInner object itself.
     */
    public ResourceListKeysInner withPrimaryConnectionString(String primaryConnectionString) {
        this.primaryConnectionString = primaryConnectionString;
        return this;
    }

    /**
     * Get the secondaryConnectionString value.
     *
     * @return the secondaryConnectionString value
     */
    public String secondaryConnectionString() {
        return this.secondaryConnectionString;
    }

    /**
     * Set the secondaryConnectionString value.
     *
     * @param secondaryConnectionString the secondaryConnectionString value to set
     * @return the ResourceListKeysInner object itself.
     */
    public ResourceListKeysInner withSecondaryConnectionString(String secondaryConnectionString) {
        this.secondaryConnectionString = secondaryConnectionString;
        return this;
    }

    /**
     * Get the primaryKey value.
     *
     * @return the primaryKey value
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey value.
     *
     * @param primaryKey the primaryKey value to set
     * @return the ResourceListKeysInner object itself.
     */
    public ResourceListKeysInner withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey value.
     *
     * @return the secondaryKey value
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey value.
     *
     * @param secondaryKey the secondaryKey value to set
     * @return the ResourceListKeysInner object itself.
     */
    public ResourceListKeysInner withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the keyName value.
     *
     * @return the keyName value
     */
    public String keyName() {
        return this.keyName;
    }

    /**
     * Set the keyName value.
     *
     * @param keyName the keyName value to set
     * @return the ResourceListKeysInner object itself.
     */
    public ResourceListKeysInner withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

}
