/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.ManagedInstanceEncryptionProtectorInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedInstanceEncryptionProtectorsInner {
    private ManagedInstanceEncryptionProtectorsService service;
    private SqlManagementClientImpl client;

    public ManagedInstanceEncryptionProtectorsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedInstanceEncryptionProtectorsService)retrofit.create(ManagedInstanceEncryptionProtectorsService.class);
        this.client = client;
    }

    public PagedList<ManagedInstanceEncryptionProtectorInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedInstanceEncryptionProtectorInner>((Page)response.body()){

            public Page<ManagedInstanceEncryptionProtectorInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceEncryptionProtectorInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<ManagedInstanceEncryptionProtectorInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> call(String nextPageLink) {
                return ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceEncryptionProtectorInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>, Page<ManagedInstanceEncryptionProtectorInner>>(){

            public Page<ManagedInstanceEncryptionProtectorInner> call(ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>, Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> call(ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceEncryptionProtectorsInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceEncryptionProtectorInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceEncryptionProtectorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceEncryptionProtectorInner get(String resourceGroupName, String managedInstanceName) {
        return (ManagedInstanceEncryptionProtectorInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceEncryptionProtectorInner> getAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<ManagedInstanceEncryptionProtectorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<ManagedInstanceEncryptionProtectorInner> getAsync(String resourceGroupName, String managedInstanceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner>(){

            public ManagedInstanceEncryptionProtectorInner call(ServiceResponse<ManagedInstanceEncryptionProtectorInner> response) {
                return (ManagedInstanceEncryptionProtectorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String encryptionProtectorName = "current";
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, "current", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceEncryptionProtectorsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceEncryptionProtectorInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceEncryptionProtectorInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceEncryptionProtectorInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters) {
        return (ManagedInstanceEncryptionProtectorInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedInstanceEncryptionProtectorInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters, ServiceCallback<ManagedInstanceEncryptionProtectorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceEncryptionProtectorInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner>(){

            public ManagedInstanceEncryptionProtectorInner call(ServiceResponse<ManagedInstanceEncryptionProtectorInner> response) {
                return (ManagedInstanceEncryptionProtectorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String encryptionProtectorName = "current";
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, "current", this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedInstanceEncryptionProtectorInner>(){}.getType());
    }

    public ManagedInstanceEncryptionProtectorInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters) {
        return (ManagedInstanceEncryptionProtectorInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters, ServiceCallback<ManagedInstanceEncryptionProtectorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner>(){

            public ManagedInstanceEncryptionProtectorInner call(ServiceResponse<ManagedInstanceEncryptionProtectorInner> response) {
                return (ManagedInstanceEncryptionProtectorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceEncryptionProtectorInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String encryptionProtectorName = "current";
        String apiVersion = "2017-10-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, "current", this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceEncryptionProtectorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceEncryptionProtectorsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceEncryptionProtectorInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceEncryptionProtectorInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceEncryptionProtectorInner>((Page)response.body()){

            public Page<ManagedInstanceEncryptionProtectorInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceEncryptionProtectorInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<ManagedInstanceEncryptionProtectorInner>> serviceFuture, ListOperationCallback<ManagedInstanceEncryptionProtectorInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> call(String nextPageLink) {
                return ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceEncryptionProtectorInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>, Page<ManagedInstanceEncryptionProtectorInner>>(){

            public Page<ManagedInstanceEncryptionProtectorInner> call(ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>, Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> call(ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceEncryptionProtectorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceEncryptionProtectorsInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceEncryptionProtectorInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceEncryptionProtectorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedInstanceEncryptionProtectorsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceEncryptionProtectors listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceEncryptionProtectors get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector/{encryptionProtectorName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="encryptionProtectorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceEncryptionProtectors createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector/{encryptionProtectorName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="encryptionProtectorName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedInstanceEncryptionProtectorInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceEncryptionProtectors beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector/{encryptionProtectorName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="encryptionProtectorName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedInstanceEncryptionProtectorInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceEncryptionProtectors listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

