/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.sql.ElasticPoolEdition;
import com.microsoft.azure.management.sql.RecommendedElasticPool;
import com.microsoft.azure.management.sql.RecommendedElasticPoolMetric;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolMetricImpl;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolMetricInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class RecommendedElasticPoolImpl
extends RefreshableWrapperImpl<RecommendedElasticPoolInner, RecommendedElasticPool>
implements RecommendedElasticPool {
    private final SqlServerImpl sqlServer;

    protected RecommendedElasticPoolImpl(RecommendedElasticPoolInner innerObject, SqlServerImpl sqlServer) {
        super((Object)innerObject);
        this.sqlServer = sqlServer;
    }

    protected Observable<RecommendedElasticPoolInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.manager().inner())).recommendedElasticPools().getAsync(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    public SqlServerManager manager() {
        return (SqlServerManager)this.sqlServer.manager();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServer.name();
    }

    @Override
    public ElasticPoolEdition databaseEdition() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).databaseEdition();
    }

    @Override
    public double dtu() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).dtu();
    }

    @Override
    public double databaseDtuMin() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).databaseDtuMin();
    }

    @Override
    public double databaseDtuMax() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).databaseDtuMax();
    }

    @Override
    public double storageMB() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).storageMB();
    }

    @Override
    public DateTime observationPeriodStart() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).observationPeriodStart();
    }

    @Override
    public DateTime observationPeriodEnd() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).observationPeriodEnd();
    }

    @Override
    public double maxObservedDtu() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).maxObservedDtu();
    }

    @Override
    public double maxObservedStorageMB() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).maxObservedStorageMB();
    }

    @Override
    public List<SqlDatabase> databases() {
        ArrayList<SqlDatabaseImpl> databases = new ArrayList<SqlDatabaseImpl>();
        for (DatabaseInner databaseInner : ((RecommendedElasticPoolInner)((Object)this.inner())).databases()) {
            databases.add(new SqlDatabaseImpl(databaseInner.name(), this.sqlServer, databaseInner, this.manager()));
        }
        return Collections.unmodifiableList(databases);
    }

    @Override
    public List<SqlDatabase> listDatabases() {
        ArrayList<SqlDatabaseImpl> databasesList = new ArrayList<SqlDatabaseImpl>();
        List<DatabaseInner> databaseInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.sqlServer.manager()).inner())).databases().listByRecommendedElasticPool(this.sqlServer.resourceGroupName(), this.sqlServer.name(), this.name());
        if (databaseInners != null) {
            for (DatabaseInner inner : databaseInners) {
                databasesList.add(new SqlDatabaseImpl(inner.name(), this.sqlServer, inner, this.manager()));
            }
        }
        return Collections.unmodifiableList(databasesList);
    }

    @Override
    public Observable<SqlDatabase> listDatabasesAsync() {
        final RecommendedElasticPoolImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.sqlServer.manager()).inner())).databases().listByRecommendedElasticPoolAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), this.name()).flatMap((Func1)new Func1<List<DatabaseInner>, Observable<DatabaseInner>>(){

            public Observable<DatabaseInner> call(List<DatabaseInner> databaseInners) {
                return Observable.from(databaseInners);
            }
        }).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner databaseInner) {
                return new SqlDatabaseImpl(databaseInner.name(), self.sqlServer, databaseInner, self.manager());
            }
        });
    }

    @Override
    public SqlDatabase getDatabase(String databaseName) {
        DatabaseInner databaseInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.sqlServer.manager()).inner())).databases().getByRecommendedElasticPool(this.sqlServer.resourceGroupName(), this.sqlServer.name(), this.name(), databaseName);
        return new SqlDatabaseImpl(databaseInner.name(), this.sqlServer, databaseInner, this.manager());
    }

    @Override
    public Observable<SqlDatabase> getDatabaseAsync(String databaseName) {
        final RecommendedElasticPoolImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.sqlServer.manager()).inner())).databases().getByRecommendedElasticPoolAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), this.name(), databaseName).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner databaseInner) {
                return new SqlDatabaseImpl(databaseInner.name(), self.sqlServer, databaseInner, self.manager());
            }
        });
    }

    @Override
    public List<RecommendedElasticPoolMetric> listMetrics() {
        ArrayList<RecommendedElasticPoolMetricImpl> recommendedElasticPoolMetrics = new ArrayList<RecommendedElasticPoolMetricImpl>();
        List<RecommendedElasticPoolMetricInner> recommendedElasticPoolMetricInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.sqlServer.manager()).inner())).recommendedElasticPools().listMetrics(this.resourceGroupName(), this.sqlServerName(), this.name());
        if (recommendedElasticPoolMetricInners != null) {
            for (RecommendedElasticPoolMetricInner inner : recommendedElasticPoolMetricInners) {
                recommendedElasticPoolMetrics.add(new RecommendedElasticPoolMetricImpl(inner));
            }
        }
        return Collections.unmodifiableList(recommendedElasticPoolMetrics);
    }

    public String name() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).name();
    }

    public String id() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).id();
    }

    public String resourceGroupName() {
        return this.sqlServer.resourceGroupName();
    }
}

