/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlServerDnsAlias;
import com.microsoft.azure.management.sql.SqlServerDnsAliasOperations;
import com.microsoft.azure.management.sql.implementation.ServerDnsAliasInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerDnsAliasImpl
extends ExternalChildResourceImpl<SqlServerDnsAlias, ServerDnsAliasInner, SqlServerImpl, SqlServer>
implements SqlServerDnsAlias,
SqlServerDnsAliasOperations.SqlServerDnsAliasOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerDnsAliasImpl(String name, SqlServerImpl parent, ServerDnsAliasInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlServerDnsAliasImpl(String resourceGroupName, String sqlServerName, String name, ServerDnsAliasInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlServerDnsAliasImpl(String name, ServerDnsAliasInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((ServerDnsAliasInner)((Object)this.inner())).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String azureDnsRecord() {
        return ((ServerDnsAliasInner)((Object)this.inner())).azureDnsRecord();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((ServerDnsAliasInner)((Object)this.inner())).id());
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverDnsAliases().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    @Override
    public SqlServerDnsAliasImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlServerDnsAliasImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlServerDnsAliasImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    public Observable<SqlServerDnsAlias> createResourceAsync() {
        final SqlServerDnsAliasImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverDnsAliases().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.name()).map((Func1)new Func1<ServerDnsAliasInner, SqlServerDnsAlias>(){

            public SqlServerDnsAlias call(ServerDnsAliasInner serverDnsAliasInner) {
                self.setInner((Object)serverDnsAliasInner);
                return self;
            }
        });
    }

    public Observable<SqlServerDnsAlias> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverDnsAliases().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    protected Observable<ServerDnsAliasInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverDnsAliases().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }
}

