/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.storage.BlobRestoreProgressStatus;
import com.microsoft.azure.management.storage.BlobRestoreParameters;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Blob restore status.
 */
public class BlobRestoreStatusInner {
    /**
     * The status of blob restore progress. Possible values are: - InProgress:
     * Indicates that blob restore is ongoing. - Complete: Indicates that blob
     * restore has been completed successfully. - Failed: Indicates that blob
     * restore is failed. Possible values include: 'InProgress', 'Complete',
     * 'Failed'.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private BlobRestoreProgressStatus status;

    /**
     * Failure reason when blob restore is failed.
     */
    @JsonProperty(value = "failureReason", access = JsonProperty.Access.WRITE_ONLY)
    private String failureReason;

    /**
     * Id for tracking blob restore request.
     */
    @JsonProperty(value = "restoreId", access = JsonProperty.Access.WRITE_ONLY)
    private String restoreId;

    /**
     * Blob restore request parameters.
     */
    @JsonProperty(value = "parameters", access = JsonProperty.Access.WRITE_ONLY)
    private BlobRestoreParameters parameters;

    /**
     * Get the status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. - Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is failed. Possible values include: 'InProgress', 'Complete', 'Failed'.
     *
     * @return the status value
     */
    public BlobRestoreProgressStatus status() {
        return this.status;
    }

    /**
     * Get failure reason when blob restore is failed.
     *
     * @return the failureReason value
     */
    public String failureReason() {
        return this.failureReason;
    }

    /**
     * Get id for tracking blob restore request.
     *
     * @return the restoreId value
     */
    public String restoreId() {
        return this.restoreId;
    }

    /**
     * Get blob restore request parameters.
     *
     * @return the parameters value
     */
    public BlobRestoreParameters parameters() {
        return this.parameters;
    }

}
